/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.Ships;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class PacketPilotShip
extends Packet<PacketPilotShip> {
    private int m_entityId;
    private int m_actions;
    private BlockSide m_sideShipForward;
    private int m_linearThrottle;
    private int m_angularThrottle;

    public PacketPilotShip() {
    }

    public PacketPilotShip(int entityId, int actions, BlockSide sideFacingPlayer, int linearThrottle, int angularThrottle) {
        this.m_entityId = entityId;
        this.m_actions = actions;
        this.m_sideShipForward = sideFacingPlayer;
        this.m_linearThrottle = linearThrottle;
        this.m_angularThrottle = angularThrottle;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_entityId);
        buf.writeInt(this.m_actions);
        buf.writeByte(this.m_sideShipForward.ordinal());
        buf.writeByte(this.m_linearThrottle);
        buf.writeByte(this.m_angularThrottle);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_entityId = buf.readInt();
        this.m_actions = buf.readInt();
        this.m_sideShipForward = BlockSide.values()[buf.readByte()];
        this.m_linearThrottle = buf.readByte();
        this.m_angularThrottle = buf.readByte();
    }

    @Override
    public IMessageHandler<PacketPilotShip, IMessage> getServerHandler() {
        return new IMessageHandler<PacketPilotShip, IMessage>(){

            public IMessage onMessage(PacketPilotShip message, MessageContext ctx) {
                return message.onReceivedServer(ctx.getServerHandler());
            }
        };
    }

    private IMessage onReceivedServer(NetHandlerPlayServer netServer) {
        EntityShip ship = ShipLocator.getShip(netServer.field_147369_b.field_70170_p, this.m_entityId);
        if (ship == null) {
            return null;
        }
        this.applyActions(ship);
        Ships.net.getDispatch().sendToAllAround((IMessage)this, new NetworkRegistry.TargetPoint(netServer.field_147369_b.field_70170_p.field_73011_w.field_76574_g, ship.field_70165_t, ship.field_70163_u, ship.field_70161_v, 100.0));
        return null;
    }

    @Override
    public IMessageHandler<PacketPilotShip, IMessage> getClientHandler() {
        return new IMessageHandler<PacketPilotShip, IMessage>(){

            public IMessage onMessage(PacketPilotShip message, MessageContext ctx) {
                return message.onReceivedClient(ctx.getClientHandler());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage onReceivedClient(NetHandlerPlayClient netClient) {
        EntityShip ship = ShipLocator.getShip((World)Minecraft.func_71410_x().field_71441_e, this.m_entityId);
        if (ship == null) {
            return null;
        }
        this.applyActions(ship);
        return null;
    }

    private void applyActions(EntityShip ship) {
        ship.setPilotActions(this.m_actions, this.m_sideShipForward, false);
        ship.linearThrottle = this.m_linearThrottle;
        ship.angularThrottle = this.m_angularThrottle;
    }
}

