/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.ShipClipboard;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.PersistenceException;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.NetHandlerPlayServer;
import org.apache.commons.codec.binary.Base64;

public class PacketPasteShip
extends Packet<PacketPasteShip> {
    public static final int MaxSize = 0x100000;
    private byte[] m_encodedBlocks;
    private int m_dx;
    private int m_dy;
    private int m_dz;

    public PacketPasteShip() {
    }

    public PacketPasteShip(String encodedBlocks, int dx, int dy, int dz) {
        this.m_encodedBlocks = Base64.decodeBase64((String)encodedBlocks);
        if (this.m_encodedBlocks.length > 0x100000) {
            throw new IllegalArgumentException("Ship description size exceeds 1048576 bytes. If this is a legitimate use, we need a bigger size");
        }
        this.m_dx = dx;
        this.m_dy = dy;
        this.m_dz = dz;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_encodedBlocks.length);
        buf.writeBytes(this.m_encodedBlocks);
        buf.writeInt(this.m_dx);
        buf.writeInt(this.m_dy);
        buf.writeInt(this.m_dz);
    }

    public void fromBytes(ByteBuf buf) {
        int dataSize = buf.readInt();
        if (dataSize <= 0x100000) {
            this.m_encodedBlocks = new byte[dataSize];
            buf.readBytes(this.m_encodedBlocks);
        }
        this.m_dx = buf.readInt();
        this.m_dy = buf.readInt();
        this.m_dz = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketPasteShip, IMessage> getServerHandler() {
        return new IMessageHandler<PacketPasteShip, IMessage>(){

            public IMessage onMessage(PacketPasteShip message, MessageContext ctx) {
                return message.onReceivedServer(ctx.getServerHandler());
            }
        };
    }

    private IMessage onReceivedServer(NetHandlerPlayServer netServer) {
        if (this.m_encodedBlocks == null) {
            return null;
        }
        try {
            ShipClipboard.restoreShip(netServer.field_147369_b.field_70170_p, Base64.encodeBase64String((byte[])this.m_encodedBlocks), new Coords(this.m_dx, this.m_dy, this.m_dz));
        }
        catch (PersistenceException ex) {
            Ships.logger.warning(ex, "Unable to restore ship!", new Object[0]);
        }
        return null;
    }
}

