/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.Ships;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.World;

public class PacketLaunchShip
extends Packet<PacketLaunchShip> {
    private int m_x;
    private int m_y;
    private int m_z;

    public PacketLaunchShip() {
    }

    public PacketLaunchShip(Coords coords) {
        this.m_x = coords.x;
        this.m_y = coords.y;
        this.m_z = coords.z;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.m_x);
        buf.writeInt(this.m_y);
        buf.writeInt(this.m_z);
    }

    public void fromBytes(ByteBuf buf) {
        this.m_x = buf.readInt();
        this.m_y = buf.readInt();
        this.m_z = buf.readInt();
    }

    @Override
    public IMessageHandler<PacketLaunchShip, IMessage> getServerHandler() {
        return new IMessageHandler<PacketLaunchShip, IMessage>(){

            public IMessage onMessage(PacketLaunchShip message, MessageContext ctx) {
                return message.onReceivedServer(ctx.getServerHandler());
            }
        };
    }

    private IMessage onReceivedServer(NetHandlerPlayServer netServer) {
        World world = netServer.field_147369_b.field_70170_p;
        ShipLauncher launcher = new ShipLauncher(world, new Coords(this.m_x, this.m_y, this.m_z));
        if (launcher.isLaunchable()) {
            launcher.launch();
        } else {
            Ships.logger.warning("Server can't launch ship at: (%d,%d,%d)", this.m_x, this.m_y, this.m_z);
            for (ShipLauncher.LaunchFlag flag : ShipLauncher.LaunchFlag.values()) {
                Ships.logger.warning("\t" + flag.name() + ": " + launcher.getLaunchFlag(flag), new Object[0]);
            }
        }
        return null;
    }
}

