/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.packets;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.net.Packet;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipWorld;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.world.World;

public class PacketChangedBlocks
extends Packet<PacketChangedBlocks> {
    private BlockSet m_changedBlocks;
    private EntityShip m_ship;
    private int m_entityId;
    private int m_numChangedBlocks;
    private int[] m_x;
    private int[] m_y;
    private int[] m_z;
    private Block[] m_blocks;
    private int[] m_meta;

    public PacketChangedBlocks() {
    }

    public PacketChangedBlocks(EntityShip ship, BlockSet changedBlocks) {
        this.m_changedBlocks = changedBlocks;
        this.m_ship = ship;
    }

    public void toBytes(ByteBuf buf) {
        ShipWorld world = this.m_ship.getShipWorld();
        buf.writeInt(this.m_ship.func_145782_y());
        buf.writeInt(this.m_changedBlocks.size());
        for (Coords coords : this.m_changedBlocks) {
            buf.writeShort(coords.x);
            buf.writeShort(coords.y);
            buf.writeShort(coords.z);
            buf.writeShort(Block.func_149682_b((Block)world.getBlock(coords)));
            buf.writeByte(world.getBlockMetadata(coords));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.m_entityId = buf.readInt();
        this.m_numChangedBlocks = buf.readInt();
        this.m_x = new int[this.m_numChangedBlocks];
        this.m_y = new int[this.m_numChangedBlocks];
        this.m_z = new int[this.m_numChangedBlocks];
        this.m_blocks = new Block[this.m_numChangedBlocks];
        this.m_meta = new int[this.m_numChangedBlocks];
        for (int i = 0; i < this.m_numChangedBlocks; ++i) {
            this.m_x[i] = buf.readShort();
            this.m_y[i] = buf.readShort();
            this.m_z[i] = buf.readShort();
            this.m_blocks[i] = Block.func_149729_e((int)buf.readShort());
            this.m_meta[i] = buf.readByte();
        }
    }

    @Override
    public IMessageHandler<PacketChangedBlocks, IMessage> getClientHandler() {
        return new IMessageHandler<PacketChangedBlocks, IMessage>(){

            public IMessage onMessage(PacketChangedBlocks message, MessageContext ctx) {
                return message.onReceivedClient(ctx.getClientHandler());
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    private IMessage onReceivedClient(NetHandlerPlayClient netClient) {
        EntityShip ship = ShipLocator.getShip((World)Minecraft.func_71410_x().field_71441_e, this.m_entityId);
        if (ship == null) {
            return null;
        }
        ShipWorld world = ship.getShipWorld();
        for (int i = 0; i < this.m_numChangedBlocks; ++i) {
            world.applyBlockChange(this.m_x[i], this.m_y[i], this.m_z[i], this.m_blocks[i], this.m_meta[i]);
        }
        return null;
    }
}

