/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cuchaz.ships.ShipType;
import cuchaz.ships.Ships;
import cuchaz.ships.Supporters;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public enum SupporterPlaqueType {
    Small(16, 2, "Cuchaz Interactive Supporter Plaque"){

        @Override
        public void registerRecipe() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{" y ", " x ", "zzz", Character.valueOf('x'), ShipType.Tiny.newItemStack(), Character.valueOf('y'), new ItemStack(Items.field_151042_j), Character.valueOf('z'), new ItemStack(Blocks.field_150344_f)});
        }
    }
    ,
    Large(32, 3, "Cuchaz Interactive Supporter Plaque (Large)"){

        @Override
        public void registerRecipe() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"yyy", "zxz", "zzz", Character.valueOf('x'), ShipType.Tiny.newItemStack(), Character.valueOf('y'), new ItemStack(Items.field_151042_j), Character.valueOf('z'), new ItemStack(Blocks.field_150344_f)});
        }
    };

    private int m_size;
    private int m_minRank;
    private String m_itemName;
    private ResourceLocation m_texture;

    private SupporterPlaqueType(int size, int minRank, String itemName) {
        this.m_size = size;
        this.m_minRank = minRank;
        this.m_itemName = itemName;
        this.m_texture = new ResourceLocation("ships", String.format("textures/blocks/supporterPlaque-%s.png", this.name().toLowerCase()));
    }

    public int getSize() {
        return this.m_size;
    }

    public int getMinRank() {
        return this.m_minRank;
    }

    public String getItemName() {
        return this.m_itemName;
    }

    public ResourceLocation getTexture() {
        return this.m_texture;
    }

    public int getMeta() {
        return this.ordinal();
    }

    public static SupporterPlaqueType getByMeta(int meta) {
        return SupporterPlaqueType.values()[meta];
    }

    public ItemStack newItemStack() {
        return new ItemStack((Item)Ships.m_itemSupporterPlaque, 1, this.getMeta());
    }

    public static void registerRecipes() {
        for (SupporterPlaqueType type : SupporterPlaqueType.values()) {
            type.registerRecipe();
        }
    }

    public boolean canUse(EntityPlayer player) {
        int supporterId = Supporters.getId(player.func_70005_c_());
        return supporterId != -1 && Supporters.getRank(supporterId) >= this.m_minRank;
    }

    public abstract void registerRecipe();
}

