/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.ShipType;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.packets.PacketEraseShip;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemShipEraser
extends Item {
    public ItemShipEraser() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b("cuchaz.ships.shipEraser");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("ships:shipEraser");
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int blockX, int blockY, int blockZ, int side, float hitX, float hitY, float hitZ) {
        if (world.func_147439_a(blockX, blockY, blockZ) == Ships.m_blockShip) {
            return ItemShipEraser.eraseShip(world, player, blockX, blockY, blockZ);
        }
        ItemShipEraser.message(player, GuiString.EraserUsage, new Object[0]);
        return false;
    }

    public static boolean eraseShip(final World world, EntityPlayer player, int blockX, int blockY, int blockZ) {
        if (!player.field_71075_bZ.field_75098_d) {
            ItemShipEraser.message(player, GuiString.OnlyCreative, new Object[0]);
            return false;
        }
        ShipType shipType = Ships.m_blockShip.getShipType(world, blockX, blockY, blockZ);
        BlockSet blocks = BlockUtils.searchForBlocks(blockX, blockY, blockZ, shipType.getMaxNumBlocks(), new BlockUtils.BlockExplorer(){

            @Override
            public boolean shouldExploreBlock(Coords coords) {
                return !BlockProperties.isSeparator(world.func_147439_a(coords.x, coords.y, coords.z));
            }
        }, ShipLauncher.ShipBlockNeighbors);
        if (blocks == null) {
            ItemShipEraser.message(player, GuiString.NoShipWasFoundHere, new Object[0]);
            return false;
        }
        if (Environment.isClient()) {
            Ships.net.getDispatch().sendToServer((IMessage)new PacketEraseShip(blockX, blockY, blockZ));
        } else {
            Coords shipCoords = new Coords(blockX, blockY, blockZ);
            blocks.add(shipCoords);
            ShipLauncher.removeShipFromWorld(world, new ShipWorld(world, shipCoords, blocks), shipCoords, BlockUtils.UpdateRules.UpdateClients);
        }
        return true;
    }

    private static void message(EntityPlayer player, GuiString text, Object ... args) {
        if (Environment.isClient()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(text.getLocalizedText(), args));
        }
    }
}

