/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.ShipClipboard;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.ShipType;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.packets.PacketPasteShip;
import cuchaz.ships.persistence.PersistenceException;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemShipClipboard
extends Item {
    public ItemShipClipboard() {
        this.field_77777_bU = 1;
        this.func_77637_a(CreativeTabs.field_78040_i);
        this.func_77655_b("cuchaz.ships.shipClipboard");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("ships:shipClipboard");
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Environment.isServer()) {
            return itemStack;
        }
        boolean IntersectWater = true;
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null || movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return itemStack;
        }
        int x = movingobjectposition.field_72311_b;
        int y = movingobjectposition.field_72312_c;
        int z = movingobjectposition.field_72309_d;
        if (BlockProperties.isWater(world.func_147439_a(x, y, z))) {
            this.pasteShip(world, player, x, y, z);
        } else {
            this.message(player, GuiString.ClipboardUsage, new Object[0]);
        }
        return itemStack;
    }

    public boolean onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, int blockX, int blockY, int blockZ, int side, float hitX, float hitY, float hitZ) {
        if (Environment.isServer()) {
            return false;
        }
        if (world.func_147439_a(blockX, blockY, blockZ) == Ships.m_blockShip) {
            return this.copyShip(world, player, blockX, blockY, blockZ);
        }
        return false;
    }

    private boolean copyShip(final World world, EntityPlayer player, int blockX, int blockY, int blockZ) {
        ShipType shipType = Ships.m_blockShip.getShipType(world, blockX, blockY, blockZ);
        BlockSet blocks = BlockUtils.searchForBlocks(blockX, blockY, blockZ, shipType.getMaxNumBlocks(), new BlockUtils.BlockExplorer(){

            @Override
            public boolean shouldExploreBlock(Coords coords) {
                return !BlockProperties.isSeparator(world.func_147439_a(coords.x, coords.y, coords.z));
            }
        }, ShipLauncher.ShipBlockNeighbors);
        if (blocks == null) {
            this.message(player, GuiString.NoShipWasFoundHere, new Object[0]);
            return false;
        }
        Coords shipCoords = new Coords(blockX, blockY, blockZ);
        blocks.add(shipCoords);
        ShipClipboard.saveShipWorld(new ShipWorld(world, shipCoords, blocks));
        this.message(player, GuiString.CopiedShip, new Object[0]);
        return true;
    }

    private boolean pasteShip(World world, EntityPlayer player, int blockX, int blockY, int blockZ) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.message(player, GuiString.OnlyCreative, new Object[0]);
            return false;
        }
        try {
            String encodedBlocks = ShipClipboard.getBlocks();
            if (encodedBlocks == null) {
                this.message(player, GuiString.NoShipOnClipboard, new Object[0]);
                return false;
            }
            ShipWorld shipWorld = ShipClipboard.createShipWorld(world, encodedBlocks);
            BoundingBoxInt shipBox = shipWorld.getBoundingBox();
            BoundingBoxInt box = new BoundingBoxInt(shipBox);
            int dx = box.getDx();
            int dy = box.getDy();
            int dz = box.getDz();
            box.minY = blockY + 1;
            box.maxY = blockY + dy;
            for (int x = 0; x < dx; ++x) {
                box.minX = blockX - x;
                box.maxX = blockX + dx - 1;
                for (int z = 0; z < dz; ++z) {
                    box.minZ = blockZ - z;
                    box.maxZ = blockZ + dz - 1;
                    if (!this.isBoxAndShellEmpty(world, box)) continue;
                    int tx = box.minX - shipBox.minX;
                    int ty = box.minY - shipBox.minY;
                    int tz = box.minZ - shipBox.minZ;
                    Ships.net.getDispatch().sendToServer((IMessage)new PacketPasteShip(encodedBlocks, tx, ty, tz));
                    this.message(player, GuiString.PastedShip, new Object[0]);
                    return true;
                }
            }
            this.message(player, GuiString.NoRoomToPasteShip, dx, dy, dz);
            return false;
        }
        catch (PersistenceException ex) {
            Ships.logger.error(ex, "Could not reconstruct ship from data", new Object[0]);
            this.message(player, GuiString.ShipDataCorrupted, new Object[0]);
            return false;
        }
    }

    private boolean isBoxAndShellEmpty(World world, BoundingBoxInt box) {
        for (int x = box.minX - 1; x <= box.maxX + 1; ++x) {
            for (int y = box.minY - 1; y <= box.maxY + 1; ++y) {
                for (int z = box.minZ - 1; z <= box.maxZ + 1; ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == Blocks.field_150350_a || BlockProperties.isWater(block)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void message(EntityPlayer player, GuiString text, Object ... args) {
        if (Environment.isClient()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(text.getLocalizedText(), args));
        }
    }
}

