/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.items;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.ships.ShipClipboard;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.TileEntityProjector;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.packets.PacketPlaceProjector;
import cuchaz.ships.persistence.PersistenceException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ItemProjector
extends ItemBlock {
    public ItemProjector(Block block) {
        super(block);
        this.func_77625_d(1);
        this.func_77655_b("shipProjector");
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (Environment.isServer()) {
            return itemStack;
        }
        try {
            boolean IntersectWater = true;
            MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
            if (movingobjectposition == null || movingobjectposition.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
                return itemStack;
            }
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            BlockSide side = BlockSide.getById(movingobjectposition.field_72310_e);
            if (!BlockProperties.isWater(world.func_147439_a(x, y, z)) || side != BlockSide.Top) {
                this.clientMessage(player, GuiString.TryOnStillWater, new Object[0]);
                return itemStack;
            }
            String encodedBlocks = ShipClipboard.getBlocks();
            if (encodedBlocks == null) {
                this.clientMessage(player, GuiString.NoShipOnClipboard, new Object[0]);
                return itemStack;
            }
            ShipWorld shipWorld = ShipClipboard.createShipWorld(world, encodedBlocks);
            ItemProjector.placeProjector(world, x, y + 1, z, shipWorld);
            Ships.net.getDispatch().sendToServer((IMessage)new PacketPlaceProjector(encodedBlocks, x, y + 1, z));
            if (!player.field_71075_bZ.field_75098_d) {
                --itemStack.field_77994_a;
            }
            return itemStack;
        }
        catch (PersistenceException ex) {
            this.clientMessage(player, GuiString.NoShipOnClipboard, new Object[0]);
            return itemStack;
        }
    }

    public static void placeProjector(World world, int x, int y, int z, ShipWorld shipWorld) {
        world.func_147449_b(x, y, z, (Block)Ships.m_blockProjector);
        TileEntityProjector tileEntity = (TileEntityProjector)world.func_147438_o(x, y, z);
        tileEntity.setShipWorld(shipWorld);
    }

    public boolean func_77648_a(ItemStack itemStack, EntityPlayer player, World world, int x, int y, int z, int sideId, float hitX, float hitY, float hitZ) {
        return false;
    }

    private void clientMessage(EntityPlayer player, GuiString text, Object ... args) {
        if (Environment.isClient()) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(text.getLocalizedText(), args));
        }
    }
}

