/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cuchaz.modsShared.ColorUtils;
import cuchaz.modsShared.Util;
import cuchaz.modsShared.blocks.BlockArray;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.gui.GuiShip;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.propulsion.Propulsion;
import cuchaz.ships.render.RenderShip2D;
import cuchaz.ships.render.ShaderLoader;
import java.io.IOException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL20;

public class GuiShipPropulsion
extends GuiShip {
    private static final ResourceLocation DesaturationShader = new ResourceLocation("ships", "shaders/desaturate.frag");
    private ShipLauncher m_shipLauncher = null;
    private Propulsion m_propulsion;
    private BlockArray m_shipEnvelope = null;
    private BlockArray m_helmEnvelope = null;
    private BlockArray m_propulsionEnvelope = null;
    private int m_desaturationProgramId = 0;
    private double m_topLinearSpeed = 0.0;
    private double m_topAngularSpeed = 0.0;
    private String m_propulsionMethodsDescription;

    public GuiShipPropulsion(final World world, int helmX, int helmY, int helmZ) {
        String methods;
        assert (world.func_147439_a(helmX, helmY, helmZ) == Ships.m_blockHelm);
        Coords helmCoords = new Coords(helmX, helmY, helmZ);
        Coords shipBlockCoords = BlockUtils.searchForBlock(helmX, helmY, helmZ, 10000, new BlockUtils.BlockConditionChecker(){

            @Override
            public boolean isConditionMet(Coords coords) {
                return world.func_147439_a(coords.x, coords.y, coords.z) == Ships.m_blockShip;
            }
        }, new BlockUtils.BlockExplorer(){

            @Override
            public boolean shouldExploreBlock(Coords coords) {
                return !BlockProperties.isSeparator(world.func_147439_a(coords.x, coords.y, coords.z));
            }
        }, BlockUtils.Neighbors.Edges);
        if (shipBlockCoords == null) {
            return;
        }
        this.m_shipLauncher = new ShipLauncher(world, shipBlockCoords);
        if (this.m_shipLauncher.getShipWorld() == null) {
            return;
        }
        if (this.m_shipLauncher.getShipType().isPaddleable()) {
            return;
        }
        this.m_shipEnvelope = this.m_shipLauncher.getShipEnvelope(BlockSide.Top);
        helmCoords.x -= shipBlockCoords.x;
        helmCoords.y -= shipBlockCoords.y;
        helmCoords.z -= shipBlockCoords.z;
        this.m_helmEnvelope = this.m_shipEnvelope.newEmptyCopy();
        this.m_helmEnvelope.setBlock(helmCoords.x, helmCoords.z, helmCoords);
        this.m_propulsion = new Propulsion(this.m_shipLauncher.getShipWorld().getBlocksStorage());
        this.m_propulsionEnvelope = this.m_propulsion.getEnevelope();
        if (ShaderLoader.areShadersSupported()) {
            try {
                this.m_desaturationProgramId = ShaderLoader.createProgram(ShaderLoader.load(DesaturationShader));
            }
            catch (IOException ex) {
                Ships.logger.warning(ex, "Unable to load shader!", new Object[0]);
            }
        }
        this.m_topLinearSpeed = 0.0;
        this.m_topAngularSpeed = 0.0;
        if (this.m_shipLauncher.getShipPhysics().willItFloat()) {
            this.m_topLinearSpeed = this.m_shipLauncher.getShipPhysics().simulateLinearAcceleration((Propulsion)this.m_propulsion).topSpeed;
            this.m_topAngularSpeed = this.m_shipLauncher.getShipPhysics().simulateAngularAcceleration((Propulsion)this.m_propulsion).topSpeed;
        }
        this.m_propulsionMethodsDescription = (methods = this.m_propulsion.dumpMethods()).equals("") ? GuiString.NoPropulsion.getLocalizedText() : String.format(GuiString.FoundPropulsion.getLocalizedText(), methods);
    }

    @Override
    protected void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        this.drawHeaderText(GuiString.ShipPropulsion.getLocalizedText(), 0);
        if (this.m_shipLauncher == null) {
            this.drawText(GuiString.NoShipBlock.getLocalizedText(), 1);
        } else if (this.m_propulsion == null) {
            this.drawText(GuiString.InvalidShip.getLocalizedText(), 1);
        } else {
            this.drawLabelValueText("Ship Mass", String.format("%.1f tonnes", this.m_shipLauncher.getShipPhysics().getMass()), 1);
            this.drawLabelValueText("Thrust", String.format("%.1f KN", Util.perTick2ToPerSecond2(this.m_propulsion.getTotalThrust(0.0))), 2);
            this.drawLabelValueText("Top Speed", String.format("%.1f m/s", Util.perTickToPerSecond(this.m_topLinearSpeed)), 3);
            this.drawLabelValueText("Turning Speed", String.format("%.1f deg/s", Util.perTickToPerSecond(this.m_topAngularSpeed)), 4);
            this.drawPropulsion();
            this.drawText(this.m_propulsionMethodsDescription, 12);
        }
    }

    private void drawPropulsion() {
        int x = 8;
        int y = this.getLineY(6);
        int width = this.m_width - 16;
        int height = 64;
        RenderShip2D.drawWater(x, y, this.field_73735_i, width, height);
        if (this.m_shipEnvelope.getHeight() > this.m_shipEnvelope.getWidth()) {
            this.m_shipEnvelope = BlockArray.Rotation.Ccw90.rotate(this.m_shipEnvelope);
            this.m_helmEnvelope = BlockArray.Rotation.Ccw90.rotate(this.m_helmEnvelope);
            this.m_propulsionEnvelope = BlockArray.Rotation.Ccw90.rotate(this.m_propulsionEnvelope);
        }
        RenderShip2D.drawShipAsColor(this.m_shipEnvelope, ColorUtils.getGrey(64), x, y, this.field_73735_i, width, height);
        if (ShaderLoader.areShadersSupported()) {
            GL20.glUseProgram((int)this.m_desaturationProgramId);
            RenderShip2D.drawShip(this.m_shipEnvelope, BlockSide.Top, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
            GL20.glUseProgram((int)0);
        } else {
            RenderShip2D.drawShip(this.m_shipEnvelope, BlockSide.Top, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
        }
        RenderShip2D.drawShip(this.m_propulsionEnvelope, BlockSide.Top, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
        RenderShip2D.drawShip(this.m_helmEnvelope, BlockSide.Top, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
    }
}

