/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cuchaz.modsShared.ColorUtils;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.math.CircleRange;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PilotAction;
import cuchaz.ships.gui.GuiShipPilot;
import java.util.Arrays;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiShipPilotSurface
extends GuiShipPilot {
    private static final int TextureWidth = 256;
    private static final int TextureHeight = 256;
    private static final int CompassHeight = 12;
    private static final int CompassY = 52;
    private static final int CompassFrameX = 156;
    private static final int CompassFrameY = 6;
    private static final int CompassFrameWidth = 93;
    private static final int CompassNorthOffset = 5;
    private static final int CompassMarkerX = 201;
    private static final int CompassMarkerY = 31;
    private static final int CompassMarkerWidth = 3;
    private static final int CompassMarkerHeight = 4;
    private static final int CompassRangeX = 8;
    private static final int CompassRangeY = 39;
    private static final int CompassRangeWidth = 16;
    private static final int ThrottleX = 8;
    private static final int ThrottleY = 26;
    private static final int ThrottleZero = 12;
    private static final int ThrottleWidth = 37;
    private static final int ThrottleHeight = 12;
    private static final int ThrottleFrameX = 8;
    private static final int ThrottleFrameY = 6;

    public GuiShipPilotSurface(EntityShip ship, EntityPlayer player) {
        super(256, 25, new ResourceLocation("ships", "textures/gui/shipPilotSurface.png"), ship, player, Arrays.asList(PilotAction.ThrottleUp, PilotAction.ThrottleDown, PilotAction.Left, PilotAction.Right), GuiShipPilot.ForwardSideMethod.ByHelm);
    }

    @Override
    protected void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        BlockSide forwardSide = this.getForwardSide();
        if (forwardSide == null) {
            this.field_146297_k.field_71466_p.func_78276_b("Ship is corrupt! Can't pilot!", 48, 8, ColorUtils.getColor(255, 0, 0));
            return;
        }
        KeyBinding keyForward = this.field_146297_k.field_71474_y.field_74351_w;
        KeyBinding keyBack = this.field_146297_k.field_71474_y.field_74368_y;
        KeyBinding keyLeft = this.field_146297_k.field_71474_y.field_74370_x;
        KeyBinding keyRight = this.field_146297_k.field_71474_y.field_74366_z;
        int textColor = ColorUtils.getGrey(64);
        int TextOffset = 44;
        this.field_146297_k.field_71466_p.func_78276_b(this.getKeyName(keyForward), 55, 8, textColor);
        this.field_146297_k.field_71466_p.func_78276_b(this.getKeyName(keyBack), 90, 8, textColor);
        this.field_146297_k.field_71466_p.func_78276_b(this.getKeyName(keyLeft), 105, 8, textColor);
        this.field_146297_k.field_71466_p.func_78276_b(this.getKeyName(keyRight), 139, 8, textColor);
        this.bindBackgroundTexture();
        double shipDirectionOffset = (double)forwardSide.getXZOffset() / 4.0;
        double shipYawOffset = CircleRange.mapZeroTo360(this.getShip().field_70177_z) / 360.0f;
        double compassFrameOffset = 0.181640625;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        double z = this.field_73735_i;
        double umin = 0.01953125 + shipDirectionOffset - shipYawOffset - compassFrameOffset;
        double umax = umin + 0.36328125;
        double vmin = 0.203125;
        double vmax = 0.25;
        double x = 156.0;
        double y = 6.0;
        tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
        tessellator.func_78374_a(x + 93.0, y + 12.0, z, umax, vmax);
        tessellator.func_78374_a(x + 93.0, y, z, umax, vmin);
        tessellator.func_78374_a(x, y, z, umin, vmin);
        umin = 0.0625 - shipYawOffset - compassFrameOffset;
        umax = umin + 0.36328125;
        vmin = 0.15234375;
        vmax = vmin + 0.046875;
        x = 156.0;
        y = 6.0;
        tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
        tessellator.func_78374_a(x + 93.0, y + 12.0, z, umax, vmax);
        tessellator.func_78374_a(x + 93.0, y, z, umax, vmin);
        tessellator.func_78374_a(x, y, z, umin, vmin);
        umin = 0.78515625;
        umax = umin + 0.01171875;
        vmin = 0.12109375;
        vmax = vmin + 0.015625;
        x = 201.0;
        y = 4.0;
        tessellator.func_78374_a(x, y + 4.0, z, umin, vmax);
        tessellator.func_78374_a(x + 3.0, y + 4.0, z, umax, vmax);
        tessellator.func_78374_a(x + 3.0, y, z, umax, vmin);
        tessellator.func_78374_a(x, y, z, umin, vmin);
        if (this.getShip().linearThrottle > 0) {
            double fullWidth = 32.0;
            double throttleWidth = fullWidth * (double)this.getShip().linearThrottle / 100.0;
            umin = 0.05078125;
            umax = umin + throttleWidth / 256.0;
            vmin = 0.1015625;
            vmax = vmin + 0.046875;
            x = 13.0;
            y = 6.0;
            tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
            tessellator.func_78374_a(x + throttleWidth, y + 12.0, z, umax, vmax);
            tessellator.func_78374_a(x + throttleWidth, y, z, umax, vmin);
            tessellator.func_78374_a(x, y, z, umin, vmin);
        } else if (this.getShip().linearThrottle < 0) {
            double fullWidth = 4.0;
            double throttleWidth = fullWidth * (double)this.getShip().linearThrottle / -25.0;
            umax = 0.04296875;
            umin = umax - (throttleWidth - 1.0) / 256.0;
            vmin = 0.1015625;
            vmax = vmin + 0.046875;
            x = 8.0 + fullWidth - throttleWidth;
            y = 6.0;
            tessellator.func_78374_a(x, y + 12.0, z, umin, vmax);
            tessellator.func_78374_a(x + throttleWidth, y + 12.0, z, umax, vmax);
            tessellator.func_78374_a(x + throttleWidth, y, z, umax, vmin);
            tessellator.func_78374_a(x, y, z, umin, vmin);
        }
        tessellator.func_78381_a();
    }

    private String getKeyName(KeyBinding key) {
        return GameSettings.func_74298_c((int)key.func_151463_i());
    }
}

