/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.gui.GuiBase;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PilotAction;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public abstract class GuiShipPilot
extends GuiBase {
    private EntityShip m_ship;
    private List<PilotAction> m_allowedActions;
    private int m_lastActions;
    private BlockSide m_forwardSide;

    protected GuiShipPilot(int width, int height, ResourceLocation background, EntityShip ship, EntityPlayer player, List<PilotAction> allowedActions, ForwardSideMethod forwardSideMethod) {
        super(width, height, background, false);
        this.m_ship = ship;
        this.m_allowedActions = allowedActions;
        this.m_lastActions = 0;
        this.m_forwardSide = forwardSideMethod.compute(ship, player);
    }

    protected EntityShip getShip() {
        return this.m_ship;
    }

    protected BlockSide getForwardSide() {
        return this.m_forwardSide;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.setPos((this.field_146294_l - this.m_width) / 2, this.field_146295_m - this.m_height - 48);
        this.field_146291_p = true;
        this.field_146297_k.field_71415_G = true;
        this.field_146297_k.field_71417_B.func_74372_a();
        PilotAction.setActionCodes(this.field_146297_k.field_71474_y);
    }

    public void func_73876_c() {
        int actions = PilotAction.getActiveActions(this.field_146297_k.field_71474_y, this.m_allowedActions);
        if (actions != this.m_lastActions) {
            this.applyActions(actions);
        }
        this.m_lastActions = actions;
    }

    protected void func_73864_a(int x, int y, int button) {
        if (button == 1) {
            this.close();
        }
    }

    public void func_146281_b() {
        this.applyActions(0);
    }

    private void applyActions(int actions) {
        this.m_ship.setPilotActions(actions, this.m_forwardSide, true);
    }

    protected static enum ForwardSideMethod {
        ByPlayerLook{

            @Override
            public BlockSide compute(EntityShip ship, EntityPlayer player) {
                Vec3 blockCenter = Vec3.func_72443_a((double)0.5, (double)0.5, (double)0.5);
                ship.blocksToShip(blockCenter);
                ship.shipToWorld(blockCenter);
                Vec3 direction = Vec3.func_72443_a((double)(player.field_70165_t - blockCenter.field_72450_a), (double)0.0, (double)(player.field_70161_v - blockCenter.field_72449_c));
                ship.worldToShipDirection(direction);
                double maxDot = Double.NEGATIVE_INFINITY;
                BlockSide sideShipForward = null;
                for (BlockSide side : BlockSide.xzSides()) {
                    double dot = (double)(-side.getDx()) * direction.field_72450_a + (double)(-side.getDz()) * direction.field_72449_c;
                    if (!(dot > maxDot)) continue;
                    maxDot = dot;
                    sideShipForward = side;
                }
                return sideShipForward;
            }
        }
        ,
        ByHelm{

            @Override
            public BlockSide compute(EntityShip ship, EntityPlayer player) {
                return ship.getPropulsion().getFrontSide();
            }
        };


        public abstract BlockSide compute(EntityShip var1, EntityPlayer var2);
    }
}

