/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cuchaz.modsShared.blocks.BlockArray;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.GuiShip;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.packets.PacketLaunchShip;
import cuchaz.ships.render.RenderShip2D;
import net.minecraft.client.gui.GuiButton;

public class GuiShipLaunch
extends GuiShip {
    private ShipLauncher m_shipLauncher;
    private GuiButton m_buttonLaunchShip;
    private BlockSide m_shipSide;
    private GuiButton m_buttonRotateLeft;
    private GuiButton m_buttonRotateRight;

    public GuiShipLaunch(ShipLauncher shipLauncher) {
        this.m_shipLauncher = shipLauncher;
        this.m_buttonLaunchShip = null;
        this.m_shipSide = this.m_shipLauncher.getShipSide();
        this.m_buttonRotateLeft = null;
        this.m_buttonRotateRight = null;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.m_buttonLaunchShip = this.newGuiButton(0, 8, this.m_height - 6 - 20, 80, 20, GuiString.ShipLaunch.getLocalizedText());
        this.m_buttonLaunchShip.field_146124_l = this.m_shipLauncher.isLaunchable();
        this.field_146292_n.add(this.m_buttonLaunchShip);
        this.m_buttonRotateLeft = this.newGuiButton(1, this.m_width - 8 - 20 - 20 - 10, this.m_height - 6 - 20, 20, 20, "<");
        this.m_buttonRotateLeft.field_146124_l = this.m_shipLauncher.isLaunchable();
        this.field_146292_n.add(this.m_buttonRotateLeft);
        this.m_buttonRotateRight = this.newGuiButton(2, this.m_width - 8 - 20, this.m_height - 6 - 20, 20, 20, ">");
        this.m_buttonRotateRight.field_146124_l = this.m_shipLauncher.isLaunchable();
        this.field_146292_n.add(this.m_buttonRotateRight);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == this.m_buttonLaunchShip.field_146127_k) {
            Ships.net.getDispatch().sendToServer((IMessage)new PacketLaunchShip(this.m_shipLauncher.getShipBlock()));
            this.close();
        } else if (button.field_146127_k == this.m_buttonRotateLeft.field_146127_k) {
            this.m_shipSide = this.m_shipSide.rotateXZCcw(1);
        } else if (button.field_146127_k == this.m_buttonRotateRight.field_146127_k) {
            this.m_shipSide = this.m_shipSide.rotateXZCw(1);
        }
    }

    @Override
    protected void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        this.drawHeaderText(GuiString.ShipConstruction.getLocalizedText(), 0);
        String valueText = this.m_shipLauncher.getLaunchFlag(ShipLauncher.LaunchFlag.RightNumberOfBlocks) ? String.format("%d / %d", this.m_shipLauncher.getNumBlocks(), this.m_shipLauncher.getShipType().getMaxNumBlocks()) : String.format("%d%s / %d", this.m_shipLauncher.getNumBlocksChecked(), this.m_shipLauncher.getNumBlocksChecked() == this.m_shipLauncher.getNumBlocksToCheck() ? "+" : "", this.m_shipLauncher.getShipType().getMaxNumBlocks());
        this.drawYesNoText(GuiString.ShipNumBlocks.getLocalizedText(), valueText, this.m_shipLauncher.getLaunchFlag(ShipLauncher.LaunchFlag.RightNumberOfBlocks), 1);
        this.drawYesNoText(GuiString.ShipWillItFloat.getLocalizedText(), this.m_shipLauncher.getLaunchFlag(ShipLauncher.LaunchFlag.WillItFloat), 2);
        if (this.m_shipLauncher.getSinkWaterHeight() == null) {
            this.drawText(GuiString.ShipIsUnsinkable.getLocalizedText(), 3);
        } else if (this.m_shipLauncher.getEquilibriumWaterHeight() != null && (double)this.m_shipLauncher.getSinkWaterHeight().intValue() - this.m_shipLauncher.getEquilibriumWaterHeight() < 0.5) {
            this.drawText(GuiString.ShipFloatsCloseToSinkLine.getLocalizedText(), 3, this.NoColor);
        }
        if (this.m_shipSide != null) {
            BlockArray envelope = this.m_shipLauncher.getShipEnvelope(this.m_shipSide);
            int x = 8;
            int y = this.getLineY(3);
            int width = this.m_width - 16;
            int height = 96;
            RenderShip2D.drawWater(envelope, this.m_shipLauncher.getEquilibriumWaterHeight(), this.m_shipLauncher.getSinkWaterHeight(), x, y, this.field_73735_i, width, height);
            RenderShip2D.drawShip(envelope, this.m_shipSide, this.m_shipLauncher.getShipWorld(), x, y, this.field_73735_i, width, height);
        }
    }
}

