/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.gui;

import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLauncher;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.GuiShipLaunch;
import cuchaz.ships.gui.GuiShipPilotPaddle;
import cuchaz.ships.gui.GuiShipPilotSurface;
import cuchaz.ships.gui.GuiShipPropulsion;
import cuchaz.ships.gui.GuiShipUnlaunch;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;

public enum Gui {
    BuildShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGui(EntityPlayer player, World world, int x, int y, int z) {
            return new GuiShipLaunch(new ShipLauncher(world, new Coords(x, y, z)));
        }
    }
    ,
    UnbuildShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGuiOnShip(EntityPlayer player, EntityShip ship) {
            return new GuiShipUnlaunch(ship);
        }
    }
    ,
    PaddleShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGuiOnShip(EntityPlayer player, EntityShip ship) {
            return new GuiShipPilotPaddle(ship, player);
        }
    }
    ,
    PilotSurfaceShip{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGuiOnShip(EntityPlayer player, EntityShip ship) {
            return new GuiShipPilotSurface(ship, player);
        }
    }
    ,
    ShipPropulsion{

        @Override
        @SideOnly(value=Side.CLIENT)
        public GuiScreen getGui(EntityPlayer player, World world, int x, int y, int z) {
            return new GuiShipPropulsion(world, x, y, z);
        }
    };

    public static final IGuiHandler Handler;

    public void open(EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)Ships.instance, this.ordinal(), world, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer player, World world, int x, int y, int z) {
        EntityShip ship = ShipLocator.getFromPlayerLook(player);
        if (ship == null) {
            Ships.logger.warning("Unable to locate ship!", new Object[0]);
            return null;
        }
        return this.getGuiOnShip(player, ship);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiOnShip(EntityPlayer player, EntityShip ship) {
        return null;
    }

    static {
        Handler = new IGuiHandler(){

            public Container getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
                return null;
            }

            public GuiScreen getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
                return Gui.values()[id].getGui(player, world, x, y, z);
            }
        };
    }
}

