/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.core;

import cuchaz.ships.core.ObfuscationAwareAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class TileEntityInventoryAdapter
extends ObfuscationAwareAdapter {
    private final String TileEntityClassName;
    private final String ContainerClassName;
    private final String PlayerClassName;
    private final String InventoryPlayerClassName;
    private final String WorldClassName;
    private String m_name;

    public TileEntityInventoryAdapter(int api, ClassVisitor cv, boolean isObfuscatedEnvironment) {
        super(api, cv, isObfuscatedEnvironment);
        this.TileEntityClassName = "net/minecraft/tileentity/TileEntity";
        this.ContainerClassName = "net/minecraft/inventory/Container";
        this.PlayerClassName = "net/minecraft/entity/player/EntityPlayer";
        this.InventoryPlayerClassName = "net/minecraft/entity/player/InventoryPlayer";
        this.WorldClassName = "net/minecraft/world/World";
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.m_name = name;
    }

    public MethodVisitor visitMethod(int access, String methodName, String methodDesc, String signature, String[] exceptions) {
        final boolean isTileEntityInventoryIsUseableByPlayer = methodName.equals(this.getRuntimeMethodName(this.m_name, "isUseableByPlayer", "func_70300_a")) || methodName.equals(this.getRuntimeMethodName(this.m_name, "isUseableByPlayer", "func_70365_a"));
        final boolean isContainerCanInteractWith = methodName.equals(this.getRuntimeMethodName(this.m_name, "canInteractWith", "func_75145_c"));
        if ((isTileEntityInventoryIsUseableByPlayer || isContainerCanInteractWith) && methodDesc.equals(String.format("(L%s;)Z", this.PlayerClassName))) {
            return new MethodVisitor(this.api, this.cv.visitMethod(access, methodName, methodDesc, signature, exceptions)){

                public void visitMethodInsn(int opcode, String calledOwner, String calledName, String calledDesc) {
                    if (opcode == 182 && calledDesc.equals("(DDD)D") && calledOwner.equals(TileEntityInventoryAdapter.this.PlayerClassName) && calledName.equals(TileEntityInventoryAdapter.this.getRuntimeMethodName(calledOwner, "getDistanceSq", "func_70092_e"))) {
                        String thisType = null;
                        if (isTileEntityInventoryIsUseableByPlayer) {
                            thisType = TileEntityInventoryAdapter.this.TileEntityClassName;
                        } else if (isContainerCanInteractWith) {
                            thisType = TileEntityInventoryAdapter.this.ContainerClassName;
                        } else {
                            throw new Error("Unable to determine this type!");
                        }
                        this.mv.visitVarInsn(25, 0);
                        this.mv.visitMethodInsn(184, "cuchaz/ships/core/ShipIntermediary", "getEntityDistanceSq", String.format("(L%s;DDDL%s;)D", TileEntityInventoryAdapter.this.PlayerClassName, thisType));
                    } else {
                        super.visitMethodInsn(opcode, calledOwner, calledName, calledDesc);
                    }
                }
            };
        }
        if (methodName.equals("<init>") && methodDesc.startsWith(String.format("(L%s;L%s;III", this.InventoryPlayerClassName, this.WorldClassName))) {
            return new MethodVisitor(this.api, this.cv.visitMethod(access, methodName, methodDesc, signature, exceptions)){

                public void visitFieldInsn(int opcode, String owner, String fieldName, String desc) {
                    if (opcode == 181 && desc.equals(String.format("L%s;", TileEntityInventoryAdapter.this.WorldClassName)) && owner.equals(TileEntityInventoryAdapter.this.m_name)) {
                        this.mv.visitVarInsn(25, 1);
                        this.mv.visitMethodInsn(184, "cuchaz/ships/core/ShipIntermediary", "translateWorld", String.format("(L%s;L%s;)L%s;", TileEntityInventoryAdapter.this.WorldClassName, TileEntityInventoryAdapter.this.InventoryPlayerClassName, TileEntityInventoryAdapter.this.WorldClassName));
                        this.mv.visitFieldInsn(181, owner, fieldName, desc);
                    } else {
                        super.visitFieldInsn(opcode, owner, fieldName, desc);
                    }
                }
            };
        }
        return super.visitMethod(access, methodName, methodDesc, signature, exceptions);
    }
}

