/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.core;

import cuchaz.modsShared.Environment;
import cuchaz.ships.Collider;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PlayerRespawner;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ShipIntermediary {
    public static final String Path = "cuchaz/ships/core/ShipIntermediary";

    public static World translateWorld(World world, InventoryPlayer inventory) {
        EntityShip ship = ShipLocator.getFromPlayerLook(inventory.field_70458_d);
        if (ship != null) {
            return ship.getShipWorld();
        }
        return world;
    }

    public static double getEntityDistanceSq(EntityPlayer player, double tileEntityX, double tileEntityY, double tileEntityZ, TileEntity tileEntity) {
        return ShipIntermediary.translateDistance(tileEntity.func_145831_w(), player, tileEntityX, tileEntityY, tileEntityZ);
    }

    public static double getEntityDistanceSq(EntityPlayer player, double containerX, double containerY, double containerZ, Container container) {
        World world = null;
        int x = 0;
        int y = 0;
        int z = 0;
        try {
            Field fieldWorld = ShipIntermediary.getField(container, Environment.getRuntimeName("worldObj", "field_75161_g"), Environment.getRuntimeName("worldPointer", "field_75172_h"), Environment.getRuntimeName("theWorld", "field_82860_h"));
            world = (World)fieldWorld.get(container);
            Field fieldX = ShipIntermediary.getField(container, Environment.getRuntimeName("posX", "field_75164_h"), Environment.getRuntimeName("posX", "field_75173_i"), Environment.getRuntimeName("field_82861_i", "field_82861_i"));
            x = fieldX.getInt(container);
            Field fieldY = ShipIntermediary.getField(container, Environment.getRuntimeName("posY", "field_75165_i"), Environment.getRuntimeName("posY", "field_75170_j"), Environment.getRuntimeName("field_82858_j", "field_82858_j"));
            y = fieldY.getInt(container);
            Field fieldZ = ShipIntermediary.getField(container, Environment.getRuntimeName("posZ", "field_75163_j"), Environment.getRuntimeName("posZ", "field_75171_k"), Environment.getRuntimeName("field_82859_k", "field_82859_k"));
            z = fieldZ.getInt(container);
        }
        catch (Exception ex) {
            Ships.logger.warning(ex, "Unable to reflect on container class: %s", container.getClass().getName());
        }
        return ShipIntermediary.translateDistance(world, player, x, y, z);
    }

    public static void onEntityMove(Entity entity, double dx, double dy, double dz) {
        Collider.onEntityMove(entity, dx, dy, dz);
    }

    public static List getShipsWithinAABB(List out, World world, AxisAlignedBB box, IEntitySelector selector) {
        for (EntityShip ship : ShipLocator.findShipsInBox(world, box)) {
            if (selector != null && !selector.func_82704_a((Entity)ship)) continue;
            out.add(ship);
        }
        return out;
    }

    public static boolean checkBlockCollision(World world, AxisAlignedBB box) {
        for (EntityShip ship : ShipLocator.findShipsInBox(world, box)) {
            if (!ship.getCollider().isColliding(box)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntityOnShipLadder(EntityLivingBase entity) {
        return Collider.isEntityOnShipLadder(entity);
    }

    public static double getDistanceSqToEntity(Entity src, Entity dest) {
        if (src instanceof EntityShip) {
            return ((EntityShip)src).getCollider().getDistanceSqToEntity(dest);
        }
        if (dest instanceof EntityShip) {
            return ((EntityShip)dest).getCollider().getDistanceSqToEntity(src);
        }
        return -1.0;
    }

    public static void onPlayerWakeUp(EntityPlayer player, boolean wasSleepSuccessful) {
        PlayerRespawner.onPlayerWakeUp(player, wasSleepSuccessful);
    }

    public static void onPlayerRespawn(EntityPlayerMP oldPlayer, EntityPlayerMP newPlayer, int dimension) {
        PlayerRespawner.onPlayerRespawn(oldPlayer, newPlayer, dimension);
    }

    public static boolean isPlayerInBed(EntityPlayer player) {
        return PlayerRespawner.isPlayerInBerth(player);
    }

    private static double translateDistance(World world, EntityPlayer player, double x, double y, double z) {
        if (world != null && world instanceof ShipWorld) {
            EntityShip ship = ((ShipWorld)world).getShip();
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            ship.blocksToShip(v);
            ship.shipToWorld(v);
            return player.func_70092_e(v.field_72450_a, v.field_72448_b, v.field_72449_c);
        }
        return player.func_70092_e(x, y, z);
    }

    private static Field getField(Object obj, String ... names) {
        for (Field field : obj.getClass().getDeclaredFields()) {
            for (String name : names) {
                if (!field.getName().equals(name)) continue;
                field.setAccessible(true);
                return field;
            }
        }
        return null;
    }
}

