/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.core;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.lang.reflect.Field;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;

public class ObfuscationAwareAdapter
extends ClassVisitor {
    private boolean m_isObfuscatedEnvironment;

    public ObfuscationAwareAdapter(int api, ClassVisitor cv, boolean isObfuscatedEnvironment) {
        super(api, cv);
        this.m_isObfuscatedEnvironment = isObfuscatedEnvironment;
    }

    public ClassVisitor getPreviousClassVisitor() {
        return this.cv;
    }

    public void setPreviousClassVisitor(ClassVisitor val) {
        this.cv = val;
    }

    protected String getRuntimeMethodName(String runtimeClassName, String clearMethodName, String idMethodName) {
        if (this.m_isObfuscatedEnvironment) {
            return this.methodMapReverseLookup(this.getMethodMap(runtimeClassName), idMethodName);
        }
        return clearMethodName;
    }

    private Map<String, String> getMethodMap(String obfuscatedClassName) {
        try {
            Field field = FMLDeobfuscatingRemapper.class.getDeclaredField("methodNameMaps");
            field.setAccessible(true);
            return (Map)((Map)field.get(FMLDeobfuscatingRemapper.INSTANCE)).get(obfuscatedClassName);
        }
        catch (Exception ex) {
            throw new Error("Unable to access FML's deobfuscation mappings!", ex);
        }
    }

    private String methodMapReverseLookup(Map<String, String> methodMap, String idMethodName) {
        if (methodMap == null) {
            return idMethodName;
        }
        for (Map.Entry<String, String> entry : methodMap.entrySet()) {
            if (!entry.getValue().equals(idMethodName)) continue;
            String obfuscatedName = entry.getKey();
            return obfuscatedName.substring(0, obfuscatedName.indexOf("("));
        }
        return "";
    }
}

