/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.core;

import cuchaz.ships.core.CoreModPlugin;
import cuchaz.ships.core.EntityDistanceAdapter;
import cuchaz.ships.core.EntityLadderAdapter;
import cuchaz.ships.core.EntityMoveAdapter;
import cuchaz.ships.core.EntityPlayerAdapter;
import cuchaz.ships.core.EntityRendererAdapter;
import cuchaz.ships.core.ObfuscationAwareAdapter;
import cuchaz.ships.core.ServerConfigurationManagerAdapter;
import cuchaz.ships.core.TileEntityInventoryAdapter;
import cuchaz.ships.core.WorldAdapter;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CoreModTransformer
implements IClassTransformer {
    private static ObfuscationAwareAdapter m_adapterHead = null;
    private static ObfuscationAwareAdapter m_adapterTail = null;

    public byte[] transform(String name, String transformedName, byte[] classData) {
        if (classData == null) {
            return null;
        }
        try {
            List<String> privilegedPackages = Arrays.asList("cuchaz.ships.", "cuchaz.modsShared", "net.minecraftforge.", "cpw.");
            for (String privilegedPackage : privilegedPackages) {
                if (!name.startsWith(privilegedPackage)) continue;
                return classData;
            }
            if (CoreModPlugin.isObfuscatedEnvironment == null) {
                return classData;
            }
            if (m_adapterHead == null || m_adapterTail == null) {
                ObfuscationAwareAdapter adapter = new TileEntityInventoryAdapter(262144, null, CoreModPlugin.isObfuscatedEnvironment);
                m_adapterHead = adapter;
                adapter = new EntityMoveAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new WorldAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityRendererAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityLadderAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityDistanceAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new ServerConfigurationManagerAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityPlayerAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                m_adapterTail = adapter;
            }
            ClassWriter classWriter = new ClassWriter(1);
            m_adapterHead.setPreviousClassVisitor((ClassVisitor)classWriter);
            new ClassReader(classData).accept((ClassVisitor)m_adapterTail, 0);
            return classWriter.toByteArray();
        }
        catch (Throwable t) {
            System.out.println("Exception occurred while transforming class " + name + ":" + transformedName + ". This class has been skipped and left un-transformed.");
            t.printStackTrace(System.out);
            return classData;
        }
    }
}

