/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.config;

import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockEntry;
import cuchaz.ships.config.DefaultBlockProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlockProperties {
    private static Map<Block, BlockEntry> m_hardcodedEntries = new HashMap<Block, BlockEntry>();
    private static Map<Block, BlockEntry> m_overriddenEntries = new HashMap<Block, BlockEntry>();

    public static void readConfigFile() throws FileNotFoundException {
        File inFile = new File("config/shipBlockProperties.cfg");
        if (!inFile.exists()) {
            Ships.logger.info("Skipping ships block config. No config file found at: " + inFile.getAbsolutePath(), new Object[0]);
            return;
        }
        m_overriddenEntries.clear();
        BlockProperties.readEntries(m_overriddenEntries, new FileReader(inFile));
        Ships.logger.info("Read %d block properties from: %s", m_overriddenEntries.size(), inFile.getAbsolutePath());
    }

    public static void setOverrides(String in) {
        m_overriddenEntries.clear();
        BlockProperties.readEntries(m_overriddenEntries, new StringReader(in));
    }

    public static String getOverrides() {
        return BlockProperties.writeEntries(m_overriddenEntries);
    }

    public static boolean hasOverrides() {
        return !m_overriddenEntries.isEmpty();
    }

    public static boolean isOverridden(Block block) {
        return m_overriddenEntries.containsKey(block);
    }

    public static Iterable<Map.Entry<Block, BlockEntry>> overrides() {
        return m_overriddenEntries.entrySet();
    }

    public static void addScaledEntry(Block block, BlockEntry entry) {
        double scaleFactor = entry.mass;
        double defaultMass = DefaultBlockProperties.getEntry((Block)block).mass;
        entry.mass = defaultMass * scaleFactor;
        m_hardcodedEntries.put(block, entry);
    }

    public static void addEntry(Block block, BlockEntry entry) {
        m_hardcodedEntries.put(block, entry);
    }

    public static double getMass(Block block) {
        return BlockProperties.getEntry((Block)block).mass;
    }

    public static double getDisplacement(Block block) {
        return BlockProperties.getEntry((Block)block).displacement;
    }

    public static boolean isWatertight(Block block) {
        return BlockProperties.getEntry((Block)block).isWatertight;
    }

    public static boolean isSeparator(Block block) {
        return BlockProperties.getEntry((Block)block).isSeparator;
    }

    public static boolean isWater(Block block) {
        return BlockProperties.getEntry((Block)block).isWater;
    }

    public static BlockEntry getEntry(Block block) {
        BlockEntry entry = null;
        entry = m_overriddenEntries.get(block);
        if (entry != null) {
            return entry;
        }
        entry = m_hardcodedEntries.get(block);
        if (entry != null) {
            return entry;
        }
        return DefaultBlockProperties.getEntry(block);
    }

    private static void readEntries(Map<Block, BlockEntry> entries, Reader inRaw) {
        HashMap<String, Block> blocks = new HashMap<String, Block>();
        for (Block block : Block.field_149771_c) {
            if (block == null) continue;
            blocks.put(Block.field_149771_c.func_148750_c((Object)block), block);
        }
        try {
            BufferedReader in = new BufferedReader(inRaw);
            String line = null;
            while ((line = in.readLine()) != null) {
                System.out.println("LINE: " + line);
                line = line.trim();
                if (line.length() <= 0) continue;
                try {
                    Block block = null;
                    String[] parts = line.split("=");
                    if (parts.length != 2) {
                        throw new IllegalArgumentException();
                    }
                    block = (Block)blocks.get(parts[0]);
                    if (block == null) {
                        throw new IllegalArgumentException("Unknown block id name: " + parts[0]);
                    }
                    BlockEntry entry = BlockProperties.readEntry(parts[1]);
                    if (block == null || entry == null) continue;
                    entries.put(block, entry);
                }
                catch (RuntimeException ex) {
                    Ships.logger.warning(ex, "Malformed block entry: %s", line);
                }
            }
            in.close();
        }
        catch (IOException ex) {
            Ships.logger.warning(ex, "Unable to read block properties!", new Object[0]);
        }
    }

    private static BlockEntry readEntry(String entryString) {
        String[] parts = entryString.split(";");
        if (parts.length != 5) {
            throw new IllegalArgumentException();
        }
        return new BlockEntry(Double.parseDouble(parts[0]), Double.parseDouble(parts[1]), Boolean.parseBoolean(parts[2]), Boolean.parseBoolean(parts[3]), Boolean.parseBoolean(parts[4]));
    }

    private static String writeEntries(Map<Block, BlockEntry> entries) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Block, BlockEntry> entry : entries.entrySet()) {
            buf.append(Block.field_149771_c.func_148750_c((Object)entry.getKey()));
            buf.append("=");
            buf.append(entry.getValue().mass);
            buf.append(";");
            buf.append(entry.getValue().displacement);
            buf.append(";");
            buf.append(entry.getValue().isWatertight);
            buf.append(";");
            buf.append(entry.getValue().isSeparator);
            buf.append(";");
            buf.append(entry.getValue().isWater);
            buf.append("\n");
        }
        return buf.toString();
    }

    static {
        double DoorSizeFactor = 0.3;
        BlockProperties.addScaledEntry(Blocks.field_150466_ao, new BlockEntry(0.3, 0.3, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150454_av, new BlockEntry(0.3, 0.3, false, false, false));
        double TrapDoorSizeFactor = 0.2;
        BlockProperties.addScaledEntry(Blocks.field_150415_aT, new BlockEntry(0.2, 0.2, false, false, false));
        double SlabSizeFactor = 0.5;
        BlockProperties.addScaledEntry((Block)Blocks.field_150333_U, new BlockEntry(0.5, 0.5, true, false, false));
        BlockProperties.addScaledEntry((Block)Blocks.field_150376_bx, new BlockEntry(0.5, 0.5, true, false, false));
        double StairsSizeFactor = 0.75;
        BlockProperties.addScaledEntry(Blocks.field_150476_ad, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150485_bF, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150487_bG, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150481_bH, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150370_cb, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150389_bf, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150390_bg, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150387_bl, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150372_bz, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150400_ck, new BlockEntry(0.75, 0.75, true, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150401_cl, new BlockEntry(0.75, 0.75, true, false, false));
        double LadderSizeFactor = 0.1;
        BlockProperties.addScaledEntry(Blocks.field_150468_ap, new BlockEntry(0.1, 0.1, false, false, false));
        double FenceSizeFactor = 0.5;
        BlockProperties.addScaledEntry(Blocks.field_150422_aJ, new BlockEntry(0.5, 0.5, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150396_be, new BlockEntry(0.5, 0.5, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150386_bk, new BlockEntry(0.5, 0.5, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150411_aY, new BlockEntry(0.5, 0.5, false, false, false));
        double PressurePlateFactor = 0.2;
        BlockProperties.addScaledEntry(Blocks.field_150456_au, new BlockEntry(0.2, 0.2, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150452_aw, new BlockEntry(0.2, 0.2, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150445_bS, new BlockEntry(0.2, 0.2, false, false, false));
        BlockProperties.addScaledEntry(Blocks.field_150443_bT, new BlockEntry(0.2, 0.2, false, false, false));
        double ThinPaneFactor = 0.2;
        BlockProperties.addScaledEntry(Blocks.field_150410_aZ, new BlockEntry(0.2, 0.2, true, false, false));
        double SignFactor = 0.2;
        BlockProperties.addScaledEntry(Blocks.field_150444_as, new BlockEntry(0.2, 0.2, false, false, false));
        BlockProperties.addEntry(Ships.m_blockAirWall, new BlockEntry(0.0, 0.0, false, true, true));
        BlockProperties.addEntry(Ships.m_blockAirRoof, new BlockEntry(0.0, 0.0, false, true, false));
    }
}

