/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.ships.ShipType;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.gui.Gui;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockShip
extends Block {
    public BlockShip() {
        super(Material.field_151573_f);
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(field_149777_j);
        this.func_149663_c("cuchaz.ships.blockShip");
        this.func_149647_a(CreativeTabs.field_78029_e);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (BlockSide.getById(side)) {
            case North: 
            case South: 
            case East: 
            case West: {
                return ShipType.getByMeta(meta).getIcon();
            }
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("ships:shipTop");
        ShipType.registerIcons(iconRegister);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        if (world instanceof ShipWorld) {
            boolean isPaddleEquipped = player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == Ships.m_itemPaddle;
            ShipWorld shipWorld = (ShipWorld)world;
            if (isPaddleEquipped && shipWorld.getShipType().isPaddleable() && shipWorld.getShip().getCollider().isEntityAboard((Entity)player)) {
                Gui.PaddleShip.open(player, world, x, y, z);
            } else {
                Gui.UnbuildShip.open(player, world, x, y, z);
            }
        } else {
            Gui.BuildShip.open(player, world, x, y, z);
        }
        return true;
    }

    public ShipType getShipType(World world, int x, int y, int z) {
        return ShipType.getByMeta(world.func_72805_g(x, y, z));
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tabs, List subItems) {
        for (ShipType type : ShipType.values()) {
            subItems.add(type.newItemStack());
        }
    }
}

