/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.asm;

import org.objectweb.asm.ClassReader;

public class InheritanceUtils {
    private static String[] leafPackages = new String[]{"java/", "javax/"};

    public static boolean extendsClass(String className, String targetClassName) {
        if (className.equalsIgnoreCase(targetClassName)) {
            return true;
        }
        if (InheritanceUtils.isLeafPackage(className)) {
            return false;
        }
        if (className.startsWith("[")) {
            return false;
        }
        try {
            ClassReader classReader = new ClassReader(className.replace('.', '/'));
            String superClassName = classReader.getSuperName();
            if (superClassName != null) {
                return InheritanceUtils.extendsClass(superClassName, targetClassName);
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to read class: " + className + ". Assuming it's not a " + targetClassName);
            ex.printStackTrace(System.out);
        }
        return false;
    }

    public static boolean implementsInterface(String interfaceName, String targetInterfaceName) {
        if (interfaceName.equalsIgnoreCase(targetInterfaceName)) {
            return true;
        }
        if (InheritanceUtils.isLeafPackage(interfaceName)) {
            return false;
        }
        String className = interfaceName.replace('.', '/');
        try {
            ClassReader classReader = new ClassReader(className);
            for (String i : classReader.getInterfaces()) {
                if (!InheritanceUtils.implementsInterface(i, targetInterfaceName)) continue;
                return true;
            }
        }
        catch (Exception ex) {
            System.out.println("Unable to read class: " + className + ". Assuming it's not a " + targetInterfaceName);
            ex.printStackTrace(System.out);
        }
        return false;
    }

    private static boolean isLeafPackage(String name) {
        for (String prefix : leafPackages) {
            if (!name.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

