/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships.asm;

import cuchaz.ships.asm.CoreModPlugin;
import cuchaz.ships.asm.EntityDistanceAdapter;
import cuchaz.ships.asm.EntityLadderAdapter;
import cuchaz.ships.asm.EntityMoveAdapter;
import cuchaz.ships.asm.EntityPlayerAdapter;
import cuchaz.ships.asm.EntityRendererAdapter;
import cuchaz.ships.asm.ObfuscationAwareAdapter;
import cuchaz.ships.asm.ServerConfigurationManagerAdapter;
import cuchaz.ships.asm.TileEntityInventoryAdapter;
import cuchaz.ships.asm.WorldAdapter;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class CoreModTransformer
implements IClassTransformer {
    private static ObfuscationAwareAdapter m_adapterHead = null;
    private static ObfuscationAwareAdapter m_adapterTail = null;

    public byte[] transform(String name, String transformedName, byte[] classData) {
        if (classData == null) {
            throw new Error("Transformer received no class data for " + name + ":" + transformedName + "! This class probably doesn't exist on the server!");
        }
        try {
            List<String> privilegedPackages = Arrays.asList("cuchaz.ships.", "cuchaz.modsShared", "net.minecraftforge.", "cpw.");
            for (String privilegedPackage : privilegedPackages) {
                if (!name.startsWith(privilegedPackage)) continue;
                return classData;
            }
            if (CoreModPlugin.isObfuscatedEnvironment == null) {
                return classData;
            }
            if (m_adapterHead == null || m_adapterTail == null) {
                ObfuscationAwareAdapter adapter = new TileEntityInventoryAdapter(262144, null, CoreModPlugin.isObfuscatedEnvironment);
                m_adapterHead = adapter;
                adapter = new EntityMoveAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new WorldAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityRendererAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityLadderAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityDistanceAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new ServerConfigurationManagerAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                adapter = new EntityPlayerAdapter(262144, adapter, CoreModPlugin.isObfuscatedEnvironment);
                m_adapterTail = adapter;
            }
            ClassWriter classWriter = new ClassWriter(1);
            m_adapterHead.setPreviousClassVisitor((ClassVisitor)classWriter);
            new ClassReader(classData).accept((ClassVisitor)m_adapterTail, 0);
            return classWriter.toByteArray();
        }
        catch (Throwable t) {
            System.out.println("Exception occurred while transforming class " + name + ":" + transformedName + ". This class has been skipped and left un-transformed.");
            t.printStackTrace(System.out);
            return classData;
        }
    }
}

