/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.ShipWorldPersistence;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityProjector
extends TileEntity {
    private ShipWorld m_shipWorld = null;
    private byte[] m_encodedBlocksToLoad = null;
    private AxisAlignedBB m_boundingBox = null;
    private Coords m_shipTranslation = new Coords(0, 0, 0);

    public ShipWorld getShipWorld() {
        return this.m_shipWorld;
    }

    public void setShipWorld(ShipWorld shipWorld) {
        this.m_shipWorld = shipWorld;
        BoundingBoxInt box = this.m_shipWorld.getBoundingBox();
        this.m_shipTranslation.set(-box.minX - box.getDx() / 2, -box.minY + 2, -box.minZ - box.getDz() / 2);
        this.m_boundingBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.m_shipWorld.getBoundingBox().toAxisAlignedBB(this.m_boundingBox);
        this.m_boundingBox.func_72317_d((double)(this.field_145851_c + this.m_shipTranslation.x), (double)(this.field_145848_d + this.m_shipTranslation.y), (double)(this.field_145849_e + this.m_shipTranslation.z));
        this.m_boundingBox.func_72328_c(this.m_boundingBox.func_111270_a(this.func_145838_q().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)));
    }

    public Coords getShipTranslation() {
        return this.m_shipTranslation;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.m_boundingBox != null) {
            return this.m_boundingBox;
        }
        return this.func_145838_q().func_149668_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.m_encodedBlocksToLoad != null) {
            if (this.m_shipWorld == null) {
                try {
                    this.setShipWorld(ShipWorldPersistence.readAnyVersion(this.field_145850_b, this.m_encodedBlocksToLoad));
                }
                catch (PersistenceException ex) {
                    Ships.logger.error(ex, "Unable to restore ship projector", new Object[0]);
                }
            }
            this.m_encodedBlocksToLoad = null;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.m_encodedBlocksToLoad = nbt.func_74770_j("shipWorld");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.m_shipWorld != null) {
            nbt.func_74773_a("shipWorld", ShipWorldPersistence.writeNewestVersion(this.m_shipWorld));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
        if (this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }
}

