/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.ships.Supporters;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.codec.binary.Base64;

public class Signer {
    private static final String Provider = "SUN";
    private static final String Algorithm = "DSA";
    private static final String SignatureProtocol = "SHA1withDSA";

    public static void main(String[] args) throws Exception {
        File dirAssets = new File("src/assets/ships");
        File fileSupporters = new File(dirAssets, "supporters.txt");
        File fileSignature = new File(dirAssets, "supporters.sig");
        File filePrivateKey = new File("keys/supporters.key");
        File filePublicKey = new File("keys/supporters.pub");
        PrivateKey key = KeyFactory.getInstance(Algorithm, Provider).generatePrivate(new PKCS8EncodedKeySpec(Signer.readFile(filePrivateKey)));
        Signature signature = Signature.getInstance(SignatureProtocol, Provider);
        signature.initSign(key);
        signature.update(Signer.readFile(fileSupporters));
        Signer.writeFile(fileSignature, signature.sign());
        System.out.println("Signed!");
        boolean verified = Signer.verify(Signer.readFile(fileSupporters), Signer.readFile(fileSignature), Signer.readFile(filePublicKey));
        System.out.println("Verified: " + (verified ? "Yes" : "No"));
        System.out.println(Supporters.getSortedNames());
    }

    private static byte[] readFile(File file) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            buf.write(buffer, 0, len);
        }
        in.close();
        assert (file.length() == (long)buf.size());
        return buf.toByteArray();
    }

    private static void writeFile(File file, byte[] data) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.close();
        assert (file.length() == (long)data.length);
    }

    public static boolean verify(byte[] data, byte[] signatureData, String pub) {
        try {
            return Signer.verify(data, signatureData, Base64.decodeBase64((String)pub));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean verify(byte[] data, byte[] signatureData, byte[] pubData) {
        try {
            PublicKey key = KeyFactory.getInstance(Algorithm, Provider).generatePublic(new X509EncodedKeySpec(pubData));
            Signature signature = Signature.getInstance(SignatureProtocol, Provider);
            signature.initVerify(key);
            signature.update(data);
            return signature.verify(signatureData);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

