/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.net.PacketRegistry;
import cuchaz.ships.CommandShips;
import cuchaz.ships.EnhancedLogger;
import cuchaz.ships.EntityShip;
import cuchaz.ships.MaterialAirWall;
import cuchaz.ships.ShipType;
import cuchaz.ships.TileEntityHelm;
import cuchaz.ships.TileEntityProjector;
import cuchaz.ships.blocks.BlockAirRoof;
import cuchaz.ships.blocks.BlockAirWall;
import cuchaz.ships.blocks.BlockBerth;
import cuchaz.ships.blocks.BlockHelm;
import cuchaz.ships.blocks.BlockProjector;
import cuchaz.ships.blocks.BlockShip;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.gui.Gui;
import cuchaz.ships.items.ItemBerth;
import cuchaz.ships.items.ItemMagicBucket;
import cuchaz.ships.items.ItemMagicShipLevitator;
import cuchaz.ships.items.ItemPaddle;
import cuchaz.ships.items.ItemProjector;
import cuchaz.ships.items.ItemShipBlock;
import cuchaz.ships.items.ItemShipClipboard;
import cuchaz.ships.items.ItemShipEraser;
import cuchaz.ships.packets.PacketBlockPropertiesOverrides;
import cuchaz.ships.packets.PacketChangedBlocks;
import cuchaz.ships.packets.PacketEraseShip;
import cuchaz.ships.packets.PacketLaunchShip;
import cuchaz.ships.packets.PacketPasteShip;
import cuchaz.ships.packets.PacketPilotShip;
import cuchaz.ships.packets.PacketPlaceProjector;
import cuchaz.ships.packets.PacketPlayerSleepInBerth;
import cuchaz.ships.packets.PacketRequestShipBlocks;
import cuchaz.ships.packets.PacketShipBlockEvent;
import cuchaz.ships.packets.PacketShipBlocks;
import cuchaz.ships.packets.PacketShipLaunched;
import cuchaz.ships.packets.PacketUnlaunchShip;
import cuchaz.ships.render.RenderShip;
import cuchaz.ships.render.TileEntityHelmRenderer;
import cuchaz.ships.render.TileEntityProjectorRenderer;
import java.io.FileNotFoundException;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import org.apache.logging.log4j.LogManager;

@Mod(modid="cuchaz.ships", name="Ships Mod", version="1.7.10-1.0.3", dependencies="required-after:Forge@[10.13.2.1230,);required-after:cuchaz.ships.core;required-after:cuchaz.cuchazinteractive", acceptedMinecraftVersions="[1.7.10,)")
public class Ships {
    public static final String Id = "cuchaz.ships";
    public static final String Version = "1.7.10-1.0.3";
    public static final String VersionUrl = "http://www.cuchazinteractive.com/ships/versions.json";
    @Mod.Instance(value="cuchaz.ships")
    public static Ships instance = null;
    public static EnhancedLogger logger = new EnhancedLogger(LogManager.getLogger((String)"cuchaz.ships"));
    public static PacketRegistry net = null;
    public static final Material m_materialAirWall = new MaterialAirWall(MapColor.field_151660_b);
    public static final BlockShip m_blockShip = new BlockShip();
    public static final BlockAirWall m_blockAirWall = new BlockAirWall();
    public static final BlockHelm m_blockHelm = new BlockHelm();
    public static final BlockBerth m_blockBerth = new BlockBerth();
    public static final BlockAirWall m_blockAirRoof = new BlockAirRoof();
    public static final BlockProjector m_blockProjector = new BlockProjector();
    public static final ItemPaddle m_itemPaddle = new ItemPaddle();
    public static final ItemMagicBucket m_itemMagicBucket = new ItemMagicBucket();
    public static final ItemMagicShipLevitator m_itemMagicShipLevitator = new ItemMagicShipLevitator();
    public static final ItemShipClipboard m_itemShipClipboard = new ItemShipClipboard();
    public static final ItemShipEraser m_itemShipEraser = new ItemShipEraser();
    public static final ItemBerth m_itemBerth = new ItemBerth();
    public static ItemProjector m_itemProjector = null;
    public static final int EntityShipId = 0;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata meta = event.getModMetadata();
        meta.autogenerated = false;
        meta.description = "Build sailable ships out of blocks.";
        meta.url = "http://www.cuchazinteractive.com/ships";
        meta.credits = "Created by Cuchaz";
        meta.updateUrl = meta.url;
        meta.authorList = Arrays.asList("Cuchaz");
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        try {
            FMLInterModComms.sendRuntimeMessage((Object)Id, (String)"VersionChecker", (String)"addVersionCheck", (String)VersionUrl);
            net = new PacketRegistry(Id);
            net.register(new PacketLaunchShip());
            net.register(new PacketShipLaunched());
            net.register(new PacketUnlaunchShip());
            net.register(new PacketRequestShipBlocks());
            net.register(new PacketShipBlocks());
            net.register(new PacketPilotShip());
            net.register(new PacketShipBlockEvent());
            net.register(new PacketChangedBlocks());
            net.register(new PacketPasteShip());
            net.register(new PacketEraseShip());
            net.register(new PacketPlayerSleepInBerth());
            net.register(new PacketBlockPropertiesOverrides());
            net.register(new PacketPlaceProjector());
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.loadThings();
            this.loadRecipes();
            if (event.getSide().isClient()) {
                this.loadClient();
            }
            NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, Gui.Handler);
        }
        catch (Throwable ex) {
            logger.warning(ex, "Exception occurred while loading mod.", new Object[0]);
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandShips());
        try {
            BlockProperties.readConfigFile();
        }
        catch (FileNotFoundException ex) {
            logger.warning("Unable to read block properties", ex);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadClient() {
        RenderShip shipRenderer = new RenderShip();
        RenderingRegistry.registerEntityRenderingHandler(EntityShip.class, (Render)shipRenderer);
        this.registerTileEntityRenderer(TileEntityHelm.class, new TileEntityHelmRenderer());
        this.registerTileEntityRenderer(TileEntityProjector.class, new TileEntityProjectorRenderer(shipRenderer));
    }

    @SideOnly(value=Side.CLIENT)
    private void registerTileEntityRenderer(Class<? extends TileEntity> c, TileEntitySpecialRenderer renderer) {
        TileEntityRendererDispatcher.field_147556_a.field_147559_m.put(c, renderer);
        renderer.func_147497_a(TileEntityRendererDispatcher.field_147556_a);
    }

    private void loadThings() {
        GameRegistry.registerBlock((Block)m_blockShip, ItemShipBlock.class, (String)"blockShip");
        GameRegistry.registerBlock((Block)m_blockAirWall, (String)"blockAirWall");
        GameRegistry.registerBlock((Block)m_blockHelm, (String)"blockHelm");
        GameRegistry.registerBlock((Block)m_blockBerth, (String)"blockBerth");
        GameRegistry.registerBlock((Block)m_blockAirRoof, (String)"blockAirRoof");
        GameRegistry.registerBlock((Block)m_blockProjector, ItemProjector.class, (String)"blockProjector");
        GameRegistry.registerItem((Item)m_itemPaddle, (String)"paddle");
        GameRegistry.registerItem((Item)m_itemMagicBucket, (String)"magicBucket");
        GameRegistry.registerItem((Item)m_itemMagicShipLevitator, (String)"magicShipLevitator");
        GameRegistry.registerItem((Item)m_itemShipClipboard, (String)"shipClipboard");
        GameRegistry.registerItem((Item)m_itemShipEraser, (String)"shipEraser");
        GameRegistry.registerItem((Item)m_itemBerth, (String)"berth");
        m_itemProjector = (ItemProjector)Item.func_150898_a((Block)m_blockProjector);
        EntityRegistry.registerModEntity(EntityShip.class, (String)"Ship", (int)0, (Object)this, (int)256, (int)10, (boolean)true);
        GameRegistry.registerTileEntity(TileEntityHelm.class, (String)"helm");
        GameRegistry.registerTileEntity(TileEntityProjector.class, (String)"projector");
    }

    private void loadRecipes() {
        ShipType.registerRecipes();
        ItemStack stickStack = new ItemStack(Items.field_151055_y);
        ItemStack goldStack = new ItemStack(Items.field_151043_k);
        ItemStack ironStack = new ItemStack(Items.field_151042_j);
        ItemStack paperStack = new ItemStack(Items.field_151121_aF);
        ItemStack glassStack = new ItemStack(Blocks.field_150359_w);
        ItemStack lapisStack = new ItemStack(Items.field_151100_aR, 1, 4);
        ItemStack boatStack = new ItemStack(Items.field_151124_az);
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)m_itemPaddle), (Object[])new Object[]{" xx", " xx", "x  ", Character.valueOf('x'), stickStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)m_itemMagicBucket), (Object[])new Object[]{"   ", "x x", " x ", Character.valueOf('x'), goldStack});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)m_blockHelm), (Object[])new Object[]{" x ", "x x", "yxy", Character.valueOf('x'), stickStack, Character.valueOf('y'), ironStack});
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)m_itemBerth), (Object[])new Object[]{"   ", "xxx", "yzy", Character.valueOf('x'), new ItemStack(Blocks.field_150325_L, 1, i), Character.valueOf('y'), stickStack, Character.valueOf('z'), goldStack});
        }
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)m_itemShipClipboard), (Object[])new Object[]{"xxx", "xxx", "yzy", Character.valueOf('x'), paperStack, Character.valueOf('y'), stickStack, Character.valueOf('z'), ShipType.Tiny.newItemStack()});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)m_blockProjector), (Object[])new Object[]{" x ", "yzy", " w ", Character.valueOf('x'), glassStack, Character.valueOf('y'), ironStack, Character.valueOf('z'), lapisStack, Character.valueOf('w'), boatStack});
    }

    @SubscribeEvent
    public void onEntityJoin(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        EntityPlayerMP player = null;
        if (event.entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)event.entity;
        }
        if (player == null) {
            return;
        }
        net.getDispatch().sendTo((IMessage)new PacketBlockPropertiesOverrides(BlockProperties.getOverrides()), player);
    }
}

