/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlockStorage;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.DetachedWorld;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipDisplacement;
import cuchaz.ships.ShipGeometry;
import cuchaz.ships.ShipType;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.packets.PacketChangedBlocks;
import cuchaz.ships.packets.PacketShipBlockEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class ShipWorld
extends DetachedWorld {
    private Coords m_lookupCoords = new Coords(0, 0, 0);
    private EntityShip m_ship = null;
    private BlocksStorage m_storage = new BlocksStorage();
    private BlockMap<TileEntity> m_tileEntities = new BlockMap();
    private BlockMap<EntityHanging> m_hangingEntities = new BlockMap();
    private BlockSet m_changedBlocks = new BlockSet();
    private boolean m_needsRenderUpdate;
    private int m_biomeId = 0;

    public ShipWorld(World world) {
        super(world, "Ship");
    }

    public ShipWorld(World world, BlocksStorage storage, BlockMap<TileEntity> tileEntities, BlockMap<EntityHanging> hangingEntities, int biomeId) {
        this(world);
        this.m_storage = storage;
        this.m_tileEntities = tileEntities;
        this.m_hangingEntities = hangingEntities;
        this.m_biomeId = biomeId;
        for (TileEntity tileEntity : this.m_tileEntities.values()) {
            tileEntity.func_145834_a((World)this);
            tileEntity.func_145829_t();
        }
        for (EntityHanging hangingEntity : this.m_hangingEntities.values()) {
            hangingEntity.func_70029_a((World)this);
        }
    }

    public ShipWorld(World world, Coords originCoords, BlockSet blocks) {
        this(world);
        this.m_storage.readFromWorld(world, originCoords, blocks);
        for (Coords coords : blocks) {
            TileEntity tileEntity = world.func_147438_o(coords.x, coords.y, coords.z);
            if (tileEntity == null) continue;
            Coords relativeCoords = new Coords(coords.x - originCoords.x, coords.y - originCoords.y, coords.z - originCoords.z);
            try {
                NBTTagCompound nbt = new NBTTagCompound();
                tileEntity.func_145841_b(nbt);
                TileEntity tileEntityCopy = TileEntity.func_145827_c((NBTTagCompound)nbt);
                tileEntityCopy.func_145834_a((World)this);
                tileEntityCopy.field_145851_c = relativeCoords.x;
                tileEntityCopy.field_145848_d = relativeCoords.y;
                tileEntityCopy.field_145849_e = relativeCoords.z;
                tileEntityCopy.func_145829_t();
                this.m_tileEntities.put(relativeCoords, tileEntityCopy);
            }
            catch (Exception ex) {
                Ships.logger.warning(ex, "Tile entity %s at (%d,%d,%d) didn't like being moved to the ship. The block was moved, the but tile entity was not moved.", tileEntity.getClass().getName(), coords.x, coords.y, coords.z);
            }
        }
        for (Map.Entry entry : this.getNearbyHangingEntities(world, blocks).entrySet()) {
            Coords worldCoords = (Coords)entry.getKey();
            EntityHanging hangingEntity = (EntityHanging)entry.getValue();
            Coords relativeCoords = new Coords(worldCoords.x - originCoords.x, worldCoords.y - originCoords.y, worldCoords.z - originCoords.z);
            try {
                NBTTagCompound nbt = new NBTTagCompound();
                hangingEntity.func_70039_c(nbt);
                EntityHanging hangingEntityCopy = (EntityHanging)EntityList.func_75615_a((NBTTagCompound)nbt, (World)this);
                hangingEntityCopy.field_146063_b = relativeCoords.x;
                hangingEntityCopy.field_146064_c = relativeCoords.y;
                hangingEntityCopy.field_146062_d = relativeCoords.z;
                hangingEntityCopy.field_70165_t -= (double)originCoords.x;
                hangingEntityCopy.field_70163_u -= (double)originCoords.y;
                hangingEntityCopy.field_70161_v -= (double)originCoords.z;
                this.m_hangingEntities.put(relativeCoords, hangingEntityCopy);
                hangingEntityCopy.func_82328_a(hangingEntityCopy.field_82332_a);
            }
            catch (Exception ex) {
                Ships.logger.warning(ex, "Hanging entity %s at (%d,%d,%d) didn't like being moved to the ship. The block was moved, the but hanging entity was not moved.", hangingEntity.getClass().getName(), worldCoords.x, worldCoords.y, worldCoords.z);
            }
        }
        this.m_biomeId = world.func_72807_a((int)originCoords.x, (int)originCoords.z).field_76756_M;
    }

    public void restoreToWorld(World world, Map<Coords, Coords> correspondence, int waterHeightInBlockSpace) {
        this.m_storage.writeToWorld(world, correspondence);
        for (Coords coords : this.getDisplacement().getTrappedAirFromWaterHeight(waterHeightInBlockSpace)) {
            Coords coordsWorld = correspondence.get(coords);
            Block block = world.func_147439_a(coordsWorld.x, coordsWorld.y, coordsWorld.z);
            if (!BlockProperties.isWater(block) && block != Ships.m_blockAirWall) continue;
            BlockUtils.removeBlockWithoutNotifyingIt(world, coordsWorld.x, coordsWorld.y, coordsWorld.z, BlockUtils.UpdateRules.UpdateClients);
        }
        for (Map.Entry entry : this.m_tileEntities.entrySet()) {
            Coords coordsShip = (Coords)entry.getKey();
            Coords coordsWorld = correspondence.get(coordsShip);
            TileEntity tileEntity = (TileEntity)entry.getValue();
            try {
                NBTTagCompound nbt = new NBTTagCompound();
                tileEntity.func_145841_b(nbt);
                TileEntity tileEntityCopy = TileEntity.func_145827_c((NBTTagCompound)nbt);
                tileEntityCopy.func_145834_a(world);
                tileEntityCopy.field_145851_c = coordsWorld.x;
                tileEntityCopy.field_145848_d = coordsWorld.y;
                tileEntityCopy.field_145849_e = coordsWorld.z;
                tileEntityCopy.func_145829_t();
                world.func_147455_a(coordsWorld.x, coordsWorld.y, coordsWorld.z, tileEntityCopy);
            }
            catch (Exception ex) {
                world.func_147475_p(coordsWorld.x, coordsWorld.y, coordsWorld.z);
                Ships.logger.warning(ex, "Tile entity %s at (%d,%d,%d) didn't like being moved to the world. The tile entity has been removed from its block to prevent further errors.", tileEntity.getClass().getName(), coordsWorld.x, coordsWorld.y, coordsWorld.z);
            }
        }
        Coords translation = correspondence.get(new Coords(0, 0, 0));
        if (!world.field_72995_K) {
            for (Map.Entry entry : this.m_hangingEntities.entrySet()) {
                Coords coordsShip = (Coords)entry.getKey();
                Coords coordsWorld = correspondence.get(coordsShip);
                EntityHanging hangingEntity = (EntityHanging)entry.getValue();
                try {
                    NBTTagCompound nbt = new NBTTagCompound();
                    hangingEntity.func_70039_c(nbt);
                    EntityHanging hangingEntityCopy = (EntityHanging)EntityList.func_75615_a((NBTTagCompound)nbt, (World)world);
                    hangingEntityCopy.field_146063_b = coordsWorld.x;
                    hangingEntityCopy.field_146064_c = coordsWorld.y;
                    hangingEntityCopy.field_146062_d = coordsWorld.z;
                    hangingEntityCopy.field_70165_t += (double)translation.x;
                    hangingEntityCopy.field_70163_u += (double)translation.y;
                    hangingEntityCopy.field_70161_v += (double)translation.z;
                    hangingEntityCopy.func_82328_a(hangingEntityCopy.field_82332_a);
                    world.func_72838_d((Entity)hangingEntityCopy);
                }
                catch (Exception ex) {
                    Ships.logger.warning(ex, "Hanging entity %s at (%d,%d,%d) didn't like being moved to the world. The block was moved, the but hanging entity was not moved.", hangingEntity.getClass().getName(), coordsWorld.x, coordsWorld.y, coordsWorld.z);
                }
            }
        }
    }

    public BlockMap<EntityHanging> getNearbyHangingEntities(World world, BlockSet blocks) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        blocks.getBoundingBox().toAxisAlignedBB(box);
        BlockMap<EntityHanging> out = new BlockMap<EntityHanging>();
        Coords entityBlock = new Coords(0, 0, 0);
        List hangingEntities = world.func_72872_a(EntityHanging.class, box);
        for (EntityHanging hangingEntity : hangingEntities) {
            entityBlock.set(hangingEntity.field_146063_b, hangingEntity.field_146064_c, hangingEntity.field_146062_d);
            if (!blocks.contains(entityBlock)) continue;
            out.put(new Coords(entityBlock), hangingEntity);
        }
        return out;
    }

    public BlocksStorage getBlocksStorage() {
        return this.m_storage;
    }

    public EntityShip getShip() {
        return this.m_ship;
    }

    public void setShip(EntityShip val) {
        this.m_ship = val;
    }

    public ShipType getShipType() {
        return ShipType.getByMeta(this.func_72805_g(0, 0, 0));
    }

    public boolean isValid() {
        return this.m_storage.getNumBlocks() > 0;
    }

    public int getNumBlocks() {
        return this.m_storage.getNumBlocks();
    }

    public Set<Coords> coords() {
        return this.m_storage.coords();
    }

    public BlockMap<TileEntity> tileEntities() {
        return this.m_tileEntities;
    }

    public BlockMap<EntityHanging> hangingEntities() {
        return this.m_hangingEntities;
    }

    public int getBiomeId() {
        return this.m_biomeId;
    }

    public ShipGeometry getGeometry() {
        return this.m_storage.getGeometry();
    }

    public ShipDisplacement getDisplacement() {
        return this.m_storage.getDisplacement();
    }

    public BoundingBoxInt getBoundingBox() {
        return this.m_storage.getGeometry().getEnvelopes().getBoundingBox();
    }

    public BlockStorage getBlockStorage(int x, int y, int z) {
        this.m_lookupCoords.set(x, y, z);
        return this.getBlockStorage(this.m_lookupCoords);
    }

    public BlockStorage getBlockStorage(Coords coords) {
        return this.m_storage.getBlock(coords);
    }

    public Block func_147439_a(int x, int y, int z) {
        this.m_lookupCoords.set(x, y, z);
        return this.getBlock(this.m_lookupCoords);
    }

    public Block getBlock(Coords coords) {
        return this.getBlockStorage((Coords)coords).block;
    }

    public boolean func_72899_e(int x, int y, int z) {
        return true;
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        this.m_lookupCoords.set(x, y, z);
        return this.getTileEntity(this.m_lookupCoords);
    }

    public TileEntity getTileEntity(Coords coords) {
        return (TileEntity)this.m_tileEntities.get(coords);
    }

    public int func_72805_g(int x, int y, int z) {
        this.m_lookupCoords.set(x, y, z);
        return this.getBlockMetadata(this.m_lookupCoords);
    }

    public int getBlockMetadata(Coords coords) {
        return this.getBlockStorage((Coords)coords).meta;
    }

    public boolean func_147465_d(int x, int y, int z, Block newBlock, int newMeta, int ignored) {
        if (this.applyBlockChange(x, y, z, newBlock, newMeta)) {
            if (Environment.isServer()) {
                this.m_changedBlocks.add(new Coords(x, y, z));
            }
            return true;
        }
        return false;
    }

    public void func_147455_a(int x, int y, int z, TileEntity tileEntity) {
    }

    public boolean func_72921_c(int x, int y, int z, int meta, int ignored) {
        if (this.applyBlockChange(x, y, z, this.func_147439_a(x, y, z), meta)) {
            if (Environment.isServer()) {
                this.m_changedBlocks.add(new Coords(x, y, z));
            }
            return true;
        }
        return false;
    }

    public boolean needsRenderUpdate() {
        boolean val = this.m_needsRenderUpdate;
        this.m_needsRenderUpdate = false;
        return val;
    }

    public boolean applyBlockChange(int x, int y, int z, Block newBlock, int newMeta) {
        this.m_lookupCoords.set(x, y, z);
        return this.applyBlockChange(this.m_lookupCoords, newBlock, newMeta);
    }

    public boolean applyBlockChange(Coords coords, Block newBlock, int newMeta) {
        boolean isAllowed;
        BlockStorage storage = this.getBlockStorage(coords);
        Block oldBlock = storage.block;
        boolean bl = isAllowed = oldBlock == newBlock || oldBlock == Blocks.field_150470_am && newBlock == Blocks.field_150460_al || oldBlock == Blocks.field_150460_al && newBlock == Blocks.field_150470_am;
        if (isAllowed) {
            storage.block = newBlock;
            storage.meta = newMeta;
            TileEntity tileEntity = this.getTileEntity(coords);
            if (tileEntity != null) {
                tileEntity.func_145836_u();
            }
            this.m_needsRenderUpdate = true;
        }
        return isAllowed;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean defaultValue) {
        this.m_lookupCoords.set(x, y, z);
        Block block = this.getBlock(this.m_lookupCoords);
        if (block == Blocks.field_150350_a) {
            return defaultValue;
        }
        return block.isSideSolid((IBlockAccess)this, x, y, z, side);
    }

    @Override
    public boolean func_147445_c(int x, int y, int z, boolean defaultValue) {
        this.m_lookupCoords.set(x, y, z);
        Block block = this.getBlock(this.m_lookupCoords);
        if (block == Blocks.field_150350_a) {
            return defaultValue;
        }
        return block.isNormalCube((IBlockAccess)this, x, y, z);
    }

    @Override
    public int func_72802_i(int x, int y, int z, int blockBrightness) {
        return 0xF00000;
    }

    public List func_82733_a(Class theClass, AxisAlignedBB box, IEntitySelector selector) {
        return new ArrayList();
    }

    public List func_94576_a(Entity entity, AxisAlignedBB box, IEntitySelector selector) {
        return new ArrayList();
    }

    public void func_147476_b(int x, int y, int z, TileEntity tileEntity) {
    }

    public void func_72939_s() {
        Iterator iter = this.m_tileEntities.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Coords coords = (Coords)entry.getKey();
            TileEntity entity = (TileEntity)entry.getValue();
            try {
                entity.func_145845_h();
            }
            catch (Exception ex) {
                iter.remove();
                Ships.logger.warning(ex, "Tile entity %s at (%d,%d,%d) had a problem during an update! The tile entity has been removed from its block to prevent further errors.", entity.getClass().getName(), coords.x, coords.y, coords.z);
            }
        }
        if (Environment.isClient() && this.m_ship != null) {
            this.updateEntitiesClient();
        }
        if (Environment.isServer() && !this.m_changedBlocks.isEmpty()) {
            this.pushBlockChangesToClients();
            this.m_changedBlocks.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateEntitiesClient() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Vec3 v = Vec3.func_72443_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v);
        this.m_ship.worldToShip(v);
        this.m_ship.shipToBlocks(v);
        int playerX = MathHelper.func_76128_c((double)v.field_72450_a);
        int playerY = MathHelper.func_76128_c((double)v.field_72448_b);
        int playerZ = MathHelper.func_76128_c((double)v.field_72449_c);
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            int z;
            int y;
            int x = playerX + random.nextInt(16) - random.nextInt(16);
            Block block = this.func_147439_a(x, y = playerY + random.nextInt(16) - random.nextInt(16), z = playerZ + random.nextInt(16) - random.nextInt(16));
            if (block == Blocks.field_150350_a) continue;
            try {
                block.func_149734_b((World)this, x, y, z, random);
                continue;
            }
            catch (Throwable t) {
                Ships.logger.error(t, "Block threw up during random tick: %s", Block.field_149771_c.func_148750_c((Object)block));
            }
        }
    }

    private void pushBlockChangesToClients() {
        if (this.m_ship == null) {
            return;
        }
        Ships.net.getDispatch().sendToAllAround((IMessage)new PacketChangedBlocks(this.m_ship, this.m_changedBlocks), new NetworkRegistry.TargetPoint(this.m_ship.field_70170_p.field_73011_w.field_76574_g, this.m_ship.field_70165_t, this.m_ship.field_70163_u, this.m_ship.field_70161_v, 64.0));
    }

    public void func_147452_c(int x, int y, int z, Block block, int eventId, int eventParam) {
        if (this.m_ship == null || block == Blocks.field_150350_a || this.func_147439_a(x, y, z) != block) {
            return;
        }
        boolean eventWasAccepted = block.func_149696_a((World)this, x, y, z, eventId, eventParam);
        if (Environment.isServer() && eventWasAccepted) {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            this.m_ship.blocksToShip(v);
            this.m_ship.shipToWorld(v);
            Ships.net.getDispatch().sendToAllAround((IMessage)new PacketShipBlockEvent(this.m_ship.func_145782_y(), x, y, z, block, eventId, eventParam), new NetworkRegistry.TargetPoint(this.m_ship.field_70170_p.field_73011_w.field_76574_g, v.field_72450_a, v.field_72448_b, v.field_72449_c, 64.0));
        }
    }

    public void func_72908_a(double x, double y, double z, String sound, float volume, float pitch) {
        if (sound == null) {
            return;
        }
        if (Environment.isServer()) {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            this.m_ship.blocksToShip(v);
            this.m_ship.shipToWorld(v);
            this.m_ship.field_70170_p.func_72908_a(v.field_72450_a, v.field_72448_b, v.field_72449_c, sound, volume, pitch);
        }
    }

    public void func_72889_a(EntityPlayer player, int sfxID, int x, int y, int z, int auxData) {
        if (Environment.isServer()) {
            Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
            this.m_ship.blocksToShip(v);
            this.m_ship.shipToWorld(v);
            this.m_ship.field_70170_p.func_72889_a(player, sfxID, MathHelper.func_76128_c((double)v.field_72450_a), MathHelper.func_76128_c((double)v.field_72448_b), MathHelper.func_76128_c((double)v.field_72449_c), auxData);
        }
    }

    public void func_72869_a(String name, double x, double y, double z, double motionX, double motionY, double motionZ) {
        if (this.m_ship == null) {
            return;
        }
        Vec3 v = Vec3.func_72443_a((double)x, (double)y, (double)z);
        this.m_ship.blocksToShip(v);
        this.m_ship.shipToWorld(v);
        x = v.field_72450_a;
        y = v.field_72448_b;
        z = v.field_72449_c;
        v.field_72450_a = motionX;
        v.field_72448_b = motionY;
        v.field_72449_c = motionZ;
        this.m_ship.shipToWorldDirection(v);
        motionX = v.field_72450_a;
        motionY = v.field_72448_b;
        motionZ = v.field_72449_c;
        this.m_ship.field_70170_p.func_72869_a(name, x, y, z, motionX, motionY, motionZ);
    }

    public boolean func_72838_d(Entity entity) {
        if (this.m_ship == null) {
            return false;
        }
        Vec3 v = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        this.m_ship.blocksToShip(v);
        this.m_ship.shipToWorld(v);
        entity.field_70165_t = v.field_72450_a;
        entity.field_70163_u = v.field_72448_b;
        entity.field_70161_v = v.field_72449_c;
        v.field_72450_a = entity.field_70159_w;
        v.field_72448_b = entity.field_70181_x;
        v.field_72449_c = entity.field_70179_y;
        this.m_ship.shipToWorldDirection(v);
        entity.field_70159_w = v.field_72450_a;
        entity.field_70181_x = v.field_72448_b;
        entity.field_70179_y = v.field_72449_c;
        entity.field_70170_p = this.m_ship.field_70170_p;
        return this.m_ship.field_70170_p.func_72838_d(entity);
    }

    @Override
    public BiomeGenBase func_72807_a(int x, int z) {
        return BiomeGenBase.func_150568_d((int)this.m_biomeId);
    }
}

