/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.Environment;
import cuchaz.modsShared.Util;
import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.math.CircleRange;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PlayerRespawner;
import cuchaz.ships.config.BlockProperties;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;

public class ShipUnlauncher {
    private EntityShip m_ship;
    private List<Boolean> m_unlaunchFlags;
    private BlockMap<Coords> m_correspondence;
    private int m_waterHeightInBlockSpace;
    private double m_deltaRotationRadians;
    private Vec3 m_deltaTranslation;

    public ShipUnlauncher(EntityShip ship) {
        this.m_ship = ship;
        this.computeCorrespondence();
        this.m_unlaunchFlags = new ArrayList<Boolean>();
        for (UnlaunchFlag flag : UnlaunchFlag.values()) {
            this.m_unlaunchFlags.add(flag.computeValue(this));
        }
    }

    private void computeCorrespondence() {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        this.m_ship.blocksToShip(p);
        this.m_ship.shipToWorld(p);
        int tx = MathHelper.func_76128_c((double)(p.field_72450_a + 0.5));
        int ty = MathHelper.func_76143_f((double)p.field_72448_b);
        int tz = MathHelper.func_76128_c((double)(p.field_72449_c + 0.5));
        this.m_deltaTranslation = Vec3.func_72443_a((double)((double)tx - p.field_72450_a), (double)((double)ty - p.field_72448_b), (double)((double)tz - p.field_72449_c));
        this.m_waterHeightInBlockSpace = MathHelper.func_76128_c((double)(this.m_ship.getWaterHeight() + 0.5)) - ty;
        BlockSet allCoords = new BlockSet();
        allCoords.addAll(this.m_ship.getShipWorld().coords());
        allCoords.addAll(this.m_ship.getShipWorld().getDisplacement().getTrappedAirFromWaterHeight(this.m_waterHeightInBlockSpace));
        double yaw = CircleRange.mapZeroToTwoPi(Math.toRadians(this.m_ship.field_70177_z));
        int rotation = Util.realModulus((int)(yaw / Math.PI * 2.0 + 0.5), 4);
        this.m_deltaRotationRadians = 1.5707963267948966 * (double)rotation - yaw;
        int cos = (new int[]{1, 0, -1, 0})[rotation];
        int sin = (new int[]{0, 1, 0, -1})[rotation];
        this.m_correspondence = new BlockMap();
        for (Coords coords : allCoords) {
            int x = coords.x * cos + coords.z * sin;
            int z = -coords.x * sin + coords.z * cos;
            Coords worldCoords = new Coords(x, coords.y, z);
            worldCoords.x += tx;
            worldCoords.y += ty;
            worldCoords.z += tz;
            this.m_correspondence.put(coords, worldCoords);
        }
    }

    public boolean getUnlaunchFlag(UnlaunchFlag flag) {
        return this.m_unlaunchFlags.get(flag.ordinal());
    }

    public boolean isUnlaunchable() {
        return this.isUnlaunchable(false);
    }

    public boolean isUnlaunchable(boolean override) {
        boolean isValid = true;
        for (UnlaunchFlag flag : UnlaunchFlag.values()) {
            isValid = isValid && (this.getUnlaunchFlag(flag) || override && flag.isOverrideAllowed());
        }
        return isValid;
    }

    public void unlaunch() {
        if (Environment.isClient()) {
            return;
        }
        this.m_ship.func_70106_y();
        this.m_ship.getShipWorld().restoreToWorld(this.m_ship.field_70170_p, this.m_correspondence, this.m_waterHeightInBlockSpace);
        PlayerRespawner.onShipDock((WorldServer)this.m_ship.field_70170_p, this.m_ship.getShipWorld(), this.m_correspondence);
    }

    public void snapToLaunchDirection() {
        this.m_ship.func_70080_a(this.m_ship.field_70165_t, this.m_ship.field_70163_u, this.m_ship.field_70161_v, 0.0f, this.m_ship.field_70125_A);
    }

    public void applyUnlaunch(Entity entity) {
        Vec3 p = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        p.field_72450_a = entity.field_70165_t + this.m_deltaTranslation.field_72450_a;
        p.field_72449_c = entity.field_70161_v + this.m_deltaTranslation.field_72449_c;
        this.m_ship.worldToShip(p);
        double cos = Math.cos(this.m_deltaRotationRadians);
        double sin = Math.sin(this.m_deltaRotationRadians);
        double x = p.field_72450_a * cos + p.field_72449_c * sin;
        double z = -p.field_72450_a * sin + p.field_72449_c * cos;
        p.field_72450_a = x;
        p.field_72449_c = z;
        this.m_ship.shipToWorld(p);
        entity.field_70177_z = (float)((double)entity.field_70177_z - Math.toDegrees(this.m_deltaRotationRadians));
        entity.func_70107_b(p.field_72450_a, entity.field_70163_u + this.m_deltaTranslation.field_72448_b, p.field_72449_c);
    }

    public static enum UnlaunchFlag {
        AlignedToDirection(false){

            @Override
            public boolean computeValue(ShipUnlauncher unlauncher) {
                return (double)Math.abs(MathHelper.func_76142_g((float)((ShipUnlauncher)unlauncher).m_ship.field_70177_z)) < 10.0;
            }
        }
        ,
        TouchingOnlySeparatorBlocks(true){

            @Override
            public boolean computeValue(ShipUnlauncher unlauncher) {
                BlockSet placedBlocks = new BlockSet();
                placedBlocks.addAll(unlauncher.m_correspondence.values());
                Coords neighborCoords = new Coords(0, 0, 0);
                for (Coords coords : placedBlocks) {
                    for (BlockSide side : BlockSide.values()) {
                        neighborCoords.x = coords.x + side.getDx();
                        neighborCoords.y = coords.y + side.getDy();
                        neighborCoords.z = coords.z + side.getDz();
                        if (placedBlocks.contains(neighborCoords) || BlockProperties.isSeparator(this.getBlock((IBlockAccess)((ShipUnlauncher)unlauncher).m_ship.field_70170_p, neighborCoords))) continue;
                        return false;
                    }
                }
                return true;
            }
        };

        private boolean m_allowOverride;

        private UnlaunchFlag(boolean allowOverride) {
            this.m_allowOverride = allowOverride;
        }

        public boolean isOverrideAllowed() {
            return this.m_allowOverride;
        }

        public abstract boolean computeValue(ShipUnlauncher var1);

        protected Block getBlock(IBlockAccess world, Coords coords) {
            return world.func_147439_a(coords.x, coords.y, coords.z);
        }
    }
}

