/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.ships.Ships;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public enum ShipType {
    Tiny(20, true){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151042_j), Character.valueOf('y'), new ItemStack(Items.field_151137_ax)});
        }
    }
    ,
    Small(200, false){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xzx", "zyz", "xzx", Character.valueOf('x'), new ItemStack(Items.field_151042_j), Character.valueOf('y'), new ItemStack(Items.field_151137_ax), Character.valueOf('z'), new ItemStack(Items.field_151043_k)});
        }
    }
    ,
    Medium(400, false){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151043_k), Character.valueOf('y'), new ItemStack(Items.field_151137_ax)});
        }
    }
    ,
    Large(1000, false){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xzx", "zyz", "xzx", Character.valueOf('x'), new ItemStack(Items.field_151043_k), Character.valueOf('y'), new ItemStack(Items.field_151137_ax), Character.valueOf('z'), new ItemStack(Items.field_151100_aR, 1, 4)});
        }
    }
    ,
    Huge(2000, false){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('y'), new ItemStack(Items.field_151137_ax)});
        }
    }
    ,
    Gigantic(4000, false){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xzx", "zyz", "xzx", Character.valueOf('x'), new ItemStack(Items.field_151100_aR, 1, 4), Character.valueOf('y'), new ItemStack(Items.field_151137_ax), Character.valueOf('z'), new ItemStack(Items.field_151045_i)});
        }
    }
    ,
    Epic(10000, false){

        @Override
        protected void registerBlock() {
            GameRegistry.addRecipe((ItemStack)this.newItemStack(), (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), new ItemStack(Items.field_151045_i), Character.valueOf('y'), new ItemStack(Items.field_151137_ax)});
        }
    };

    private int m_maxNumBlocks;
    private boolean m_isPaddleable;
    @SideOnly(value=Side.CLIENT)
    private IIcon m_icon;

    private ShipType(int maxNumBlocks, boolean isPaddleable) {
        this.m_maxNumBlocks = maxNumBlocks;
        this.m_isPaddleable = isPaddleable;
    }

    public int getMaxNumBlocks() {
        return this.m_maxNumBlocks;
    }

    public boolean isPaddleable() {
        return this.m_isPaddleable;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister iconRegister) {
        for (ShipType type : ShipType.values()) {
            type.m_icon = iconRegister.func_94245_a("ships:shipSide-" + type.name().toLowerCase());
        }
    }

    public IIcon getIcon() {
        return this.m_icon;
    }

    public static ShipType getByMeta(int meta) {
        return ShipType.values()[meta];
    }

    public int getMeta() {
        return this.ordinal();
    }

    public ItemStack newItemStack() {
        return new ItemStack((Block)Ships.m_blockShip, 1, this.getMeta());
    }

    public static void registerRecipes() {
        for (ShipType type : ShipType.values()) {
            type.registerBlock();
        }
    }

    protected abstract void registerBlock();
}

