/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.Util;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.propulsion.Propulsion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ShipPhysics {
    private static final double AccelerationGravity = Util.perSecond2ToPerTick2(9.8);
    private static final double AirViscosity = 0.1;
    private static final double WaterViscosity = 3.0;
    private static final double AngularViscosityScale = 0.06;
    private static final double BaseLinearDrag = Util.perSecondToPerTick(0.01);
    private static final double BaseAngularDrag = Util.perSecondToPerTick(1.0);
    private static final float AngularAccelerationFactor = 20.0f;
    private static final int NumSimulationTicks = 400;
    private BlocksStorage m_blocks;
    private double m_shipMass;
    private Vec3 m_centerOfMass;
    private Double m_equilibriumWaterHeight;
    private Integer m_sinkWaterHeight;
    private Map<Integer, ScaledDisplacementEntry> m_displacement;

    public ShipPhysics(BlocksStorage blocks) {
        this.m_blocks = blocks;
        this.m_shipMass = 0.0;
        for (Coords coords : this.m_blocks.coords()) {
            this.m_shipMass += BlockProperties.getMass(this.getBlock(coords));
        }
        this.m_centerOfMass = this.computeCenterOfMass();
        this.m_displacement = new TreeMap<Integer, ScaledDisplacementEntry>();
        this.m_equilibriumWaterHeight = this.computeEquilibriumWaterHeight();
        this.m_sinkWaterHeight = this.m_blocks.getDisplacement().getLastFillY();
        ScaledDisplacementEntry lastDisplacement = this.getScaledDisplacement(this.m_blocks.getDisplacement().getMaxY() + 1);
        if (lastDisplacement.surfaceDisplacement + lastDisplacement.underwaterDisplacement > this.m_shipMass) {
            this.m_sinkWaterHeight = null;
        }
    }

    public double getMass() {
        return this.m_shipMass;
    }

    public Vec3 getCenterOfMass() {
        return this.m_centerOfMass;
    }

    public double getNetUpAcceleration(double waterHeight) {
        return (this.getDisplacedWaterMass(waterHeight) - this.m_shipMass) * AccelerationGravity / this.m_shipMass;
    }

    public double getDisplacedWaterMass(double waterHeight) {
        int surfaceLevel = MathHelper.func_76128_c((double)waterHeight);
        double surfaceFraction = this.getBlockFractionSubmerged(surfaceLevel, waterHeight);
        return (this.getUnderwaterDisplacement(surfaceLevel) + this.getSurfaceDisplacement(surfaceLevel) * surfaceFraction) * this.getWaterBlockMass();
    }

    public Double getEquilibriumWaterHeight() {
        return this.m_equilibriumWaterHeight;
    }

    public Integer getSinkWaterHeight() {
        return this.m_sinkWaterHeight;
    }

    public boolean willItFloat() {
        return this.m_equilibriumWaterHeight != null;
    }

    public double getLinearAccelerationDueToThrust(Propulsion propulsion, double speed) {
        return propulsion.getTotalThrust(speed) / this.m_shipMass;
    }

    public double getLinearAccelerationDueToDrag(Vec3 velocity, double waterHeight) {
        BlockSide leadingSide = null;
        double bestDot = Double.NEGATIVE_INFINITY;
        for (BlockSide side : BlockSide.values()) {
            double dot = (double)side.getDx() * velocity.field_72450_a + (double)side.getDz() * velocity.field_72449_c;
            if (!(dot > bestDot)) continue;
            bestDot = dot;
            leadingSide = side;
        }
        assert (leadingSide != null);
        double airSurfaceArea = 0.0;
        double waterSurfaceArea = 0.0;
        for (Coords coords : this.m_blocks.getGeometry().getEnvelopes().getEnvelope(leadingSide).toBlockSet()) {
            double fractionSubmerged = leadingSide.getFractionSubmerged(coords.y, waterHeight);
            waterSurfaceArea += fractionSubmerged;
            airSurfaceArea += 1.0 - fractionSubmerged;
        }
        double linearViscosity = 0.1 * airSurfaceArea + 3.0 * waterSurfaceArea;
        double speed = velocity.func_72433_c();
        return BaseLinearDrag + speed * speed * linearViscosity / this.m_shipMass;
    }

    public float getAngularAccelerationDueToThrust(Propulsion propulsion) {
        return (float)this.getLinearAccelerationDueToThrust(propulsion, 0.0) * 20.0f;
    }

    public float getAngularAccelerationDueToDrag(float motionYaw, double waterHeight) {
        double angularViscosity = 0.0 + this.getAngularViscosity(BlockSide.North, waterHeight, this.m_centerOfMass.field_72450_a) + this.getAngularViscosity(BlockSide.East, waterHeight, this.m_centerOfMass.field_72449_c);
        return (float)(BaseAngularDrag + (double)(motionYaw * motionYaw) * angularViscosity / this.m_shipMass);
    }

    public List<AccelerationEntry> getLinearAcceleration(Propulsion propulsion, double stopSpeed, int numSteps) {
        if (this.m_equilibriumWaterHeight == null) {
            throw new IllegalArgumentException("Cannot compute acceleration for a non-buoyant ship!");
        }
        ArrayList<AccelerationEntry> entries = new ArrayList<AccelerationEntry>(numSteps);
        Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int i = 0; i < numSteps; ++i) {
            double speed = this.interpolateSpeed(stopSpeed, numSteps, i);
            velocity.field_72450_a = speed * (double)propulsion.getFrontSide().getDx();
            velocity.field_72449_c = speed * (double)propulsion.getFrontSide().getDz();
            entries.add(new AccelerationEntry(speed, this.getLinearAccelerationDueToThrust(propulsion, speed), this.getLinearAccelerationDueToDrag(velocity, this.m_equilibriumWaterHeight)));
        }
        return entries;
    }

    public List<AccelerationEntry> getAngularAcceleration(Propulsion propulsion, double stopSpeed, int numSteps) {
        if (this.m_equilibriumWaterHeight == null) {
            throw new IllegalArgumentException("Cannot compute acceleration for a non-buoyant ship!");
        }
        ArrayList<AccelerationEntry> entries = new ArrayList<AccelerationEntry>(numSteps);
        for (int i = 0; i < numSteps; ++i) {
            double speed = this.interpolateSpeed(stopSpeed, numSteps, i);
            entries.add(new AccelerationEntry(speed, this.getAngularAccelerationDueToThrust(propulsion), this.getAngularAccelerationDueToDrag((float)speed, this.m_equilibriumWaterHeight)));
        }
        return entries;
    }

    private double interpolateSpeed(double stopSpeed, int numSteps, int i) {
        return (double)i / (double)(numSteps - 1) * stopSpeed;
    }

    public SimulationResult simulateLinearAcceleration(Propulsion propulsion) {
        int i;
        if (this.m_equilibriumWaterHeight == null) {
            throw new IllegalArgumentException("Cannot simulate acceleration for a non-buoyant ship!");
        }
        double speed = 0.0;
        Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (i = 0; i < 400; ++i) {
            velocity.field_72450_a = speed * (double)propulsion.getFrontSide().getDx();
            velocity.field_72449_c = speed * (double)propulsion.getFrontSide().getDz();
            double thrustAcceleration = this.getLinearAccelerationDueToThrust(propulsion, speed);
            double dragAcceleration = this.getLinearAccelerationDueToDrag(velocity, this.m_equilibriumWaterHeight);
            dragAcceleration = Math.min(speed + thrustAcceleration, dragAcceleration);
            double netAcceleration = thrustAcceleration - dragAcceleration;
            speed += netAcceleration;
            if (Math.abs(netAcceleration) < 1.0E-4) break;
        }
        return new SimulationResult(speed, i);
    }

    public SimulationResult simulateAngularAcceleration(Propulsion propulsion) {
        int i;
        if (this.m_equilibriumWaterHeight == null) {
            throw new IllegalArgumentException("Cannot simulate acceleration for a non-buoyant ship!");
        }
        double thrustAcceleration = this.getAngularAccelerationDueToThrust(propulsion);
        float speed = 0.0f;
        for (i = 0; i < 400; ++i) {
            double dragAcceleration = this.getAngularAccelerationDueToDrag(speed, this.m_equilibriumWaterHeight);
            dragAcceleration = Math.min((double)speed + thrustAcceleration, dragAcceleration);
            double netAcceleration = thrustAcceleration - dragAcceleration;
            speed = (float)((double)speed + netAcceleration);
            if (Math.abs(netAcceleration) < 1.0E-4) break;
        }
        return new SimulationResult(speed, i);
    }

    public String dumpBlockProperties() {
        StringBuilder buf = new StringBuilder();
        for (Coords coords : this.m_blocks.coords()) {
            double mass = BlockProperties.getMass(this.getBlock(coords));
            buf.append(String.format("%3d,%3d,%3d %4d %4.1f\n", coords.x, coords.y, coords.z, this.m_blocks.getBlock((Coords)coords).block, mass));
        }
        return buf.toString();
    }

    private double getUnderwaterDisplacement(int y) {
        return this.getScaledDisplacement((int)y).underwaterDisplacement;
    }

    private double getSurfaceDisplacement(int y) {
        return this.getScaledDisplacement((int)y).surfaceDisplacement;
    }

    private ScaledDisplacementEntry getScaledDisplacement(int y) {
        ScaledDisplacementEntry entry = this.m_displacement.get(y);
        if (entry == null) {
            entry = new ScaledDisplacementEntry();
            entry.surfaceDisplacement = 0.0;
            for (Coords coords : this.m_blocks.getDisplacement().getSurfaceBlocks(y)) {
                entry.surfaceDisplacement += BlockProperties.getDisplacement(this.getBlock(coords));
            }
            entry.underwaterDisplacement = 0.0;
            for (Coords coords : this.m_blocks.getDisplacement().getUnderwaterBlocks(y)) {
                entry.underwaterDisplacement += BlockProperties.getDisplacement(this.getBlock(coords));
            }
        }
        return entry;
    }

    private Double computeEquilibriumWaterHeight() {
        int minY = this.m_blocks.getBoundingBox().minY;
        int maxY = this.m_blocks.getBoundingBox().maxY;
        for (int y = minY; y <= maxY + 1; ++y) {
            double surfaceDisplacement;
            double underwaterDisplacement = this.getUnderwaterDisplacement(y);
            double displacedWaterMass = (underwaterDisplacement + (surfaceDisplacement = this.getSurfaceDisplacement(y))) * this.getWaterBlockMass();
            if (!(displacedWaterMass > this.m_shipMass)) continue;
            return (double)y + (this.m_shipMass - underwaterDisplacement * this.getWaterBlockMass()) / surfaceDisplacement / this.getWaterBlockMass();
        }
        return null;
    }

    private Vec3 computeCenterOfMass() {
        Vec3 com = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        double totalMass = 0.0;
        for (Coords coords : this.m_blocks.coords()) {
            double mass = BlockProperties.getMass(this.getBlock(coords));
            totalMass += mass;
            com.field_72450_a += mass * ((double)coords.x + 0.5);
            com.field_72448_b += mass * ((double)coords.y + 0.5);
            com.field_72449_c += mass * ((double)coords.z + 0.5);
        }
        com.field_72450_a /= totalMass;
        com.field_72448_b /= totalMass;
        com.field_72449_c /= totalMass;
        return com;
    }

    private double getBlockFractionSubmerged(int y, double waterHeight) {
        return BlockSide.North.getFractionSubmerged(y, waterHeight);
    }

    private double getAngularViscosity(BlockSide side, double waterHeight, double center) {
        int centerCoord = (int)center;
        double viscosity = 0.0;
        for (Coords coords : this.m_blocks.getGeometry().getEnvelopes().getEnvelope(side).toBlockSet()) {
            double fractionSubmerged = side.getFractionSubmerged(coords.y, waterHeight);
            double dist = Math.abs(side.getU(coords.x, coords.y, coords.z) - centerCoord);
            viscosity += (fractionSubmerged * 3.0 + (1.0 - fractionSubmerged) * 0.1) * dist;
        }
        return viscosity * 0.06;
    }

    private Block getBlock(Coords coords) {
        return this.m_blocks.getBlock((Coords)coords).block;
    }

    private double getWaterBlockMass() {
        return BlockProperties.getMass(Blocks.field_150355_j);
    }

    private static class ScaledDisplacementEntry {
        double surfaceDisplacement;
        double underwaterDisplacement;

        private ScaledDisplacementEntry() {
        }
    }

    public static class SimulationResult {
        public double topSpeed;
        public double elapsedTicks;

        public SimulationResult(double topSpeed, double elapsedSeconds) {
            this.topSpeed = topSpeed;
            this.elapsedTicks = elapsedSeconds;
        }
    }

    public static class AccelerationEntry {
        public double speed;
        public double accelerationDueToThrust;
        public double accelerationDueToDrag;

        public AccelerationEntry(double speed, double accelerationDueToThrust, double accelerationDueToDrag) {
            this.speed = speed;
            this.accelerationDueToThrust = accelerationDueToThrust;
            this.accelerationDueToDrag = accelerationDueToDrag;
        }
    }
}

