/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.EntityUtils;
import cuchaz.ships.EntityShip;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ShipLocator {
    public static List<EntityShip> getShips(World world) {
        ArrayList<EntityShip> ships = new ArrayList<EntityShip>();
        for (Object entity : world.field_72996_f) {
            if (!(entity instanceof EntityShip)) continue;
            ships.add((EntityShip)((Object)entity));
        }
        return ships;
    }

    public static EntityShip getShip(World world, int entityId) {
        return ShipLocator.getShip(ShipLocator.getShips(world), entityId);
    }

    public static EntityShip getShip(World world, UUID uuid) {
        return ShipLocator.getShip(ShipLocator.getShips(world), uuid);
    }

    private static EntityShip getShip(List<EntityShip> ships, int entityId) {
        for (EntityShip ship : ships) {
            if (ship.func_145782_y() != entityId) continue;
            return ship;
        }
        return null;
    }

    private static EntityShip getShip(List<EntityShip> ships, UUID uuid) {
        for (EntityShip ship : ships) {
            if (!ship.getPersistentID().equals(uuid)) continue;
            return ship;
        }
        return null;
    }

    public static EntityShip getFromPlayerLook(EntityPlayer player) {
        Vec3 eyePos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)player.func_70047_e()), (double)player.field_70161_v);
        double toRadians = Math.PI / 180;
        float pitch = (float)((double)player.field_70125_A * (Math.PI / 180));
        float yaw = (float)((double)player.field_70177_z * (Math.PI / 180));
        float cosYaw = MathHelper.func_76134_b((float)(-yaw - (float)Math.PI));
        float sinYaw = MathHelper.func_76126_a((float)(-yaw - (float)Math.PI));
        float cosPitch = MathHelper.func_76134_b((float)(-pitch));
        float sinPitch = MathHelper.func_76126_a((float)(-pitch));
        double reachDistance = EntityUtils.getPlayerReachDistance(player);
        Vec3 targetPos = eyePos.func_72441_c((double)(sinYaw * -cosPitch) * reachDistance, (double)sinPitch * reachDistance, (double)(cosYaw * -cosPitch) * reachDistance);
        AxisAlignedBB queryBox = player.field_70121_D.func_72329_c();
        queryBox.field_72340_a -= reachDistance;
        queryBox.field_72336_d += reachDistance;
        queryBox.field_72338_b -= reachDistance;
        queryBox.field_72337_e += reachDistance;
        queryBox.field_72339_c -= reachDistance;
        queryBox.field_72334_f += reachDistance;
        for (EntityShip ship : ShipLocator.findShipsInBox(player.field_70170_p, queryBox)) {
            if (!ship.field_70121_D.func_72318_a(eyePos) && !ship.field_70121_D.func_72318_a(targetPos) && ship.field_70121_D.func_72327_a(eyePos, targetPos) == null) continue;
            return ship;
        }
        return null;
    }

    public static List<EntityShip> getFromEntityLocation(Entity entity) {
        double delta = 0.5;
        AxisAlignedBB queryBox = entity.field_70121_D.func_72314_b(0.5, 0.5, 0.5);
        return ShipLocator.findShipsInBox(entity.field_70170_p, queryBox);
    }

    public static List<EntityShip> findShipsInBox(World world, AxisAlignedBB box) {
        ArrayList<EntityShip> ships = new ArrayList<EntityShip>();
        for (EntityShip ship : ShipLocator.getShips(world)) {
            if (!ship.field_70121_D.func_72326_a(box)) continue;
            ships.add(ship);
        }
        return ships;
    }
}

