/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockArray;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.blocks.Envelopes;
import cuchaz.ships.EntityShip;
import cuchaz.ships.PlayerRespawner;
import cuchaz.ships.ShipPhysics;
import cuchaz.ships.ShipType;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.packets.PacketShipLaunched;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ShipLauncher {
    public static final BlockUtils.Neighbors ShipBlockNeighbors = BlockUtils.Neighbors.Edges;
    private World m_world;
    private Coords m_shipBlock;
    private ShipType m_shipType;
    private BlockSet m_blocks;
    private List<Boolean> m_launchFlags;
    private ShipWorld m_shipWorld;
    private ShipPhysics m_shipPhysics;
    private Double m_equilibriumWaterHeight;
    private Integer m_sinkWaterHeight;
    private int m_numBlocksChecked;

    public ShipLauncher(final World world, Coords shipBlock) {
        this.m_world = world;
        this.m_shipBlock = shipBlock;
        this.m_shipType = Ships.m_blockShip.getShipType(world, this.m_shipBlock.x, this.m_shipBlock.y, this.m_shipBlock.z);
        int numBlocksToCheck = this.getNumBlocksToCheck();
        this.m_blocks = BlockUtils.searchForBlocks(this.m_shipBlock.x, this.m_shipBlock.y, this.m_shipBlock.z, numBlocksToCheck, new BlockUtils.BlockExplorer(){

            @Override
            public boolean shouldExploreBlock(Coords coords) {
                return !BlockProperties.isSeparator(world.func_147439_a(coords.x, coords.y, coords.z));
            }
        }, ShipBlockNeighbors);
        if (this.m_blocks != null) {
            this.m_numBlocksChecked = this.m_blocks.size();
            if (this.m_blocks.size() > this.m_shipType.getMaxNumBlocks()) {
                this.m_blocks = null;
            } else {
                this.m_blocks.add(this.m_shipBlock);
                this.m_shipWorld = new ShipWorld(this.m_world, this.m_shipBlock, this.m_blocks);
                this.m_shipPhysics = new ShipPhysics(this.m_shipWorld.getBlocksStorage());
                this.m_equilibriumWaterHeight = this.m_shipPhysics.getEquilibriumWaterHeight();
                this.m_sinkWaterHeight = this.m_shipPhysics.getSinkWaterHeight();
            }
        } else {
            this.m_shipWorld = null;
            this.m_shipPhysics = null;
            this.m_equilibriumWaterHeight = null;
            this.m_sinkWaterHeight = null;
            this.m_numBlocksChecked = numBlocksToCheck;
        }
        this.m_launchFlags = new ArrayList<Boolean>();
        for (LaunchFlag flag : LaunchFlag.values()) {
            this.m_launchFlags.add(flag.computeValue(this));
        }
    }

    public Coords getShipBlock() {
        return this.m_shipBlock;
    }

    public ShipType getShipType() {
        return this.m_shipType;
    }

    public ShipWorld getShipWorld() {
        return this.m_shipWorld;
    }

    public ShipPhysics getShipPhysics() {
        return this.m_shipPhysics;
    }

    public int getNumBlocks() {
        return this.m_blocks.size() - 1;
    }

    public int getNumBlocksChecked() {
        return this.m_numBlocksChecked;
    }

    public int getNumBlocksToCheck() {
        return Math.max(100, this.m_shipType.getMaxNumBlocks() * 2);
    }

    public boolean getLaunchFlag(LaunchFlag flag) {
        return this.m_launchFlags.get(flag.ordinal());
    }

    public boolean isLaunchable() {
        boolean isValid = true;
        for (LaunchFlag flag : LaunchFlag.values()) {
            isValid = isValid && this.getLaunchFlag(flag);
        }
        return isValid;
    }

    public BlockSide getShipSide() {
        if (this.getShipBoundingBox() == null) {
            return null;
        }
        if (this.getShipBoundingBox().getDx() > this.getShipBoundingBox().getDz()) {
            return BlockSide.North;
        }
        return BlockSide.West;
    }

    public BlockSide getShipFront() {
        if (this.getShipBoundingBox() == null) {
            return null;
        }
        if (this.getShipBoundingBox().getDx() > this.getShipBoundingBox().getDz()) {
            return BlockSide.North;
        }
        return BlockSide.West;
    }

    public BoundingBoxInt getShipBoundingBox() {
        if (this.m_shipWorld == null) {
            return null;
        }
        return this.m_shipWorld.getGeometry().getEnvelopes().getBoundingBox();
    }

    public BlockArray getShipEnvelope(BlockSide side) {
        if (this.m_shipWorld == null) {
            return null;
        }
        return this.m_shipWorld.getGeometry().getEnvelopes().getEnvelope(side);
    }

    public Double getEquilibriumWaterHeight() {
        return this.m_equilibriumWaterHeight;
    }

    public Integer getSinkWaterHeight() {
        return this.m_sinkWaterHeight;
    }

    public EntityShip launch() {
        assert (Environment.isServer());
        EntityShip ship = new EntityShip(this.m_world);
        ShipLauncher.initShip(ship, this.m_shipWorld, this.m_shipBlock);
        if (!this.m_world.func_72838_d((Entity)ship)) {
            Ships.logger.warning("Could not spawn ship in world at (%.2f,%.2f,%.2f)", ship.field_70165_t, ship.field_70163_u, ship.field_70161_v);
            return null;
        }
        PlayerRespawner.onShipLaunch((WorldServer)this.m_world, this.m_shipWorld, this.m_shipBlock);
        Ships.net.getDispatch().sendToAllAround((IMessage)new PacketShipLaunched(ship, this.m_shipBlock), new NetworkRegistry.TargetPoint(ship.field_70170_p.field_73011_w.field_76574_g, ship.field_70165_t, ship.field_70163_u, ship.field_70161_v, 100.0));
        return ship;
    }

    public static void initShip(EntityShip ship, ShipWorld shipWorld, Coords shipBlock) {
        Vec3 centerOfMass = new ShipPhysics(shipWorld.getBlocksStorage()).getCenterOfMass();
        ship.func_70080_a((double)shipBlock.x + centerOfMass.field_72450_a, (double)shipBlock.y + centerOfMass.field_72448_b, (double)shipBlock.z + centerOfMass.field_72449_c, 0.0f, 0.0f);
        ship.setShipWorld(shipWorld);
        ShipLauncher.removeShipFromWorld(ship.field_70170_p, shipWorld, shipBlock, BlockUtils.UpdateRules.UpdateNoOne);
    }

    public static void removeShipFromWorld(World world, ShipWorld shipWorld, Coords shipBlock, BlockUtils.UpdateRules updateRules) {
        BlockSet worldBlocks = new BlockSet();
        for (Coords blockCoords : shipWorld.coords()) {
            worldBlocks.add(new Coords(blockCoords.x + shipBlock.x, blockCoords.y + shipBlock.y, blockCoords.z + shipBlock.z));
        }
        Coords waterBlockPos = ShipLauncher.computeWaterBlock(world, shipWorld, shipBlock);
        Block waterBlock = world.func_147439_a(waterBlockPos.x, waterBlockPos.y, waterBlockPos.z);
        int waterHeight = waterBlockPos.y + 1;
        for (Coords cords : worldBlocks) {
            if (cords.y < waterHeight) {
                BlockUtils.changeBlockWithoutNotifyingIt(world, cords.x, cords.y, cords.z, waterBlock, 0, updateRules);
                continue;
            }
            BlockUtils.removeBlockWithoutNotifyingIt(world, cords.x, cords.y, cords.z, updateRules);
        }
        Coords worldCoords = new Coords(0, 0, 0);
        for (Coords coords : shipWorld.getDisplacement().getTrappedAirFromWaterHeight(waterHeight - shipBlock.y)) {
            worldCoords.x = coords.x + shipBlock.x;
            worldCoords.y = coords.y + shipBlock.y;
            worldCoords.z = coords.z + shipBlock.z;
            BlockUtils.changeBlockWithoutNotifyingIt(world, worldCoords.x, worldCoords.y, worldCoords.z, waterBlock, 0, updateRules);
        }
        for (Map.Entry entry : shipWorld.getNearbyHangingEntities(world, worldBlocks).entrySet()) {
            EntityHanging hangingEntity = (EntityHanging)entry.getValue();
            world.func_72900_e((Entity)hangingEntity);
        }
    }

    private static Coords computeWaterBlock(World world, ShipWorld shipWorld, Coords shipBlock) {
        Coords highestWaterPos = new Coords();
        Envelopes envelopes = shipWorld.getGeometry().getEnvelopes();
        for (int x = envelopes.getBoundingBox().minX - 1; x <= envelopes.getBoundingBox().maxX + 1; ++x) {
            for (int z = envelopes.getBoundingBox().minZ - 1; z <= envelopes.getBoundingBox().maxZ + 1; ++z) {
                int waterHeight = ShipLauncher.computeWaterHeight(world, shipWorld, shipBlock, x, z);
                if (waterHeight <= highestWaterPos.y) continue;
                highestWaterPos.set(shipBlock.x + x, waterHeight, shipBlock.z + z);
            }
        }
        return highestWaterPos;
    }

    private static int computeWaterHeight(World world, ShipWorld shipWorld, Coords shipBlock, int blockX, int blockZ) {
        int y;
        Envelopes envelopes = shipWorld.getGeometry().getEnvelopes();
        int x = blockX + shipBlock.x;
        int z = blockZ + shipBlock.z;
        boolean foundAir = false;
        for (y = envelopes.getBoundingBox().maxY + 1 + shipBlock.y; y >= 0; --y) {
            if (world.func_147439_a(x, y, z).func_149688_o() != Material.field_151579_a) continue;
            foundAir = true;
            break;
        }
        if (!foundAir) {
            return -1;
        }
        while (y >= 0) {
            if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
                return y;
            }
            --y;
        }
        return -1;
    }

    public static enum LaunchFlag {
        RightNumberOfBlocks{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                return launcher.m_blocks != null && !launcher.m_blocks.isEmpty() && launcher.m_blocks.size() <= launcher.m_shipType.getMaxNumBlocks() + 1;
            }
        }
        ,
        WillItFloat{

            @Override
            public boolean computeValue(ShipLauncher launcher) {
                if (launcher.m_blocks == null || launcher.m_equilibriumWaterHeight == null) {
                    return false;
                }
                return launcher.m_equilibriumWaterHeight < (double)(launcher.getShipBoundingBox().maxY + 1);
            }
        };


        public abstract boolean computeValue(ShipLauncher var1);
    }
}

