/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.blocks.Envelopes;
import cuchaz.modsShared.math.BoxCorner;
import cuchaz.modsShared.math.RotatedBB;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class ShipGeometry {
    private BlockSet m_blocks;
    private Envelopes m_envelopes;

    public ShipGeometry(BlockSet blocks) {
        this.m_blocks = blocks;
        this.m_envelopes = new Envelopes(this.m_blocks);
    }

    public BlockSet getBlocks() {
        return this.m_blocks;
    }

    public Envelopes getEnvelopes() {
        return this.m_envelopes;
    }

    public BlockSet rangeQuery(RotatedBB box) {
        int minY = MathHelper.func_76128_c((double)box.getMinY());
        int maxY = MathHelper.func_76128_c((double)box.getMaxY());
        BlockSet blocks = new BlockSet();
        for (int y = minY; y <= maxY; ++y) {
            blocks.addAll(this.xzRangeQuery(y, box));
        }
        return blocks;
    }

    public BlockSet xzRangeQuery(int y, RotatedBB box) {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BoxCorner corner : BlockSide.Top.getCorners()) {
            box.getCorner(p, corner);
            int x = MathHelper.func_76128_c((double)p.field_72450_a);
            int z = MathHelper.func_76128_c((double)p.field_72449_c);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
            minZ = Math.min(minZ, z);
            maxZ = Math.max(maxZ, z);
        }
        Coords coords = new Coords();
        BlockSet blocks = new BlockSet();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                coords.set(x, y, z);
                if (this.m_blocks.contains(coords) || !this.blockIntersectsBoxXZ(x, z, box)) continue;
                blocks.add(new Coords(coords));
            }
        }
        return blocks;
    }

    public BlockSet rangeQuery(AxisAlignedBB box) {
        int minY = MathHelper.func_76128_c((double)box.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)box.field_72337_e);
        BlockSet blocks = new BlockSet();
        for (int y = minY; y <= maxY; ++y) {
            blocks.addAll(this.rangeQuery(box, y));
        }
        return blocks;
    }

    public BlockSet rangeQuery(AxisAlignedBB box, int y) {
        int minX = MathHelper.func_76128_c((double)box.field_72340_a);
        int minZ = MathHelper.func_76128_c((double)box.field_72339_c);
        int maxX = MathHelper.func_76128_c((double)box.field_72336_d);
        int maxZ = MathHelper.func_76128_c((double)box.field_72334_f);
        Coords coords = new Coords();
        BlockSet blocks = new BlockSet();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                coords.set(x, y, z);
                if (!this.m_blocks.contains(coords)) continue;
                blocks.add(new Coords(coords));
            }
        }
        return blocks;
    }

    private boolean blockIntersectsBoxXZ(int x, int z, RotatedBB box) {
        double y = (box.getMinY() + box.getMaxY()) / 2.0;
        return box.containsPoint(x + 0, y, z + 0) || box.containsPoint(x + 0, y, z + 1) || box.containsPoint(x + 1, y, z + 0) || box.containsPoint(x + 1, y, z + 1) || this.anyCornerIsInBlockXZ(box, x, z);
    }

    private boolean anyCornerIsInBlockXZ(RotatedBB box, int x, int z) {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (BoxCorner corner : BlockSide.Top.getCorners()) {
            box.getCorner(p, corner);
            if (!this.isPointInBlockXZ(p.field_72450_a, p.field_72449_c, x, z)) continue;
            return true;
        }
        return false;
    }

    private boolean isPointInBlockXZ(double px, double pz, int blockX, int blockZ) {
        return px >= (double)blockX && px <= (double)(blockX + 1) && pz >= (double)blockZ && pz <= (double)(blockZ + 1);
    }
}

