/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSetHeightIndex;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.util.MathHelper;

public class ShipDisplacement {
    public static final BlockUtils.Neighbors BoundaryNeighbors = BlockUtils.Neighbors.Edges;
    public static final BlockUtils.Neighbors VoidBlockNeighbors = BlockUtils.Neighbors.Faces;
    private static final DisplacementEntry EmptyEntry = new DisplacementEntry();
    private BlockSet m_blocks;
    private List<BlockSet> m_outerBoundaries;
    private List<BlockSet> m_holes;
    private TreeMap<Integer, DisplacementEntry> m_displacement;

    public ShipDisplacement(BlockSet blocks) {
        this.m_blocks = blocks;
        this.m_outerBoundaries = new ArrayList<BlockSet>();
        this.m_holes = null;
        this.computeBoundaryAndHoles();
        this.computeDisplacement();
    }

    public BlockSet getBlocks() {
        return this.m_blocks;
    }

    public List<BlockSet> getOuterBoundaries() {
        return this.m_outerBoundaries;
    }

    public List<BlockSet> getHoles() {
        return this.m_holes;
    }

    public int getMinY() {
        return this.m_blocks.getBoundingBox().minY;
    }

    public int getMaxY() {
        return this.m_blocks.getBoundingBox().maxY;
    }

    public BlockSet getTrappedAir(int y) {
        return this.get((int)y).trappedAir;
    }

    public BlockSet getTrappedAirFromWaterHeight(int waterHeightInBlockSpace) {
        return this.getTrappedAir(waterHeightInBlockSpace - 1);
    }

    public BlockSet getTrappedAirFromWaterHeight(double waterHeightInBlockSpace) {
        return this.getTrappedAir(MathHelper.func_76128_c((double)waterHeightInBlockSpace));
    }

    public BlockSet getSurfaceBlocks(int y) {
        return this.get((int)y).surfaceBlocks;
    }

    public BlockSet getUnderwaterBlocks(int y) {
        return this.get((int)y).underwaterBlocks;
    }

    public int getNumFillableBlocks(int y) {
        return this.get((int)y).numFillableBlocks;
    }

    public Integer getLastFillY() {
        for (Map.Entry entry : this.m_displacement.descendingMap().entrySet()) {
            if (((DisplacementEntry)entry.getValue()).numFillableBlocks <= 0) continue;
            return (Integer)entry.getKey() + 1;
        }
        return null;
    }

    private DisplacementEntry get(int y) {
        if (this.m_displacement.isEmpty()) {
            return EmptyEntry;
        }
        DisplacementEntry entry = this.m_displacement.get(y = Math.min(y, this.m_displacement.lastKey()));
        if (entry == null) {
            entry = EmptyEntry;
        }
        return entry;
    }

    private void computeBoundaryAndHoles() {
        BlockSet boundaryBlocks = BlockUtils.getBoundary(this.m_blocks, BoundaryNeighbors);
        this.m_holes = new ArrayList<BlockSet>();
        for (BlockSet component : BlockUtils.getConnectedComponents(boundaryBlocks, VoidBlockNeighbors)) {
            if (BlockUtils.isConnectedToShell((Coords)component.iterator().next(), this.m_blocks, VoidBlockNeighbors)) {
                this.m_outerBoundaries.add(component);
                continue;
            }
            this.m_holes.add(BlockUtils.getHoleFromInnerBoundary(component, this.m_blocks, VoidBlockNeighbors));
        }
    }

    private void computeDisplacement() {
        int minY = this.getMinY();
        int maxY = this.getMaxY();
        this.m_displacement = new TreeMap();
        BlockSetHeightIndex shipIndex = new BlockSetHeightIndex(this.m_blocks);
        for (int y = minY; y <= maxY + 1; ++y) {
            DisplacementEntry entry = new DisplacementEntry();
            this.m_displacement.put(y, entry);
            BlockSet yBlocks = shipIndex.get(y);
            if (yBlocks != null) {
                entry.surfaceBlocks.addAll(yBlocks);
            }
            if (y <= minY) continue;
            DisplacementEntry lowerEntry = this.m_displacement.get(y - 1);
            entry.underwaterBlocks.addAll(lowerEntry.surfaceBlocks);
            entry.underwaterBlocks.addAll(lowerEntry.underwaterBlocks);
        }
        BlockSetHeightIndex boundaryIndex = new BlockSetHeightIndex();
        for (BlockSet blocks : this.m_outerBoundaries) {
            boundaryIndex.add(blocks);
        }
        ArrayList<ClassifiedSegment> boundarySegments = new ArrayList<ClassifiedSegment>();
        for (int y = minY; y <= maxY + 1; ++y) {
            BlockSet blocksAtY = boundaryIndex.get(y);
            if (blocksAtY != null) {
                List<BlockSet> ySegments = BlockUtils.getConnectedComponents(blocksAtY, VoidBlockNeighbors);
                int numFilledBlocks = 0;
                for (BlockSet ySegment : ySegments) {
                    List<ClassifiedSegment> connectedSegments = this.getYConnectedSegments(ySegment, boundarySegments, VoidBlockNeighbors);
                    if (connectedSegments.isEmpty()) {
                        ClassifiedSegment classifiedSegment = new ClassifiedSegment();
                        classifiedSegment.segment = ySegment;
                        classifiedSegment.isTrapped = !BlockUtils.isConnectedToShell((Coords)ySegment.iterator().next(), this.m_blocks, VoidBlockNeighbors, y);
                        classifiedSegment.surfaceBlocks = new BlockSet(ySegment);
                        classifiedSegment.underwaterBlocks = new BlockSet();
                        boundarySegments.add(classifiedSegment);
                        continue;
                    }
                    int numPossiblyFilledBlocks = 0;
                    for (ClassifiedSegment segment : connectedSegments) {
                        if (!segment.isTrapped) continue;
                        numPossiblyFilledBlocks += segment.segment.size();
                    }
                    ClassifiedSegment baseSegment = connectedSegments.get(0);
                    if (baseSegment.isTrapped) {
                        ySegment.addAll(BlockUtils.getHoleFromInnerBoundary(ySegment, this.m_blocks, VoidBlockNeighbors, y, y));
                    }
                    baseSegment.segment.addAll(ySegment);
                    baseSegment.underwaterBlocks.addAll(baseSegment.surfaceBlocks);
                    baseSegment.surfaceBlocks.clear();
                    baseSegment.surfaceBlocks.addAll(ySegment);
                    for (int i = 1; i < connectedSegments.size(); ++i) {
                        ClassifiedSegment nextSegment = connectedSegments.get(i);
                        baseSegment.isTrapped = baseSegment.isTrapped && nextSegment.isTrapped;
                        baseSegment.segment.addAll(nextSegment.segment);
                        baseSegment.underwaterBlocks.addAll(nextSegment.surfaceBlocks);
                        baseSegment.underwaterBlocks.addAll(nextSegment.underwaterBlocks);
                        boundarySegments.remove(nextSegment);
                    }
                    if (baseSegment.isTrapped) continue;
                    numFilledBlocks += numPossiblyFilledBlocks;
                }
                if (numFilledBlocks > 0) {
                    this.m_displacement.get((Object)Integer.valueOf((int)(y - 1))).numFillableBlocks = numFilledBlocks;
                }
            }
            DisplacementEntry entry = this.m_displacement.get(y);
            for (ClassifiedSegment segment : boundarySegments) {
                if (!segment.isTrapped) continue;
                entry.trappedAir.addAll(segment.segment);
                entry.surfaceBlocks.addAll(segment.surfaceBlocks);
                entry.underwaterBlocks.addAll(segment.underwaterBlocks);
            }
        }
        BlockSetHeightIndex holeIndex = new BlockSetHeightIndex();
        for (BlockSet hole : this.m_holes) {
            holeIndex.add(hole);
        }
        BlockSet holeBlocks = new BlockSet();
        BlockSet underwaterBlocks = new BlockSet();
        for (int y = minY; y <= maxY + 1; ++y) {
            DisplacementEntry entry = this.m_displacement.get(y);
            BlockSet layer = holeIndex.get(y);
            if (layer != null) {
                holeBlocks.addAll(layer);
                entry.surfaceBlocks.addAll(layer);
            }
            entry.underwaterBlocks.addAll(underwaterBlocks);
            entry.trappedAir.addAll(holeBlocks);
            if (layer == null) continue;
            underwaterBlocks.addAll(layer);
        }
    }

    private List<ClassifiedSegment> getYConnectedSegments(BlockSet ySegment, Iterable<ClassifiedSegment> segments, BlockUtils.Neighbors neighbors) {
        ArrayList<ClassifiedSegment> connectedSegments = new ArrayList<ClassifiedSegment>();
        for (ClassifiedSegment segment : segments) {
            if (!this.isYConnected(segment.segment, ySegment, neighbors)) continue;
            connectedSegments.add(segment);
        }
        return connectedSegments;
    }

    private boolean isYConnected(BlockSet below, BlockSet at, BlockUtils.Neighbors neighbors) {
        Coords neighborCoords = new Coords(0, 0, 0);
        for (Coords coords : at) {
            for (int i = 0; i < neighbors.getNumNeighbors(); ++i) {
                neighbors.getNeighbor(neighborCoords, coords, i);
                if (neighborCoords.y != coords.y - 1 || !below.contains(neighborCoords)) continue;
                return true;
            }
        }
        return false;
    }

    private static class DisplacementEntry {
        public int numFillableBlocks = 0;
        public BlockSet trappedAir = new BlockSet();
        public BlockSet surfaceBlocks = new BlockSet();
        public BlockSet underwaterBlocks = new BlockSet();
    }

    private static class ClassifiedSegment {
        BlockSet segment;
        BlockSet surfaceBlocks;
        BlockSet underwaterBlocks;
        boolean isTrapped;

        private ClassifiedSegment() {
        }
    }
}

