/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.math.BoxCorner;
import cuchaz.modsShared.math.RotatedBB;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.render.ShipDebugRenderInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAccessor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ShipCollider {
    private EntityShip m_ship;
    @SideOnly(value=Side.CLIENT)
    private ShipDebugRenderInfo m_debugRenderInfo;

    public ShipCollider(EntityShip ship) {
        this.m_ship = ship;
        if (Environment.isClient()) {
            this.m_debugRenderInfo = new ShipDebugRenderInfo();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ShipDebugRenderInfo getDebugRenderInfo() {
        return this.m_debugRenderInfo;
    }

    public void computeShipBoundingBox(AxisAlignedBB box, double x, double y, double z, float yaw) {
        ShipWorld blocks = this.m_ship.getShipWorld();
        if (blocks == null) {
            return;
        }
        box.field_72340_a = x + this.m_ship.blocksToShipX(blocks.getBoundingBox().minX);
        box.field_72338_b = y + this.m_ship.blocksToShipY(blocks.getBoundingBox().minY);
        box.field_72339_c = z + this.m_ship.blocksToShipZ(blocks.getBoundingBox().minZ);
        box.field_72336_d = x + this.m_ship.blocksToShipX(blocks.getBoundingBox().maxX + 1);
        box.field_72337_e = y + this.m_ship.blocksToShipY(blocks.getBoundingBox().maxY + 1);
        box.field_72334_f = z + this.m_ship.blocksToShipZ(blocks.getBoundingBox().maxZ + 1);
        RotatedBB rotatedBox = new RotatedBB(box.func_72329_c(), yaw, x, z);
        box.field_72340_a = 2.147483647E9;
        box.field_72336_d = -2.147483648E9;
        box.field_72339_c = 2.147483647E9;
        box.field_72334_f = -2.147483648E9;
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (BoxCorner corner : BlockSide.Top.getCorners()) {
            rotatedBox.getCorner(p, corner);
            box.field_72340_a = Math.min(box.field_72340_a, p.field_72450_a);
            box.field_72336_d = Math.max(box.field_72336_d, p.field_72450_a);
            box.field_72339_c = Math.min(box.field_72339_c, p.field_72449_c);
            box.field_72334_f = Math.max(box.field_72334_f, p.field_72449_c);
        }
    }

    public void onNearbyEntityMoved(double oldX, double oldY, double oldZ, double oldYSize, Entity entity) {
        boolean isPlayerCrouching;
        if (entity.field_70145_X) {
            return;
        }
        if (entity instanceof EntityShip) {
            return;
        }
        AxisAlignedBB oldEntityBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(oldEntityBox, entity, Vec3.func_72443_a((double)oldX, (double)oldY, (double)oldZ));
        double Epsilon = 0.1;
        double distToNextTop = (double)MathHelper.func_76143_f((double)oldEntityBox.field_72338_b) - oldEntityBox.field_72338_b;
        if (distToNextTop <= 0.1) {
            oldEntityBox.field_72338_b += distToNextTop;
            oldEntityBox.field_72337_e += distToNextTop;
        }
        AxisAlignedBB newEntityBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(newEntityBox, entity);
        double dYSize = (double)entity.field_70139_V - oldYSize;
        oldEntityBox.field_72337_e -= dYSize;
        oldEntityBox.field_72338_b -= dYSize;
        if (Environment.isClient() && ShipDebugRenderInfo.isDebugRenderingOn() && entity instanceof EntityLivingBase) {
            this.m_debugRenderInfo.setQueryBox(entity, oldEntityBox);
        }
        double originalDx = newEntityBox.field_72340_a - oldEntityBox.field_72340_a;
        double originalDy = newEntityBox.field_72338_b - oldEntityBox.field_72338_b;
        double originalDz = newEntityBox.field_72339_c - oldEntityBox.field_72339_c;
        double dx = originalDx;
        double dy = originalDy;
        double dz = originalDz;
        boolean bl = isPlayerCrouching = entity.field_70122_E && entity.func_70093_af() && entity instanceof EntityPlayer;
        if (isPlayerCrouching) {
            double BufferSize = 0.05;
            double bufferX = dx > 0.0 ? 0.05 : -0.05;
            double bufferZ = dz > 0.0 ? 0.05 : -0.05;
            double StepSize = 0.05;
            while (dx != 0.0 && this.m_ship.getShipWorld().getGeometry().rangeQuery(oldEntityBox.func_72325_c(dx + bufferX, -1.0, 0.0)).isEmpty()) {
                dx = this.stepTowardsZero(dx, 0.05);
            }
            while (dz != 0.0 && this.m_ship.getShipWorld().getGeometry().rangeQuery(oldEntityBox.func_72325_c(0.0, -1.0, dz + bufferZ)).isEmpty()) {
                dz = this.stepTowardsZero(dz, 0.05);
            }
            while (dx != 0.0 && dz != 0.0 && this.m_ship.getShipWorld().getGeometry().rangeQuery(oldEntityBox.func_72325_c(dx + bufferX, -1.0, dz + bufferZ)).isEmpty()) {
                dx = this.stepTowardsZero(dx, 0.05);
                dz = this.stepTowardsZero(dz, 0.05);
            }
            newEntityBox.field_72340_a = oldEntityBox.field_72340_a + dx;
            newEntityBox.field_72336_d = oldEntityBox.field_72336_d + dx;
            newEntityBox.field_72339_c = oldEntityBox.field_72339_c + dz;
            newEntityBox.field_72334_f = oldEntityBox.field_72334_f + dz;
        }
        List<PossibleCollision> possibleCollisions = this.trajectoryQuery(oldEntityBox, newEntityBox);
        if (Environment.isClient() && ShipDebugRenderInfo.isDebugRenderingOn() && entity instanceof EntityLivingBase) {
            for (PossibleCollision collision : possibleCollisions) {
                this.m_debugRenderInfo.addCollidedCoord(collision.coords);
            }
        }
        if (possibleCollisions.isEmpty()) {
            return;
        }
        for (PossibleCollision collision : possibleCollisions) {
            dy = collision.box.func_72323_b(oldEntityBox, dy);
        }
        dy = this.applyBackoff(dy, originalDy);
        oldEntityBox.func_72317_d(0.0, dy, 0.0);
        for (PossibleCollision collision : possibleCollisions) {
            dx = collision.box.func_72316_a(oldEntityBox, dx);
        }
        dx = this.applyBackoff(dx, originalDx);
        oldEntityBox.func_72317_d(dx, 0.0, 0.0);
        for (PossibleCollision collision : possibleCollisions) {
            dz = collision.box.func_72322_c(oldEntityBox, dz);
        }
        dz = this.applyBackoff(dz, originalDz);
        oldEntityBox.func_72317_d(0.0, 0.0, dz);
        if (entity.field_70138_W > 0.0f && (originalDx != dx || originalDz != dz) && originalDy != dy) {
            double EpsilonStairs = 1.0E-6;
            newEntityBox.field_72338_b = oldEntityBox.field_72338_b + (double)entity.field_70138_W + 1.0E-6;
            newEntityBox.field_72337_e = oldEntityBox.field_72337_e + (double)entity.field_70138_W + 1.0E-6;
            possibleCollisions = this.trajectoryQuery(oldEntityBox, newEntityBox);
            double originalStairsDx = newEntityBox.field_72340_a - oldEntityBox.field_72340_a;
            double originalStairsDy = newEntityBox.field_72338_b - oldEntityBox.field_72338_b;
            double originalStairsDz = newEntityBox.field_72339_c - oldEntityBox.field_72339_c;
            double stairsDx = originalStairsDx;
            double stairsDy = originalStairsDy;
            double stairsDz = originalStairsDz;
            AxisAlignedBB tempBox = oldEntityBox.func_72329_c();
            if (!possibleCollisions.isEmpty()) {
                for (PossibleCollision collision : possibleCollisions) {
                    stairsDy = collision.box.func_72323_b(tempBox, stairsDy);
                }
                stairsDy = this.applyBackoff(stairsDy, originalDy);
                tempBox.func_72317_d(0.0, stairsDy, 0.0);
                for (PossibleCollision collision : possibleCollisions) {
                    stairsDx = collision.box.func_72316_a(tempBox, stairsDx);
                }
                stairsDx = this.applyBackoff(stairsDx, originalDx);
                tempBox.func_72317_d(stairsDx, 0.0, 0.0);
                for (PossibleCollision collision : possibleCollisions) {
                    stairsDz = collision.box.func_72322_c(tempBox, stairsDz);
                }
                stairsDz = this.applyBackoff(stairsDz, originalDz);
                tempBox.func_72317_d(0.0, 0.0, stairsDz);
            } else {
                tempBox.func_72317_d(stairsDx, stairsDy, stairsDz);
            }
            if (Math.abs(stairsDx) > 1.0E-6 || Math.abs(stairsDz) > 1.0E-6) {
                dx += stairsDx;
                dy += stairsDy;
                dz += stairsDz;
                oldEntityBox.func_72328_c(tempBox);
            }
        }
        Vec3 newPos = Vec3.func_72443_a((double)((oldEntityBox.field_72340_a + oldEntityBox.field_72336_d) / 2.0), (double)oldEntityBox.field_72338_b, (double)((oldEntityBox.field_72339_c + oldEntityBox.field_72334_f) / 2.0));
        this.m_ship.blocksToShip(newPos);
        this.m_ship.shipToWorld(newPos);
        entity.func_70107_b(newPos.field_72450_a, newPos.field_72448_b + (double)entity.field_70129_M - (double)entity.field_70139_V, newPos.field_72449_c);
        entity.field_70123_F = originalDx != dx || originalDz != dz;
        entity.field_70124_G = originalDy != dy;
        entity.field_70122_E = entity.field_70124_G && originalDy < 0.0;
        boolean bl2 = entity.field_70132_H = entity.field_70123_F || entity.field_70124_G;
        if (originalDx != dx) {
            entity.field_70159_w = 0.0;
        }
        if (originalDy != dy) {
            entity.field_70181_x = 0.0;
        }
        if (originalDz != dz) {
            entity.field_70179_y = 0.0;
        }
        EntityAccessor.updateFallState(entity, dy, entity.field_70122_E);
    }

    public AxisAlignedBB getBlockBoxInBlockSpace(Coords coords) {
        Block block = this.m_ship.getShipWorld().getBlock(coords);
        if (block == null) {
            block = Blocks.field_150348_b;
        }
        block.func_149719_a((IBlockAccess)this.m_ship.getShipWorld(), coords.x, coords.y, coords.z);
        return AxisAlignedBB.func_72330_a((double)(block.func_149704_x() + (double)coords.x), (double)(block.func_149665_z() + (double)coords.y), (double)(block.func_149706_B() + (double)coords.z), (double)(block.func_149753_y() + (double)coords.x), (double)(block.func_149669_A() + (double)coords.y), (double)(block.func_149693_C() + (double)coords.z));
    }

    public void getCollisionBoxesInBlockSpace(List<AxisAlignedBB> out, Coords coords, AxisAlignedBB box) {
        Block block = this.m_ship.getShipWorld().getBlock(coords);
        block.func_149743_a((World)this.m_ship.getShipWorld(), coords.x, coords.y, coords.z, box, out, null);
    }

    public RotatedBB getBlockBoxInWorldSpace(Coords coords) {
        return this.m_ship.blocksToWorld(this.getBlockBoxInBlockSpace(coords));
    }

    public AxisAlignedBB getBlockWorldBoundingBox(AxisAlignedBB box, Coords coords) {
        return this.getBlockBoundingBox(box, coords, null);
    }

    public AxisAlignedBB getBlockBoundingBox(AxisAlignedBB box, Coords coords, EntityShip ship) {
        Vec3 p = Vec3.func_72443_a((double)((double)coords.x + 0.5), (double)((double)coords.y + 0.5), (double)((double)coords.z + 0.5));
        this.m_ship.blocksToShip(p);
        this.m_ship.shipToWorld(p);
        if (ship != null) {
            ship.worldToShip(p);
            ship.shipToBlocks(p);
        }
        float yawRad = (float)Math.toRadians(this.m_ship.field_70177_z);
        if (ship != null) {
            yawRad -= (float)Math.toRadians(ship.field_70177_z);
        }
        double cos = MathHelper.func_76134_b((float)yawRad);
        double sin = MathHelper.func_76126_a((float)yawRad);
        double halfSize = Math.max(Math.abs(cos - sin), Math.abs(sin + cos)) / 2.0;
        return box.func_72324_b(p.field_72450_a - halfSize, p.field_72448_b - 0.5, p.field_72449_c - halfSize, p.field_72450_a + halfSize, p.field_72448_b + 0.5, p.field_72449_c + halfSize);
    }

    public AxisAlignedBB getBlockWorldBoundingBox(AxisAlignedBB box, Coords coords, double shipX, double shipY, double shipZ, float shipYaw) {
        return this.getBlockBoundingBox(box, coords, shipX, shipY, shipZ, shipYaw, null);
    }

    public AxisAlignedBB getBlockBoundingBox(AxisAlignedBB box, Coords coords, double shipX, double shipY, double shipZ, float shipYaw, EntityShip ship) {
        double oldX = this.m_ship.field_70165_t;
        double oldY = this.m_ship.field_70163_u;
        double oldZ = this.m_ship.field_70161_v;
        float oldYaw = this.m_ship.field_70177_z;
        this.m_ship.field_70165_t = shipX;
        this.m_ship.field_70163_u = shipY;
        this.m_ship.field_70161_v = shipZ;
        this.m_ship.field_70177_z = shipYaw;
        AxisAlignedBB blockWorldBox = this.getBlockBoundingBox(box, coords, ship);
        this.m_ship.field_70165_t = oldX;
        this.m_ship.field_70163_u = oldY;
        this.m_ship.field_70161_v = oldZ;
        this.m_ship.field_70177_z = oldYaw;
        return blockWorldBox;
    }

    public void moveShip(double dx, double dy, double dz, float dYaw) {
        double scaling = 1.0;
        int numCollidingBoxes = 0;
        CollisionResult collisionResult = new CollisionResult();
        for (Coords coords : this.m_ship.getShipWorld().coords()) {
            this.checkBlockCollision(collisionResult, coords, dx, dy, dz, dYaw);
            if (!(collisionResult.scaling < 1.0)) continue;
            scaling = Math.min(scaling, collisionResult.scaling);
            numCollidingBoxes += collisionResult.numCollidingBoxes;
        }
        AxisAlignedBB nextShipBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.computeShipBoundingBox(nextShipBox, this.m_ship.field_70165_t + dx, this.m_ship.field_70163_u + dy, this.m_ship.field_70161_v + dz, this.m_ship.field_70177_z + dYaw);
        AxisAlignedBB queryBox = this.m_ship.field_70121_D.func_111270_a(nextShipBox);
        List ships = this.m_ship.field_70170_p.func_72872_a(EntityShip.class, queryBox);
        for (EntityShip ship : ships) {
            if (ship == this.m_ship) continue;
            for (Coords coords : this.m_ship.getShipWorld().coords()) {
                this.checkShipCollision(collisionResult, coords, dx, dy, dz, dYaw, ship);
                if (!(collisionResult.scaling < 1.0)) continue;
                scaling = Math.min(scaling, collisionResult.scaling);
                numCollidingBoxes += collisionResult.numCollidingBoxes;
            }
        }
        dx *= scaling;
        dy *= scaling;
        dz *= scaling;
        if (numCollidingBoxes > 0) {
            dYaw = 0.0f;
        }
        this.m_ship.field_70177_z += dYaw;
        this.m_ship.func_70107_b(this.m_ship.field_70165_t + dx, this.m_ship.field_70163_u + dy, this.m_ship.field_70161_v + dz);
        List entities = this.m_ship.field_70170_p.func_72872_a(Entity.class, this.m_ship.field_70121_D);
        for (Entity entity : entities) {
            if (entity instanceof EntityShip) {
                return;
            }
            double srcX = entity.field_70165_t + dx;
            double srcY = entity.field_70163_u + dy;
            double srcZ = entity.field_70161_v + dz;
            double srcYSize = entity.field_70139_V;
            this.onNearbyEntityMoved(srcX, srcY, srcZ, srcYSize, entity);
        }
    }

    public List<Entity> getRiders() {
        AxisAlignedBB checkBox = this.m_ship.field_70121_D.func_72314_b(1.0, 1.0, 1.0);
        List entities = this.m_ship.field_70170_p.func_72872_a(Entity.class, checkBox);
        Iterator iter = entities.iterator();
        while (iter.hasNext()) {
            Entity entity = (Entity)iter.next();
            if (!(entity instanceof EntityShip) && this.isEntityAboard(entity)) continue;
            iter.remove();
        }
        return entities;
    }

    public boolean isEntityAboard(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            return this.isEntityStandingOnBlock(entity) || this.isEntityOnLadder((EntityLivingBase)entity);
        }
        return this.isEntityStandingOnBlock(entity);
    }

    public boolean isEntityStandingOnBlock(Entity entity) {
        AxisAlignedBB checkBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(checkBox, entity);
        checkBox.field_72337_e = checkBox.field_72338_b;
        checkBox.field_72338_b -= 0.1;
        ArrayList<AxisAlignedBB> nearbyBoxes = new ArrayList<AxisAlignedBB>();
        for (Coords coords : this.m_ship.getShipWorld().getGeometry().rangeQuery(checkBox.func_72314_b(0.0, 1.0, 0.0))) {
            this.getCollisionBoxesInBlockSpace(nearbyBoxes, coords, checkBox);
        }
        return !nearbyBoxes.isEmpty();
    }

    public boolean isEntityOnLadder(EntityLivingBase entity) {
        ShipWorld shipWorld = this.m_ship.getShipWorld();
        AxisAlignedBB entityBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getEntityBoxInBlockSpace(entityBox, (Entity)entity);
        for (Coords coords : shipWorld.getGeometry().rangeQuery(entityBox)) {
            Block block = shipWorld.getBlock(coords);
            if (block == Blocks.field_150350_a || !block.isLadder((IBlockAccess)shipWorld, coords.x, coords.y, coords.z, entity)) continue;
            return true;
        }
        return false;
    }

    public boolean isColliding(AxisAlignedBB box) {
        for (Coords coords : this.m_ship.getShipWorld().coords()) {
            AxisAlignedBB shipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            this.getBlockWorldBoundingBox(shipBlockBox, coords);
            if (!shipBlockBox.func_72326_a(box)) continue;
            return true;
        }
        return false;
    }

    public List<MovingObjectPosition> lineSegmentQuery(Vec3 from, Vec3 to) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)Math.min(from.field_72450_a, to.field_72450_a), (double)Math.min(from.field_72448_b, to.field_72448_b), (double)Math.min(from.field_72449_c, to.field_72449_c), (double)Math.max(from.field_72450_a, to.field_72450_a), (double)Math.max(from.field_72448_b, to.field_72448_b), (double)Math.max(from.field_72449_c, to.field_72449_c));
        BlockSet nearbyBlocks = this.m_ship.getShipWorld().getGeometry().rangeQuery(box);
        ArrayList<MovingObjectPosition> intersections = new ArrayList<MovingObjectPosition>();
        for (Coords coords : nearbyBlocks) {
            Block block = this.m_ship.getShipWorld().getBlock(coords);
            MovingObjectPosition intersection = block.func_149731_a((World)this.m_ship.getShipWorld(), coords.x, coords.y, coords.z, from, to);
            if (intersection == null) continue;
            intersections.add(intersection);
        }
        return intersections;
    }

    public double getDistanceSqToEntity(Entity entity) {
        Vec3 p = Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        this.m_ship.worldToShip(p);
        this.m_ship.shipToBlocks(p);
        double minDistSq = Double.POSITIVE_INFINITY;
        for (Coords coords : this.m_ship.getShipWorld().coords()) {
            double dx = (double)coords.x - p.field_72450_a;
            double dy = (double)coords.y - p.field_72448_b;
            double dz = (double)coords.z - p.field_72449_c;
            double dist = dx * dx + dy * dy + dz * dz;
            minDistSq = Math.min(minDistSq, dist);
        }
        return Math.sqrt(minDistSq);
    }

    public void getIntersectingWorldBlocks(BlockSet worldBlocks, BlockSet shipBlocks) {
        this.getIntersectingWorldBlocks(worldBlocks, shipBlocks, 0.0, false);
    }

    public void getIntersectingWorldBlocks(BlockSet worldBlocks, BlockSet shipBlocks, double epsilon, boolean includeAir) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        for (Coords coords : shipBlocks) {
            this.getBlockWorldBoundingBox(box, coords);
            box = box.func_72314_b(epsilon, epsilon, epsilon);
            BlockUtils.worldRangeQuery(worldBlocks, this.m_ship.field_70170_p, box, includeAir);
        }
    }

    private void checkBlockCollision(CollisionResult result, Coords coords, double dx, double dy, double dz, float dYaw) {
        AxisAlignedBB shipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getBlockWorldBoundingBox(shipBlockBox, coords);
        double nextX = this.m_ship.field_70165_t + dx;
        double nextY = this.m_ship.field_70163_u + dy;
        double nextZ = this.m_ship.field_70161_v + dz;
        float nextYaw = this.m_ship.field_70177_z + dYaw;
        AxisAlignedBB nextShipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getBlockWorldBoundingBox(nextShipBlockBox, coords, nextX, nextY, nextZ, nextYaw);
        AxisAlignedBB combinedBlockBox = shipBlockBox.func_111270_a(nextShipBlockBox);
        BlockSet nearbyWorldBlocks = new BlockSet();
        BlockUtils.worldRangeQuery(nearbyWorldBlocks, this.m_ship.field_70170_p, combinedBlockBox);
        result.scaling = 1.0;
        ArrayList worldBlockBoxes = new ArrayList();
        for (Coords worldCoords : nearbyWorldBlocks) {
            Block worldBlock = this.m_ship.field_70170_p.func_147439_a(worldCoords.x, worldCoords.y, worldCoords.z);
            worldBlockBoxes.clear();
            worldBlock.func_149743_a(this.m_ship.field_70170_p, worldCoords.x, worldCoords.y, worldCoords.z, combinedBlockBox, worldBlockBoxes, null);
            double blockScaling = 1.0;
            for (AxisAlignedBB worldBlockBox : worldBlockBoxes) {
                blockScaling = Math.min(blockScaling, this.getScalingToAvoidCollision(shipBlockBox, dx, dy, dz, worldBlockBox));
            }
            if (blockScaling < 1.0 && worldBlock instanceof BlockFlower) {
                this.m_ship.field_70170_p.func_147480_a(worldCoords.x, worldCoords.y, worldCoords.z, false);
                continue;
            }
            result.scaling = Math.min(result.scaling, blockScaling);
        }
        result.numCollidingBoxes = nearbyWorldBlocks.size();
    }

    private void checkShipCollision(CollisionResult result, Coords coords, double dx, double dy, double dz, float dYaw, EntityShip ship) {
        AxisAlignedBB shipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getBlockBoundingBox(shipBlockBox, coords, ship);
        double nextX = this.m_ship.field_70165_t + dx;
        double nextY = this.m_ship.field_70163_u + dy;
        double nextZ = this.m_ship.field_70161_v + dz;
        float nextYaw = this.m_ship.field_70177_z + dYaw;
        AxisAlignedBB nextShipBlockBox = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        this.getBlockBoundingBox(nextShipBlockBox, coords, nextX, nextY, nextZ, nextYaw, ship);
        List<PossibleCollision> possibleCollisions = this.trajectoryQuery(shipBlockBox, nextShipBlockBox);
        result.scaling = 1.0;
        result.numCollidingBoxes = 0;
        for (PossibleCollision possibleCollision : possibleCollisions) {
            double scaling = this.getScalingToAvoidCollision(shipBlockBox, dx, dy, dz, possibleCollision.box);
            result.scaling = Math.min(result.scaling, scaling);
            if (!(scaling < 1.0)) continue;
            ++result.numCollidingBoxes;
        }
    }

    private double getScalingToAvoidCollision(AxisAlignedBB box, double dx, double dy, double dz, AxisAlignedBB obstacleBox) {
        double sx = this.getScalingToAvoidCollision(dx, box.field_72340_a, box.field_72336_d, obstacleBox.field_72340_a, obstacleBox.field_72336_d);
        double sy = this.getScalingToAvoidCollision(dy, box.field_72338_b, box.field_72337_e, obstacleBox.field_72338_b, obstacleBox.field_72337_e);
        double sz = this.getScalingToAvoidCollision(dz, box.field_72339_c, box.field_72334_f, obstacleBox.field_72339_c, obstacleBox.field_72334_f);
        return Math.min(sx, Math.min(sy, sz));
    }

    private double getScalingToAvoidCollision(double delta, double selfMin, double selfMax, double obstacleMin, double obstacleMax) {
        double dist;
        double scaling = 1.0;
        if (delta > 0.0) {
            double dist2 = obstacleMin - selfMax;
            if (dist2 >= 0.0) {
                return dist2 / delta;
            }
        } else if (delta < 0.0 && (dist = selfMin - obstacleMax) >= 0.0) {
            return dist / -delta;
        }
        assert (scaling >= 0.0);
        return scaling;
    }

    private double applyBackoff(double d, double originalD) {
        double Backoff = 0.001;
        if (d != 0.0 && d != originalD) {
            if (d > 0.0) {
                return d - 0.001;
            }
            return d + 0.001;
        }
        return d;
    }

    private List<PossibleCollision> trajectoryQuery(AxisAlignedBB oldBox, AxisAlignedBB newBox) {
        AxisAlignedBB trajectoryBox = oldBox.func_111270_a(newBox);
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        ArrayList<PossibleCollision> collisions = new ArrayList<PossibleCollision>();
        if (this.m_ship != null && this.m_ship.getShipWorld() != null && this.m_ship.getShipWorld().getGeometry() != null) {
            for (Coords coords : this.m_ship.getShipWorld().getGeometry().rangeQuery(trajectoryBox.func_72314_b(1.0, 1.0, 1.0))) {
                boxes.clear();
                this.getCollisionBoxesInBlockSpace(boxes, coords, trajectoryBox);
                for (AxisAlignedBB box : boxes) {
                    collisions.add(new PossibleCollision(coords, box));
                }
            }
        }
        return collisions;
    }

    private void getEntityBoxInBlockSpace(AxisAlignedBB box, Entity entity) {
        this.getEntityBoxInBlockSpace(box, entity, Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v));
    }

    private void getEntityBoxInBlockSpace(AxisAlignedBB box, Entity entity, Vec3 pos) {
        pos = Vec3.func_72443_a((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c);
        this.m_ship.worldToShip(pos);
        this.m_ship.shipToBlocks(pos);
        box.func_72328_c(entity.field_70121_D);
        box.func_72317_d(-entity.field_70165_t, -entity.field_70163_u, -entity.field_70161_v);
        box.func_72317_d(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    private double stepTowardsZero(double val, double epsilon) {
        val = val < epsilon && val >= -epsilon ? 0.0 : (val > 0.0 ? (val -= epsilon) : (val += epsilon));
        return val;
    }

    private static class CollisionResult {
        public double scaling;
        public int numCollidingBoxes;

        private CollisionResult() {
        }
    }

    private static class PossibleCollision {
        public Coords coords;
        public AxisAlignedBB box;

        public PossibleCollision(Coords coords, AxisAlignedBB box) {
            this.coords = coords;
            this.box = box;
        }
    }
}

