/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlockStorage;
import cuchaz.ships.BlocksStorage;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.persistence.BlockStoragePersistence;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.ShipWorldPersistence;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityHanging;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ShipClipboard {
    public static void saveShipWorld(ShipWorld shipWorld) {
        StringSelection selection = new StringSelection(ShipWorldPersistence.writeNewestVersionToString(shipWorld));
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(selection, selection);
    }

    public static String getBlocks() {
        try {
            String encodedBlocks = null;
            long startTime = System.currentTimeMillis();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                encodedBlocks = (String)clipboard.getData(DataFlavor.stringFlavor);
            }
            Ships.logger.info("Clipboard access took %.2f s", Float.valueOf((float)(System.currentTimeMillis() - startTime) / 1000.0f));
            return encodedBlocks;
        }
        catch (UnsupportedFlavorException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static ShipWorld createShipWorld(World world, String encodedBlocks) throws PersistenceException {
        try {
            return ShipWorldPersistence.readAnyVersion(world, encodedBlocks);
        }
        catch (PersistenceException shipWorldException) {
            try {
                BlocksStorage storage = BlockStoragePersistence.readAnyVersion(encodedBlocks);
                return new ShipWorld(world, storage, new BlockMap<TileEntity>(), new BlockMap<EntityHanging>(), 0);
            }
            catch (PersistenceException blockStorageException) {
                throw shipWorldException;
            }
        }
    }

    public static void restoreShip(World world, String encodedBlocks, Coords translation) throws PersistenceException {
        ShipWorld shipWorld = ShipClipboard.createShipWorld(world, encodedBlocks);
        BlockMap<Coords> correspondence = new BlockMap<Coords>();
        for (Coords coords : shipWorld.coords()) {
            Coords worldCoords = new Coords(coords);
            worldCoords.x += translation.x;
            worldCoords.y += translation.y;
            worldCoords.z += translation.z;
            correspondence.put(coords, worldCoords);
        }
        boolean foundUnknownBlocks = false;
        for (Coords coords : shipWorld.coords()) {
            Block block = shipWorld.getBlock(coords);
            if (block != null) continue;
            foundUnknownBlocks = true;
            BlockStorage storage = shipWorld.getBlockStorage(coords);
            storage.block = Blocks.field_150344_f;
            storage.meta = 0;
        }
        if (foundUnknownBlocks) {
            Ships.logger.warning("Unknown blocks found in ship! They're probably mod blocks from an uninstalled mod. Replacing with wood planks.", new Object[0]);
        }
        shipWorld.restoreToWorld(world, correspondence, shipWorld.getBoundingBox().minY - 1);
    }
}

