/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.Util;
import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.blocks.BlockBerth;
import cuchaz.ships.gui.GuiString;
import cuchaz.ships.packets.PacketPlayerSleepInBerth;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAccessor;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerAccessor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class PlayerRespawner {
    private static Integer m_serverInstanceId = null;
    private static Map<Integer, BerthCoords> m_sleepingBerths = new TreeMap<Integer, BerthCoords>();
    private static Map<String, BerthCoords> m_playerSavedBerths = new TreeMap<String, BerthCoords>();

    private static Map<String, BerthCoords> getSavedBerths(WorldServer worldServer) {
        PlayerRespawner.checkServerInstance(worldServer);
        return m_playerSavedBerths;
    }

    private static void checkServerInstance(WorldServer worldServer) {
        int currentServerInstanceId = System.identityHashCode(worldServer.func_73046_m());
        if (m_serverInstanceId == null || m_serverInstanceId != currentServerInstanceId) {
            m_sleepingBerths.clear();
            m_playerSavedBerths.clear();
            PlayerRespawner.loadBerths();
        }
    }

    public static EntityPlayer.EnumStatus sleepInBerthAt(World world, int x, int y, int z, EntityPlayer player) {
        World realWorld = player.field_70170_p;
        Vec3 bedPos = Vec3.func_72443_a((double)x, (double)y, (double)z);
        if (world instanceof ShipWorld) {
            EntityShip ship = ((ShipWorld)world).getShip();
            ship.blocksToShip(bedPos);
            ship.shipToWorld(bedPos);
        }
        if (!realWorld.field_72995_K) {
            if (player.func_70608_bn() || !player.func_70089_S()) {
                return EntityPlayer.EnumStatus.OTHER_PROBLEM;
            }
            if (!realWorld.field_73011_w.func_76569_d()) {
                return EntityPlayer.EnumStatus.NOT_POSSIBLE_HERE;
            }
            if (realWorld.func_72935_r()) {
                return EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(player.field_70165_t - bedPos.field_72450_a) > 3.0 || Math.abs(player.field_70163_u - bedPos.field_72448_b) > 2.0 || Math.abs(player.field_70161_v - bedPos.field_72449_c) > 3.0) {
                return EntityPlayer.EnumStatus.TOO_FAR_AWAY;
            }
            int dXZ = 8;
            int dY = 5;
            List mobs = realWorld.func_72872_a(EntityMob.class, AxisAlignedBB.func_72330_a((double)(bedPos.field_72450_a - (double)dXZ), (double)(bedPos.field_72448_b - (double)dY), (double)(bedPos.field_72449_c - (double)dXZ), (double)(bedPos.field_72450_a + (double)dXZ), (double)(bedPos.field_72448_b + (double)dY), (double)(bedPos.field_72449_c + (double)dXZ)));
            if (!mobs.isEmpty()) {
                return EntityPlayer.EnumStatus.NOT_SAFE;
            }
        }
        if (player.func_70115_ae()) {
            player.func_70078_a(null);
        }
        EntityAccessor.setSize((Entity)player, 0.2f, 0.2f);
        player.field_70129_M = 0.2f;
        if (world.func_72899_e(x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            int direction = BlockBed.func_149895_l((int)meta);
            Block block = world.func_147439_a(x, y, z);
            if (block != Blocks.field_150350_a) {
                direction = block.getBedDirection((IBlockAccess)world, x, y, z);
            }
            float dx = 0.5f;
            float dz = 0.5f;
            switch (direction) {
                case 0: {
                    dz = 0.9f;
                    break;
                }
                case 1: {
                    dx = 0.1f;
                    break;
                }
                case 2: {
                    dz = 0.1f;
                    break;
                }
                case 3: {
                    dx = 0.9f;
                }
            }
            player.func_70107_b(bedPos.field_72450_a + (double)dx, bedPos.field_72448_b + 0.9375, bedPos.field_72449_c + (double)dz);
        } else {
            player.func_70107_b(bedPos.field_72450_a + 0.5, bedPos.field_72448_b + 0.9375, bedPos.field_72449_c + 0.5);
        }
        EntityPlayerAccessor.setSleeping(player, true);
        PlayerRespawner.setPlayerSleepTimer(player, 0);
        player.field_70159_w = 0.0;
        player.field_70179_y = 0.0;
        player.field_70181_x = 0.0;
        if (!realWorld.field_72995_K) {
            realWorld.func_72854_c();
            m_sleepingBerths.put(player.func_145782_y(), new BerthCoords(world, x, y, z));
            EntityPlayerMP playerServer = (EntityPlayerMP)player;
            PacketPlayerSleepInBerth packet = new PacketPlayerSleepInBerth(player, world, x, y, z);
            for (EntityPlayer trackingPlayer : playerServer.func_71121_q().func_73039_n().getTrackingPlayers((Entity)player)) {
                Ships.net.getDispatch().sendTo((IMessage)packet, (EntityPlayerMP)trackingPlayer);
            }
            playerServer.field_71135_a.func_147364_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70177_z, player.field_70125_A);
            Ships.net.getDispatch().sendTo((IMessage)packet, playerServer);
        }
        return EntityPlayer.EnumStatus.OK;
    }

    private static void setPlayerSleepTimer(EntityPlayer player, int val) {
        String fieldName = Environment.isObfuscated() ? "field_71076_b" : "sleepTimer";
        try {
            Field field = EntityPlayer.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.setInt(player, val);
        }
        catch (SecurityException ex) {
            throw new Error(ex);
        }
        catch (NoSuchFieldException ex) {
            throw new Error(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new Error(ex);
        }
        catch (IllegalAccessException ex) {
            throw new Error(ex);
        }
    }

    public static boolean isPlayerInBerth(EntityPlayer player) {
        return m_sleepingBerths.get(player.func_145782_y()) != null;
    }

    public static boolean isPlayerInBerth(World world, int x, int y, int z) {
        for (BerthCoords coords : m_sleepingBerths.values()) {
            if (!coords.equals(world, x, y, z)) continue;
            return true;
        }
        return false;
    }

    public static void onPlayerWakeUp(EntityPlayer player, boolean wasSleepSuccessful) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        WorldServer worldServer = (WorldServer)player.field_70170_p;
        if (!wasSleepSuccessful) {
            return;
        }
        BerthCoords coords = m_sleepingBerths.get(player.func_145782_y());
        if (coords == null) {
            return;
        }
        m_sleepingBerths.remove(player.func_145782_y());
        World berthWorld = coords.getWorldOnServer();
        if (berthWorld == null || berthWorld.func_147439_a(coords.x, coords.y, coords.z) != Ships.m_blockBerth) {
            return;
        }
        PlayerRespawner.getSavedBerths(worldServer).put(player.func_70005_c_(), coords);
        PlayerRespawner.saveBerths();
        player.func_71063_a(null, false);
        player.func_145747_a((IChatComponent)new ChatComponentTranslation(GuiString.Slept.getKey(), new Object[0]));
    }

    public static void onPlayerRespawn(EntityPlayerMP oldPlayer, EntityPlayerMP newPlayer, int dimension) {
        if (oldPlayer.field_70170_p.field_72995_K) {
            return;
        }
        WorldServer worldServer = (WorldServer)newPlayer.field_70170_p;
        if (oldPlayer.getBedLocation(dimension) != null) {
            return;
        }
        BerthCoords coords = PlayerRespawner.getSavedBerths(worldServer).get(newPlayer.func_70005_c_());
        if (coords == null) {
            return;
        }
        if (coords.shipUuid == null) {
            newPlayer.func_70012_b((double)coords.x, (double)coords.y, (double)coords.z, 0.0f, 0.0f);
        } else {
            Vec3 p = Vec3.func_72443_a((double)coords.x, (double)coords.y, (double)coords.z);
            EntityShip ship = coords.getShipOnServer();
            if (ship != null) {
                ship.blocksToShip(p);
                ship.shipToWorld(p);
                newPlayer.func_70012_b(p.field_72450_a, p.field_72448_b, p.field_72449_c, 0.0f, 0.0f);
            } else {
                newPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(GuiString.BerthNotFound.getKey(), new Object[0]));
            }
        }
    }

    public static void onShipLaunch(WorldServer worldServer, ShipWorld shipWorld, Coords shipBlock) {
        Map<String, BerthCoords> berths = PlayerRespawner.getSavedBerths(worldServer);
        boolean changed = false;
        for (Coords coords : shipWorld.coords()) {
            if (shipWorld.getBlock(coords) != Ships.m_blockBerth || !BlockBerth.func_149975_b((int)shipWorld.getBlockMetadata(coords))) continue;
            int worldX = shipBlock.x + coords.x;
            int worldY = shipBlock.y + coords.y;
            int worldZ = shipBlock.z + coords.z;
            for (BerthCoords berth : berths.values()) {
                if (!berth.equals((World)worldServer, worldX, worldY, worldZ)) continue;
                berth.moveToShip(shipWorld, coords.x, coords.y, coords.z);
                changed = true;
            }
        }
        if (changed) {
            PlayerRespawner.saveBerths();
        }
    }

    public static void onShipDock(WorldServer worldServer, ShipWorld shipWorld, BlockMap<Coords> correspondence) {
        Map<String, BerthCoords> berths = PlayerRespawner.getSavedBerths(worldServer);
        boolean changed = false;
        for (Coords coords : shipWorld.coords()) {
            if (shipWorld.getBlock(coords) != Ships.m_blockBerth || !BlockBerth.func_149975_b((int)shipWorld.getBlockMetadata(coords))) continue;
            for (BerthCoords berth : berths.values()) {
                if (!berth.equals(shipWorld, coords.x, coords.y, coords.z)) continue;
                Coords worldCoords = (Coords)correspondence.get(coords);
                berth.moveToWorld(worldCoords.x, worldCoords.y, worldCoords.z);
                changed = true;
            }
        }
        if (changed) {
            PlayerRespawner.saveBerths();
        }
    }

    private static File getSaveFile() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "berths.dat");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBerths() {
        File file = PlayerRespawner.getSaveFile();
        DataOutputStream out = null;
        try {
            out = new DataOutputStream(new FileOutputStream(file));
            out.writeInt(m_playerSavedBerths.size());
            for (Map.Entry<String, BerthCoords> entry : m_playerSavedBerths.entrySet()) {
                String username = entry.getKey();
                BerthCoords coords = entry.getValue();
                out.writeUTF(username);
                out.writeInt(coords.dimensionId);
                out.writeBoolean(coords.shipUuid != null);
                if (coords.shipUuid != null) {
                    out.writeLong(coords.shipUuid.getMostSignificantBits());
                    out.writeLong(coords.shipUuid.getLeastSignificantBits());
                }
                out.writeInt(coords.x);
                out.writeInt(coords.y);
                out.writeInt(coords.z);
            }
        }
        catch (IOException ex) {
            try {
                Ships.logger.error(ex, "Unable to save berths! Player spawn points on ships were not saved!", new Object[0]);
            }
            catch (Throwable throwable) {
                Util.closeSilently(out);
                throw throwable;
            }
            Util.closeSilently(out);
        }
        Util.closeSilently(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBerths() {
        File file = PlayerRespawner.getSaveFile();
        if (!file.exists()) {
            return;
        }
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(file));
            int numRecords = in.readInt();
            for (int i = 0; i < numRecords; ++i) {
                String username = in.readUTF();
                BerthCoords coords = new BerthCoords();
                coords.dimensionId = in.readInt();
                boolean hasShipId = in.readBoolean();
                if (hasShipId) {
                    coords.shipUuid = new UUID(in.readLong(), in.readLong());
                }
                coords.x = in.readInt();
                coords.y = in.readInt();
                coords.z = in.readInt();
                m_playerSavedBerths.put(username, coords);
            }
        }
        catch (IOException ex) {
            try {
                Ships.logger.error(ex, "Unable to load berths! Player spawn points on ships were not loaded!", new Object[0]);
            }
            catch (Throwable throwable) {
                Util.closeSilently(in);
                throw throwable;
            }
            Util.closeSilently(in);
        }
        Util.closeSilently(in);
    }

    private static class BerthCoords {
        int dimensionId;
        UUID shipUuid;
        int x;
        int y;
        int z;

        public BerthCoords() {
            this.dimensionId = 0;
            this.shipUuid = null;
            this.x = 0;
            this.y = 0;
            this.z = 0;
        }

        public BerthCoords(World world, int x, int y, int z) {
            World realWorld = world;
            ShipWorld shipWorld = null;
            if (world instanceof ShipWorld) {
                shipWorld = (ShipWorld)world;
                realWorld = shipWorld.getShip().field_70170_p;
            }
            this.dimensionId = realWorld.field_73011_w.field_76574_g;
            this.shipUuid = shipWorld != null ? shipWorld.getShip().getPersistentID() : null;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(World world, int x, int y, int z) {
            if (this.x != x || this.y != y || this.z != z) {
                return false;
            }
            if (world instanceof ShipWorld) {
                return this.shipUuid != null && this.shipUuid.equals(((ShipWorld)world).getShip().getPersistentID());
            }
            return this.dimensionId == world.field_73011_w.field_76574_g;
        }

        public World getWorldOnServer() {
            if (this.shipUuid == null) {
                return DimensionManager.getWorld((int)this.dimensionId);
            }
            EntityShip ship = this.getShipOnServer();
            if (ship != null) {
                return ship.getShipWorld();
            }
            return null;
        }

        public EntityShip getShipOnServer() {
            if (this.shipUuid == null) {
                return null;
            }
            WorldServer realWorld = DimensionManager.getWorld((int)this.dimensionId);
            return ShipLocator.getShip((World)realWorld, this.shipUuid);
        }

        public void moveToShip(ShipWorld shipWorld, int x, int y, int z) {
            this.shipUuid = shipWorld.getShip().getPersistentID();
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void moveToWorld(int x, int y, int z) {
            this.shipUuid = null;
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

