/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.ships.EntityShip;
import java.util.List;
import net.minecraft.client.settings.GameSettings;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public enum PilotAction {
    Forward{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.linearThrottle = 100;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.linearThrottle = 0;
        }
    }
    ,
    Backward{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.linearThrottle = -25;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.linearThrottle = 0;
        }
    }
    ,
    Left{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.angularThrottle = 1;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.angularThrottle = 0;
        }
    }
    ,
    Right{

        @Override
        public void applyToShip(EntityShip ship) {
            ship.angularThrottle = -1;
        }

        @Override
        public void resetShip(EntityShip ship) {
            ship.angularThrottle = 0;
        }
    }
    ,
    ThrottleUp{
        private boolean m_isForwardAllowed = true;

        @Override
        public void applyToShip(EntityShip ship) {
            if (ship.linearThrottle < 0) {
                this.m_isForwardAllowed = false;
            }
            if (ship.linearThrottle < 0 || ship.linearThrottle == 0 && this.m_isForwardAllowed || ship.linearThrottle > 0) {
                ship.linearThrottle = ship.linearThrottle < 0 && ship.linearThrottle > -2 ? 0 : (ship.linearThrottle += 2);
            }
        }

        @Override
        public void resetShip(EntityShip ship) {
            this.m_isForwardAllowed = true;
        }
    }
    ,
    ThrottleDown{
        private boolean m_isReverseAllowed = true;

        @Override
        public void applyToShip(EntityShip ship) {
            if (ship.linearThrottle > 0) {
                this.m_isReverseAllowed = false;
            }
            if (ship.linearThrottle > 0 || ship.linearThrottle == 0 && this.m_isReverseAllowed || ship.linearThrottle < 0) {
                ship.linearThrottle = ship.linearThrottle > 0 && ship.linearThrottle < 2 ? 0 : (ship.linearThrottle -= 2);
            }
        }

        @Override
        public void resetShip(EntityShip ship) {
            this.m_isReverseAllowed = true;
        }
    };

    private int m_keyCode = -1;

    public static void setActionCodes(GameSettings settings) {
        PilotAction.Forward.m_keyCode = settings.field_74351_w.func_151463_i();
        PilotAction.Backward.m_keyCode = settings.field_74368_y.func_151463_i();
        PilotAction.Left.m_keyCode = settings.field_74370_x.func_151463_i();
        PilotAction.Right.m_keyCode = settings.field_74366_z.func_151463_i();
        PilotAction.ThrottleUp.m_keyCode = settings.field_74351_w.func_151463_i();
        PilotAction.ThrottleDown.m_keyCode = settings.field_74368_y.func_151463_i();
    }

    public static int getActiveActions(GameSettings settings, List<PilotAction> allowedActions) {
        int actions = 0;
        for (PilotAction action : allowedActions) {
            if (!PilotAction.isKeyDown(action.m_keyCode)) continue;
            actions |= 1 << action.ordinal();
        }
        return actions;
    }

    private static boolean isKeyDown(int code) {
        if (PilotAction.isKey(code)) {
            return Keyboard.isKeyDown((int)code);
        }
        if (PilotAction.isButton(code)) {
            return Mouse.isButtonDown((int)(code + 100));
        }
        return false;
    }

    private static boolean isKey(int code) {
        return code >= 0 && code < 256;
    }

    private static boolean isButton(int code) {
        int button = code + 100;
        return button >= 0 && button < Mouse.getButtonCount();
    }

    public static void applyToShip(EntityShip ship, int actions) {
        for (PilotAction action : PilotAction.values()) {
            if (!action.isActive(actions)) continue;
            action.applyToShip(ship);
        }
    }

    public static void resetShip(EntityShip ship, int actions, int oldActions) {
        for (PilotAction action : PilotAction.values()) {
            if (!action.isActive(oldActions) || action.isActive(actions)) continue;
            action.resetShip(ship);
        }
    }

    public boolean isActive(int actions) {
        return (actions >> this.ordinal() & 1) == 1;
    }

    protected abstract void applyToShip(EntityShip var1);

    protected void resetShip(EntityShip ship) {
    }
}

