/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.EntityUtils;
import cuchaz.ships.EntityShip;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class HitList {
    private TreeSet<Entry> m_entries = new TreeSet();

    public Entry getClosestHit() {
        if (this.m_entries.isEmpty()) {
            return null;
        }
        return this.m_entries.first();
    }

    public List<Entry> toList() {
        return new ArrayList<Entry>(this.m_entries);
    }

    public void addHits(World world, Vec3 from, Vec3 to) {
        MovingObjectPosition hit = world.func_72933_a(Vec3.func_72443_a((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c), Vec3.func_72443_a((double)to.field_72450_a, (double)to.field_72448_b, (double)to.field_72449_c));
        if (hit == null) {
            return;
        }
        this.m_entries.add(new Entry(Type.World, from.func_72438_d(hit.field_72307_f), hit));
    }

    public void addHits(EntityShip ship, Vec3 from, Vec3 to) {
        Vec3 shipFrom = Vec3.func_72443_a((double)from.field_72450_a, (double)from.field_72448_b, (double)from.field_72449_c);
        ship.worldToShip(shipFrom);
        ship.shipToBlocks(shipFrom);
        Vec3 shipTo = Vec3.func_72443_a((double)to.field_72450_a, (double)to.field_72448_b, (double)to.field_72449_c);
        ship.worldToShip(shipTo);
        ship.shipToBlocks(shipTo);
        for (MovingObjectPosition hit : ship.getCollider().lineSegmentQuery(shipFrom, shipTo)) {
            ship.blocksToShip(hit.field_72307_f);
            ship.shipToWorld(hit.field_72307_f);
            this.m_entries.add(new Entry(Type.Ship, from.func_72438_d(hit.field_72307_f), hit));
        }
    }

    public void addHits(World world, EntityPlayer player, double reachDist) {
        if (player == null) {
            throw new IllegalArgumentException("player cannot be null!");
        }
        Vec3 eyePos = EntityUtils.getPlayerEyePos(player);
        Vec3 lookDir = EntityUtils.getPlayerLookDirection(player);
        Vec3 targetPos = eyePos.func_72441_c(lookDir.field_72450_a * reachDist, lookDir.field_72448_b * reachDist, lookDir.field_72449_c * reachDist);
        this.addHits(world, eyePos, targetPos);
    }

    public void addHits(EntityShip ship, EntityPlayer player, double reachDist) {
        if (player == null) {
            throw new IllegalArgumentException("player cannot be null!");
        }
        Vec3 eyePos = EntityUtils.getPlayerEyePos(player);
        Vec3 lookDir = EntityUtils.getPlayerLookDirection(player);
        Vec3 targetPos = eyePos.func_72441_c(lookDir.field_72450_a * reachDist, lookDir.field_72448_b * reachDist, lookDir.field_72449_c * reachDist);
        this.addHits(ship, eyePos, targetPos);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Entry entry : this.m_entries) {
            buf.append((Object)entry.type);
            buf.append(":");
            buf.append(String.format("%.2f", entry.dist));
        }
        return buf.toString();
    }

    public class Entry
    implements Comparable<Entry> {
        public Type type;
        public double dist;
        public MovingObjectPosition hit;

        public Entry(Type type, double dist, MovingObjectPosition hit) {
            this.type = type;
            this.dist = dist;
            this.hit = hit;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.equals((Entry)obj);
            }
            return false;
        }

        public boolean equals(Entry other) {
            return this.type == other.type && this.dist == other.dist && this.hit == other.hit;
        }

        @Override
        public int compareTo(Entry other) {
            return Double.compare(this.dist, other.dist);
        }
    }

    public static enum Type {
        Ship,
        World;

    }
}

