/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cuchaz.ships.items.SupporterPlaqueType;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntitySupporterPlaque
extends EntityHanging
implements IEntityAdditionalSpawnData {
    private SupporterPlaqueType m_type;
    private int m_supporterId;

    public EntitySupporterPlaque(World world) {
        super(world);
        this.m_type = SupporterPlaqueType.Small;
        this.m_supporterId = 0;
    }

    public EntitySupporterPlaque(World world, SupporterPlaqueType type, int supporterId, int x, int y, int z, int direction) {
        super(world, x, y, z, direction);
        this.field_82332_a = direction;
        this.m_type = type;
        this.m_supporterId = supporterId;
        this.initPlaque();
    }

    public SupporterPlaqueType getType() {
        return this.m_type;
    }

    public int getSupporterId() {
        return this.m_supporterId;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("type", this.m_type.getMeta());
        nbt.func_74768_a("supporterId", this.m_supporterId);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.m_type = SupporterPlaqueType.getByMeta(nbt.func_74762_e("type"));
        this.m_supporterId = nbt.func_74762_e("supporterId");
        this.initPlaque();
    }

    private void initPlaque() {
        this.func_82328_a(this.field_82332_a);
        if (this.m_supporterId == -1) {
            this.func_70106_y();
            return;
        }
    }

    public int func_82329_d() {
        return this.m_type.getSize();
    }

    public int func_82330_g() {
        return this.m_type.getSize();
    }

    public void func_110128_b(Entity entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            if (entityplayer.field_71075_bZ.field_75098_d) {
                return;
            }
        }
        this.func_70099_a(this.m_type.newItemStack(), 0.0f);
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int alwaysThree) {
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.field_146063_b);
        buf.writeInt(this.field_146064_c);
        buf.writeInt(this.field_146062_d);
        buf.writeInt(this.field_82332_a);
        buf.writeInt(this.m_type.getMeta());
        buf.writeInt(this.m_supporterId);
    }

    public void readSpawnData(ByteBuf buf) {
        this.field_146063_b = buf.readInt();
        this.field_146064_c = buf.readInt();
        this.field_146062_d = buf.readInt();
        this.field_82332_a = buf.readInt();
        this.m_type = SupporterPlaqueType.getByMeta(buf.readInt());
        this.m_supporterId = buf.readInt();
        this.initPlaque();
    }
}

