/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import cuchaz.modsShared.EntityUtils;
import cuchaz.modsShared.Environment;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.modsShared.blocks.Envelopes;
import cuchaz.modsShared.math.CircleRange;
import cuchaz.modsShared.math.CompareReal;
import cuchaz.modsShared.math.RotatedBB;
import cuchaz.modsShared.perf.DelayTimer;
import cuchaz.ships.HitList;
import cuchaz.ships.PilotAction;
import cuchaz.ships.RainDisplacer;
import cuchaz.ships.ShipCollider;
import cuchaz.ships.ShipPhysics;
import cuchaz.ships.ShipUnlauncher;
import cuchaz.ships.ShipWorld;
import cuchaz.ships.Ships;
import cuchaz.ships.WaterDisplacer;
import cuchaz.ships.config.BlockProperties;
import cuchaz.ships.packets.PacketPilotShip;
import cuchaz.ships.packets.PacketRequestShipBlocks;
import cuchaz.ships.packets.PacketShipLaunched;
import cuchaz.ships.persistence.PersistenceException;
import cuchaz.ships.persistence.ShipPersistence;
import cuchaz.ships.propulsion.Propulsion;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class EntityShip
extends Entity {
    public static final int LinearThrottleMax = 100;
    public static final int LinearThrottleMin = -25;
    public static final int LinearThrottleStep = 2;
    public static final int AngularThrottleMax = 1;
    public static final int AngularThrottleMin = -1;
    public float motionYaw;
    public int linearThrottle;
    public int angularThrottle;
    private ShipWorld m_shipWorld;
    private ShipPhysics m_physics;
    private Propulsion m_propulsion;
    private double m_shipBlockX;
    private double m_shipBlockY;
    private double m_shipBlockZ;
    private int m_pilotActions;
    private int m_oldPilotActions;
    private BlockSide m_sideShipForward;
    private boolean m_sendPilotChangesToServer;
    private boolean m_hasInfoFromServer;
    private double m_xFromServer;
    private double m_yFromServer;
    private double m_zFromServer;
    private float m_yawFromServer;
    private float m_pitchFromServer;
    private ShipCollider m_collider;
    private WaterDisplacer m_waterDisplacer;
    private RainDisplacer m_rainDisplacer;
    private DelayTimer m_throttleKillDelay;
    private Map<Integer, Entity> m_ridersLastTick;

    public EntityShip(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.motionYaw = 0.0f;
        this.linearThrottle = 0;
        this.angularThrottle = 0;
        this.m_shipWorld = null;
        this.m_physics = null;
        this.m_propulsion = null;
        this.m_shipBlockX = 0.0;
        this.m_shipBlockY = 0.0;
        this.m_shipBlockZ = 0.0;
        this.m_pilotActions = 0;
        this.m_oldPilotActions = 0;
        this.m_sideShipForward = null;
        this.m_sendPilotChangesToServer = false;
        this.m_hasInfoFromServer = false;
        this.m_xFromServer = 0.0;
        this.m_yFromServer = 0.0;
        this.m_zFromServer = 0.0;
        this.m_yawFromServer = 0.0f;
        this.m_pitchFromServer = 0.0f;
        this.m_collider = new ShipCollider(this);
        this.m_waterDisplacer = new WaterDisplacer(this);
        this.m_rainDisplacer = new RainDisplacer(this);
        this.m_throttleKillDelay = null;
        this.m_ridersLastTick = new TreeMap<Integer, Entity>();
    }

    protected void func_70088_a() {
    }

    public void setShipWorld(ShipWorld shipWorld) {
        if (!shipWorld.isValid()) {
            this.func_70106_y();
            Ships.logger.warning("Ship world is invalid. Killed ship.", new Object[0]);
            return;
        }
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.motionYaw = 0.0f;
        this.m_shipWorld = shipWorld;
        shipWorld.setShip(this);
        this.m_physics = new ShipPhysics(this.m_shipWorld.getBlocksStorage());
        this.m_propulsion = new Propulsion(this.m_shipWorld.getBlocksStorage());
        Vec3 centerOfMass = this.m_physics.getCenterOfMass();
        this.m_shipBlockX = -centerOfMass.field_72450_a;
        this.m_shipBlockY = -centerOfMass.field_72448_b;
        this.m_shipBlockZ = -centerOfMass.field_72449_c;
        this.m_collider.computeShipBoundingBox(this.field_70121_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        Ships.logger.info(String.format("EntityShip %d initialized at (%.2f,%.2f,%.2f) + (%.4f,%.4f,%.4f)", this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y), new Object[0]);
    }

    public void func_70106_y() {
        List<Entity> riders;
        super.func_70106_y();
        Ships.logger.info("EntityShip %d died!", this.func_145782_y());
        if (Environment.isServer()) {
            this.m_waterDisplacer.restore();
            this.m_rainDisplacer.restore();
        }
        if (!(riders = this.getCollider().getRiders()).isEmpty()) {
            ShipUnlauncher unlauncher = new ShipUnlauncher(this);
            for (Entity rider : riders) {
                boolean isPlayer = rider instanceof EntityPlayer;
                if ((!isPlayer || !Environment.isClient()) && isPlayer) continue;
                unlauncher.applyUnlaunch(rider);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB queryBox = this.field_70121_D.func_72329_c();
            float dist = 5.0f;
            queryBox.func_72314_b(5.0, 5.0, 5.0);
            List players = this.field_70170_p.func_72872_a(EntityPlayer.class, queryBox);
            for (EntityPlayer player : players) {
                if (player.field_71070_bA == null) continue;
                player.func_71053_j();
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        try {
            ShipPersistence.readAnyVersion(this, nbt);
        }
        catch (PersistenceException ex) {
            Ships.logger.warning(ex, "Unable to read ship. Removing ship from world.", new Object[0]);
            this.func_70106_y();
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        ShipPersistence.writeNewestVersion(this, nbt);
    }

    public ShipWorld getShipWorld() {
        return this.m_shipWorld;
    }

    public Propulsion getPropulsion() {
        return this.m_propulsion;
    }

    public ShipCollider getCollider() {
        return this.m_collider;
    }

    public WaterDisplacer getWaterDisplacer() {
        return this.m_waterDisplacer;
    }

    public RainDisplacer getRainDisplacer() {
        return this.m_rainDisplacer;
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return null;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        if (this.m_collider != null) {
            this.m_collider.computeShipBoundingBox(this.field_70121_D, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z);
        }
    }

    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int alwaysThree) {
        this.m_hasInfoFromServer = true;
        this.m_xFromServer = x;
        this.m_yFromServer = y;
        this.m_zFromServer = z;
        this.m_yawFromServer = yaw;
        this.m_pitchFromServer = pitch;
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        if (this.m_shipWorld == null) {
            PacketShipLaunched packet = PacketShipLaunched.instance.getPacket(this);
            if (packet != null) {
                packet.process(this);
            } else {
                Ships.net.getDispatch().sendToServer((IMessage)new PacketRequestShipBlocks(this.func_145782_y()));
            }
        }
        if (this.m_shipWorld == null) {
            return;
        }
        double waterHeightInBlockSpace = this.shipToBlocksY(this.worldToShipY(this.getWaterHeight()));
        this.adjustMotionDueToGravityAndBuoyancy(waterHeightInBlockSpace);
        this.adjustMotionDueToThrustAndDrag(waterHeightInBlockSpace);
        double dx = this.field_70159_w;
        double dy = this.field_70181_x;
        double dz = this.field_70179_y;
        float dYaw = this.motionYaw;
        if (this.m_hasInfoFromServer) {
            double yawRadServer;
            double yawDelta;
            dx += this.m_xFromServer - this.field_70165_t;
            dy += this.m_yFromServer - this.field_70163_u;
            dz += this.m_zFromServer - this.field_70161_v;
            double yawRadClient = CircleRange.mapMinusPiToPi(Math.toRadians(this.field_70177_z));
            if (!CompareReal.eq(CircleRange.mapMinusPiToPi(yawRadClient + (yawDelta = CircleRange.newByShortSegment(yawRadClient, yawRadServer = CircleRange.mapMinusPiToPi(Math.toRadians(this.m_yawFromServer))).getLength())), yawRadServer)) {
                yawDelta = -yawDelta;
            }
            yawDelta = Math.toDegrees(yawDelta);
            dYaw = (float)((double)dYaw + yawDelta);
            this.field_70125_A = this.m_pitchFromServer;
            this.m_hasInfoFromServer = false;
        }
        double Epsilon = 0.001;
        if (Math.abs(dx) >= 0.001 || Math.abs(dy) >= 0.001 || Math.abs(dz) >= 0.001 || (double)Math.abs(dYaw) >= 0.001) {
            List<Entity> riders = this.m_collider.getRiders();
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
            this.m_collider.moveShip(dx, dy, dz, dYaw);
            dx = this.field_70165_t - this.field_70169_q;
            dy = this.field_70163_u - this.field_70167_r;
            dz = this.field_70161_v - this.field_70166_s;
            dYaw = this.field_70177_z - this.field_70126_B;
            this.m_waterDisplacer.update(waterHeightInBlockSpace);
            this.m_rainDisplacer.update();
            this.moveRiders(riders, dx, dy, dz, dYaw);
            if (riders.isEmpty() && (this.linearThrottle != 0 || this.angularThrottle != 0)) {
                if (this.m_throttleKillDelay == null) {
                    this.m_throttleKillDelay = new DelayTimer(40);
                }
                if (this.m_throttleKillDelay.isDelayedUpdate()) {
                    this.linearThrottle = 0;
                    this.angularThrottle = 0;
                    this.m_throttleKillDelay = null;
                }
            } else {
                this.m_throttleKillDelay = null;
            }
        }
        this.m_shipWorld.func_72939_s();
    }

    public double getWaterHeight() {
        BlockSet waterCoords = new BlockSet();
        BlockUtils.worldRangeQuery(waterCoords, this.field_70170_p, this.field_70121_D);
        Iterator iter = waterCoords.iterator();
        while (iter.hasNext()) {
            Coords coords = (Coords)iter.next();
            Block block = this.field_70170_p.func_147439_a(coords.x, coords.y, coords.z);
            if (BlockProperties.isWater(block)) continue;
            iter.remove();
        }
        if (waterCoords.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        BlockSet topEnvelope = new Envelopes(waterCoords).getEnvelope(BlockSide.Top).toBlockSet();
        for (Coords coords : topEnvelope) {
            sum += (double)(coords.y + 1);
        }
        return sum / (double)topEnvelope.size();
    }

    public boolean func_130002_c(EntityPlayer player) {
        double reachDist = EntityUtils.getPlayerReachDistance(player);
        HitList hits = new HitList();
        hits.addHits(this, player, reachDist);
        HitList.Entry hit = hits.getClosestHit();
        if (hit == null || hit.type != HitList.Type.Ship) {
            return false;
        }
        Block block = this.m_shipWorld.func_147439_a(hit.hit.field_72311_b, hit.hit.field_72312_c, hit.hit.field_72309_d);
        try {
            return block.func_149727_a((World)this.m_shipWorld, hit.hit.field_72311_b, hit.hit.field_72312_c, hit.hit.field_72309_d, player, hit.hit.field_72310_e, (float)hit.hit.field_72307_f.field_72450_a, (float)hit.hit.field_72307_f.field_72448_b, (float)hit.hit.field_72307_f.field_72449_c);
        }
        catch (Throwable t) {
            Ships.logger.error(t, "Error activating block %s", Block.field_149771_c.func_148750_c((Object)block));
            return false;
        }
    }

    public boolean func_85031_j(Entity attackingEntity) {
        return true;
    }

    public void worldToShip(Vec3 v) {
        double x = this.worldToShipX(v.field_72450_a, v.field_72449_c);
        double y = this.worldToShipY(v.field_72448_b);
        double z = this.worldToShipZ(v.field_72450_a, v.field_72449_c);
        v.field_72450_a = x;
        v.field_72448_b = y;
        v.field_72449_c = z;
    }

    public void worldToShipDirection(Vec3 v) {
        double yawRad = Math.toRadians(this.field_70177_z);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double x = v.field_72450_a * cos - v.field_72449_c * sin;
        double z = v.field_72450_a * sin + v.field_72449_c * cos;
        v.field_72450_a = x;
        v.field_72449_c = z;
    }

    public double worldToShipX(double x, double z) {
        double yawRad = Math.toRadians(this.field_70177_z);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        return (x - this.field_70165_t) * cos - (z - this.field_70161_v) * sin;
    }

    public double worldToShipY(double y) {
        return y - this.field_70163_u;
    }

    public double worldToShipZ(double x, double z) {
        double yawRad = Math.toRadians(this.field_70177_z);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        return (x - this.field_70165_t) * sin + (z - this.field_70161_v) * cos;
    }

    public void shipToWorld(Vec3 v) {
        double x = this.shipToWorldX(v.field_72450_a, v.field_72449_c);
        double y = this.shipToWorldY(v.field_72448_b);
        double z = this.shipToWorldZ(v.field_72450_a, v.field_72449_c);
        v.field_72450_a = x;
        v.field_72448_b = y;
        v.field_72449_c = z;
    }

    public void shipToWorldDirection(Vec3 v) {
        double yawRad = Math.toRadians(this.field_70177_z);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        double x = v.field_72450_a * cos + v.field_72449_c * sin;
        double z = -v.field_72450_a * sin + v.field_72449_c * cos;
        v.field_72450_a = x;
        v.field_72449_c = z;
    }

    public double shipToWorldX(double x, double z) {
        double yawRad = Math.toRadians(this.field_70177_z);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        return x * cos + z * sin + this.field_70165_t;
    }

    public double shipToWorldY(double y) {
        return y + this.field_70163_u;
    }

    public double shipToWorldZ(double x, double z) {
        double yawRad = Math.toRadians(this.field_70177_z);
        double cos = Math.cos(yawRad);
        double sin = Math.sin(yawRad);
        return -x * sin + z * cos + this.field_70161_v;
    }

    public void shipToBlocks(Vec3 v) {
        v.field_72450_a = this.shipToBlocksX(v.field_72450_a);
        v.field_72448_b = this.shipToBlocksY(v.field_72448_b);
        v.field_72449_c = this.shipToBlocksZ(v.field_72449_c);
    }

    public double shipToBlocksX(double x) {
        return x - this.m_shipBlockX;
    }

    public double shipToBlocksY(double y) {
        return y - this.m_shipBlockY;
    }

    public double shipToBlocksZ(double z) {
        return z - this.m_shipBlockZ;
    }

    public void blocksToShip(Vec3 v) {
        v.field_72450_a = this.blocksToShipX(v.field_72450_a);
        v.field_72448_b = this.blocksToShipY(v.field_72448_b);
        v.field_72449_c = this.blocksToShipZ(v.field_72449_c);
    }

    public double blocksToShipX(double x) {
        return x + this.m_shipBlockX;
    }

    public double blocksToShipY(double y) {
        return y + this.m_shipBlockY;
    }

    public double blocksToShipZ(double z) {
        return z + this.m_shipBlockZ;
    }

    public RotatedBB worldToBlocks(AxisAlignedBB box) {
        Vec3 center = Vec3.func_72443_a((double)((box.field_72340_a + box.field_72336_d) / 2.0), (double)((box.field_72338_b + box.field_72337_e) / 2.0), (double)((box.field_72339_c + box.field_72334_f) / 2.0));
        this.worldToShip(center);
        this.shipToBlocks(center);
        double dxh = (box.field_72336_d - box.field_72340_a) / 2.0;
        double dyh = (box.field_72337_e - box.field_72338_b) / 2.0;
        double dzh = (box.field_72334_f - box.field_72339_c) / 2.0;
        box = AxisAlignedBB.func_72330_a((double)(center.field_72450_a - dxh), (double)(center.field_72448_b - dyh), (double)(center.field_72449_c - dzh), (double)(center.field_72450_a + dxh), (double)(center.field_72448_b + dyh), (double)(center.field_72449_c + dzh));
        return new RotatedBB(box, -this.field_70177_z);
    }

    public RotatedBB blocksToWorld(AxisAlignedBB box) {
        Vec3 center = Vec3.func_72443_a((double)((box.field_72340_a + box.field_72336_d) / 2.0), (double)((box.field_72338_b + box.field_72337_e) / 2.0), (double)((box.field_72339_c + box.field_72334_f) / 2.0));
        this.blocksToShip(center);
        this.shipToWorld(center);
        double dxh = (box.field_72336_d - box.field_72340_a) / 2.0;
        double dyh = (box.field_72337_e - box.field_72338_b) / 2.0;
        double dzh = (box.field_72334_f - box.field_72339_c) / 2.0;
        box = AxisAlignedBB.func_72330_a((double)(center.field_72450_a - dxh), (double)(center.field_72448_b - dyh), (double)(center.field_72449_c - dzh), (double)(center.field_72450_a + dxh), (double)(center.field_72448_b + dyh), (double)(center.field_72449_c + dzh));
        return new RotatedBB(box, this.field_70177_z);
    }

    private void adjustMotionDueToGravityAndBuoyancy(double waterHeightInBlockSpace) {
        Vec3 velocity = Vec3.func_72443_a((double)0.0, (double)this.field_70181_x, (double)0.0);
        double accelerationDueToBouyancy = this.m_physics.getNetUpAcceleration(waterHeightInBlockSpace);
        double accelerationDueToDrag = this.m_physics.getLinearAccelerationDueToDrag(velocity, waterHeightInBlockSpace);
        accelerationDueToDrag = Math.min(Math.abs(this.field_70181_x + accelerationDueToBouyancy), accelerationDueToDrag);
        if (Math.signum(accelerationDueToDrag) == Math.signum(this.field_70181_x)) {
            accelerationDueToDrag *= -1.0;
        }
        this.field_70181_x += accelerationDueToBouyancy + accelerationDueToDrag;
    }

    private void adjustMotionDueToThrustAndDrag(double waterHeightInBlockSpace) {
        double velocityDirZ;
        double velocityDirX;
        double speed;
        PilotAction.resetShip(this, this.m_pilotActions, this.m_oldPilotActions);
        PilotAction.applyToShip(this, this.m_pilotActions);
        this.m_oldPilotActions = this.m_pilotActions;
        if (this.linearThrottle < -25) {
            this.linearThrottle = -25;
        }
        if (this.linearThrottle > 100) {
            this.linearThrottle = 100;
        }
        if ((speed = Math.sqrt((velocityDirX = this.field_70159_w) * velocityDirX + (velocityDirZ = this.field_70179_y) * velocityDirZ)) > 0.0) {
            velocityDirX /= speed;
            velocityDirZ /= speed;
        }
        Vec3 velocityInBlockCoords = Vec3.func_72443_a((double)this.field_70159_w, (double)0.0, (double)this.field_70179_y);
        this.worldToShipDirection(velocityInBlockCoords);
        double linearAccelerationDueToThrustX = 0.0;
        double linearAccelerationDueToThrustZ = 0.0;
        if (this.m_sideShipForward != null) {
            if (this.m_sendPilotChangesToServer) {
                PacketPilotShip packet = new PacketPilotShip(this.func_145782_y(), this.m_pilotActions, this.m_sideShipForward, this.linearThrottle, this.angularThrottle);
                Ships.net.getDispatch().sendToServer((IMessage)packet);
                this.m_sendPilotChangesToServer = false;
            }
            float yawRad = (float)Math.toRadians(this.field_70177_z);
            float cos = MathHelper.func_76134_b((float)yawRad);
            float sin = MathHelper.func_76126_a((float)yawRad);
            double forwardX = (float)this.m_sideShipForward.getDx() * cos + (float)this.m_sideShipForward.getDz() * sin;
            double forwardZ = (float)(-this.m_sideShipForward.getDx()) * sin + (float)this.m_sideShipForward.getDz() * cos;
            double linearAccelerationDueToThrust = this.m_physics.getLinearAccelerationDueToThrust(this.m_propulsion, speed) * (double)this.linearThrottle / 100.0;
            linearAccelerationDueToThrustX = forwardX * linearAccelerationDueToThrust;
            linearAccelerationDueToThrustZ = forwardZ * linearAccelerationDueToThrust;
        }
        double linearAccelerationDueToDrag = this.m_physics.getLinearAccelerationDueToDrag(velocityInBlockCoords, waterHeightInBlockSpace);
        double nextSpeedX = this.field_70159_w + linearAccelerationDueToThrustX;
        double nextSpeedZ = this.field_70179_y + linearAccelerationDueToThrustZ;
        double nextSpeed = Math.sqrt(nextSpeedX * nextSpeedX + nextSpeedZ * nextSpeedZ);
        linearAccelerationDueToDrag = Math.min(nextSpeed, linearAccelerationDueToDrag);
        this.field_70159_w += linearAccelerationDueToThrustX - velocityDirX * linearAccelerationDueToDrag;
        this.field_70179_y += linearAccelerationDueToThrustZ - velocityDirZ * linearAccelerationDueToDrag;
        double angularAccelerationDueToThrust = this.m_physics.getAngularAccelerationDueToThrust(this.m_propulsion) * (float)this.angularThrottle / 1.0f;
        double angularAccelerationDueToDrag = this.m_physics.getAngularAccelerationDueToDrag(this.motionYaw, waterHeightInBlockSpace);
        angularAccelerationDueToDrag = Math.min(Math.abs((double)this.motionYaw + angularAccelerationDueToThrust), angularAccelerationDueToDrag);
        if (Math.signum(angularAccelerationDueToDrag) == (double)Math.signum(this.motionYaw)) {
            angularAccelerationDueToDrag *= -1.0;
        }
        this.motionYaw = (float)((double)this.motionYaw + (angularAccelerationDueToThrust + angularAccelerationDueToDrag));
    }

    private void moveRiders(List<Entity> riders, double dx, double dy, double dz, float dYaw) {
        Vec3 delta;
        for (Entity rider : riders) {
            if (!this.m_ridersLastTick.containsKey(rider.func_145782_y())) continue;
            this.m_ridersLastTick.remove(rider.func_145782_y());
        }
        for (Entity rider : this.m_ridersLastTick.values()) {
            delta = this.getRiderDelta(rider, dx, dy, dz, dYaw);
            rider.field_70159_w += delta.field_72450_a;
            rider.field_70181_x += delta.field_72448_b;
            rider.field_70179_y += delta.field_72449_c;
            rider.field_70177_z -= dYaw;
            rider.func_70107_b(rider.field_70165_t + delta.field_72450_a, rider.field_70163_u + delta.field_72448_b, rider.field_70161_v + delta.field_72449_c);
        }
        this.m_ridersLastTick.clear();
        for (Entity rider : riders) {
            this.m_ridersLastTick.put(rider.func_145782_y(), rider);
        }
        for (Entity rider : riders) {
            delta = this.getRiderDelta(rider, dx, dy, dz, dYaw);
            rider.field_70177_z -= dYaw;
            rider.func_70107_b(rider.field_70165_t + delta.field_72450_a, rider.field_70163_u + delta.field_72448_b, rider.field_70161_v + delta.field_72449_c);
        }
    }

    public void setPilotActions(int actions, BlockSide sideShipForward, boolean sendPilotChangesToServer) {
        this.m_pilotActions = actions;
        this.m_sideShipForward = sideShipForward;
        this.m_sendPilotChangesToServer = sendPilotChangesToServer;
    }

    private Vec3 getRiderDelta(Entity rider, double shipDx, double shipDy, double shipDz, double shipDyaw) {
        Vec3 p = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        p.field_72450_a = rider.field_70165_t + shipDx;
        p.field_72449_c = rider.field_70161_v + shipDz;
        this.worldToShip(p);
        float yawRad = (float)Math.toRadians(shipDyaw);
        float cos = MathHelper.func_76134_b((float)yawRad);
        float sin = MathHelper.func_76126_a((float)yawRad);
        double x = p.field_72450_a * (double)cos + p.field_72449_c * (double)sin;
        double z = -p.field_72450_a * (double)sin + p.field_72449_c * (double)cos;
        p.field_72450_a = x;
        p.field_72449_c = z;
        this.shipToWorld(p);
        p.field_72450_a -= rider.field_70165_t;
        p.field_72448_b = shipDy;
        p.field_72449_c -= rider.field_70161_v;
        return p;
    }

    @SideOnly(value=Side.CLIENT)
    private void clickWorldBlock(EntityPlayer player, MovingObjectPosition hit, boolean isLeftButton) {
        if (hit == null || hit.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        ItemStack heldItem = player.func_70694_bm();
        PlayerControllerMP playerController = Minecraft.func_71410_x().field_71442_b;
        if (isLeftButton) {
            playerController.func_78743_b(hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, hit.field_72310_e);
        } else {
            boolean result;
            boolean bl = result = !ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)hit.field_72311_b, (int)hit.field_72312_c, (int)hit.field_72309_d, (int)hit.field_72310_e, (World)player.field_70170_p).isCanceled();
            if (result && playerController.func_78760_a(player, this.field_70170_p, heldItem, hit.field_72311_b, hit.field_72312_c, hit.field_72309_d, hit.field_72310_e, hit.field_72307_f)) {
                player.func_71038_i();
            }
            if (heldItem != null) {
                if (heldItem.field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                } else if (playerController.func_78758_h()) {
                    Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78444_b();
                }
            }
        }
    }
}

