/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.EntityShip;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.block.Block;

public abstract class Displacer {
    protected EntityShip m_ship;
    protected Block m_block;
    private BlockMap<Integer> m_displacedBlocks;
    protected BlockSet m_shouldBeDisplaced;

    protected Displacer(EntityShip ship, Block block) {
        this.m_ship = ship;
        this.m_block = block;
        this.m_displacedBlocks = new BlockMap();
        this.m_shouldBeDisplaced = new BlockSet();
    }

    protected void updateDisplacement() {
        Iterator iter = this.m_displacedBlocks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Coords coords = (Coords)entry.getKey();
            if (this.m_shouldBeDisplaced.contains(coords)) continue;
            this.restoreBlock(coords, (Integer)entry.getValue());
            iter.remove();
        }
        for (Coords coords : this.m_shouldBeDisplaced) {
            Block block = this.m_ship.field_70170_p.func_147439_a(coords.x, coords.y, coords.z);
            int blockMeta = this.m_ship.field_70170_p.func_72805_g(coords.x, coords.y, coords.z);
            if (block != this.m_block) {
                BlockUtils.changeBlockWithoutNotifyingIt(this.m_ship.field_70170_p, coords.x, coords.y, coords.z, this.m_block, 0, BlockUtils.UpdateRules.UpdateClients);
                this.m_displacedBlocks.put(coords, this.pack(block, blockMeta));
                continue;
            }
            if (this.m_displacedBlocks.containsKey(coords)) continue;
            this.m_displacedBlocks.put(coords, this.pack(block, blockMeta));
        }
    }

    public void restore() {
        for (Map.Entry entry : this.m_displacedBlocks.entrySet()) {
            this.restoreBlock((Coords)entry.getKey(), (Integer)entry.getValue());
        }
        this.m_displacedBlocks.clear();
    }

    public byte[] write() {
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            GZIPOutputStream zipOut = new GZIPOutputStream(buf);
            DataOutputStream out = new DataOutputStream(zipOut);
            out.writeInt(this.m_displacedBlocks.size());
            for (Map.Entry entry : this.m_displacedBlocks.entrySet()) {
                Coords coords = (Coords)entry.getKey();
                int packed = (Integer)entry.getValue();
                out.writeInt(coords.x);
                out.writeInt(coords.y);
                out.writeInt(coords.z);
                out.writeInt(packed);
            }
            zipOut.finish();
            out.close();
            return buf.toByteArray();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    public void read(byte[] data) {
        try {
            DataInputStream in = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(data)));
            int numEntries = in.readInt();
            for (int i = 0; i < numEntries; ++i) {
                this.m_displacedBlocks.put(new Coords(in.readInt(), in.readInt(), in.readInt()), in.readInt());
            }
            in.close();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private void restoreBlock(Coords coords, int packed) {
        if (this.m_ship.field_70170_p.func_147439_a(coords.x, coords.y, coords.z) == this.m_block) {
            Block block = this.unpackId(packed);
            int blockMeta = this.unpackMeta(packed);
            BlockUtils.changeBlockWithoutNotifyingIt(this.m_ship.field_70170_p, coords.x, coords.y, coords.z, block, blockMeta, BlockUtils.UpdateRules.UpdateClients);
        }
    }

    private int pack(Block block, int meta) {
        return Block.func_149682_b((Block)block) | (meta & 0xF) << 16;
    }

    private Block unpackId(int packed) {
        return Block.func_149729_e((int)(packed & 0xFFF));
    }

    private int unpackMeta(int packed) {
        return packed >> 16 & 0xF;
    }
}

