/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.blocks.BlockUtils;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.EntityShip;
import cuchaz.ships.ShipLocator;
import cuchaz.ships.ShipUnlauncher;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockEntry;
import cuchaz.ships.config.BlockProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;

public class CommandShips
extends CommandBase {
    public String func_71517_b() {
        return "ships";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "UNDONE: write ships command usage text.";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length <= 0) {
            SubCommand.Help.process(sender, args);
            return;
        }
        SubCommand subCommand = SubCommand.get(args[0]);
        if (subCommand == null) {
            SubCommand.Help.process(sender, args);
            return;
        }
        subCommand.process(sender, Arrays.copyOfRange(args, 1, args.length));
    }

    private static void reply(ICommandSender sender, String msg) {
        for (String line : msg.split("\\n")) {
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation(line, new Object[0]));
        }
    }

    private static void replyAllAdmins(ICommandSender sender, String msg) {
        for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
            boolean isPlayerOpped = MinecraftServer.func_71276_C().func_71203_ab().func_152603_m().func_152700_a(player.func_70005_c_()) != null;
            if (!isPlayerOpped) continue;
            player.func_145747_a((IChatComponent)new ChatComponentTranslation(msg, new Object[0]));
        }
    }

    private static enum SubCommand {
        Help("Show all Ships Mod commands", "<command name>"){

            @Override
            public void process(ICommandSender sender, String[] args) {
                if (args.length <= 0) {
                    this.listCommands(sender);
                } else if (args.length >= 1) {
                    SubCommand subCommand = SubCommand.get(args[0]);
                    if (subCommand == null) {
                        this.listCommands(sender);
                    } else {
                        this.showCommandDetail(sender, subCommand);
                    }
                }
            }

            private void listCommands(ICommandSender sender) {
                StringBuilder buf = new StringBuilder();
                buf.append("Ships Mod commands available:\n");
                for (int i = 0; i < SubCommand.values().length; ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(SubCommand.values()[i].name().toLowerCase());
                }
                buf.append("\n");
                buf.append("To learn more about a command: " + this.getUsage());
                CommandShips.reply(sender, buf.toString());
            }
        }
        ,
        List("Show all ships", ""){

            @Override
            public void process(ICommandSender sender, String[] args) {
                List<EntityShip> ships = ShipLocator.getShips(sender.func_130014_f_());
                StringBuilder buf = new StringBuilder();
                buf.append("Found ");
                buf.append(ships.size());
                buf.append(" ships.\n");
                for (EntityShip ship : ships) {
                    buf.append(String.format(" id: %8d,   blocks: %5d,   pos: ( %.1f, %.1f, %.1f )\n", ship.func_145782_y(), ship.getShipWorld().coords().size(), ship.field_70165_t, ship.field_70163_u, ship.field_70161_v));
                }
                CommandShips.reply(sender, buf.toString());
            }
        }
        ,
        Kill("Removes a ship from the world", "<id>"){

            @Override
            public void process(ICommandSender sender, String[] args) {
                int id;
                if (args.length <= 0) {
                    this.showCommandDetail(sender, this);
                    return;
                }
                try {
                    id = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException ex) {
                    CommandShips.reply(sender, "Unrecognized id!");
                    return;
                }
                EntityShip ship = ShipLocator.getShip(sender.func_130014_f_(), id);
                if (ship == null) {
                    CommandShips.reply(sender, String.format("Ship %d was not found!", id));
                    return;
                }
                ship.func_70106_y();
                CommandShips.replyAllAdmins(sender, String.format("Ship %d was killed!", id));
            }
        }
        ,
        Dock("Docks a ship", "<id>"){

            @Override
            public void process(ICommandSender sender, String[] args) {
                int id;
                if (args.length <= 0) {
                    this.showCommandDetail(sender, this);
                    return;
                }
                try {
                    id = Integer.parseInt(args[0]);
                }
                catch (NumberFormatException ex) {
                    CommandShips.reply(sender, "Unrecognized id!");
                    return;
                }
                EntityShip ship = ShipLocator.getShip(sender.func_130014_f_(), id);
                if (ship == null) {
                    CommandShips.reply(sender, String.format("Ship %d was not found!", id));
                    return;
                }
                ShipUnlauncher unlauncher = new ShipUnlauncher(ship);
                unlauncher.snapToLaunchDirection();
                unlauncher.unlaunch();
                CommandShips.replyAllAdmins(sender, String.format("Ship %d was docked!", id));
            }
        }
        ,
        RemoveAirWalls("Remove air walls", ""){

            @Override
            public void process(final ICommandSender sender, String[] args) {
                ArrayList<Coords> seedBlocks = new ArrayList<Coords>();
                for (EntityShip ship : ShipLocator.getShips(sender.func_130014_f_())) {
                    seedBlocks.add(new Coords(MathHelper.func_76128_c((double)ship.field_70165_t), MathHelper.func_76128_c((double)ship.field_70163_u), MathHelper.func_76128_c((double)ship.field_70161_v)));
                }
                seedBlocks.add(new Coords(sender.func_82114_b()));
                int NumBlocks = 4000;
                final ArrayList airWallBlocks = new ArrayList();
                for (Coords coords : seedBlocks) {
                    BlockUtils.exploreBlocks(coords, 4000, new BlockUtils.BlockCallback(){

                        @Override
                        public BlockUtils.SearchAction foundBlock(Coords coords) {
                            Block block = sender.func_130014_f_().func_147439_a(coords.x, coords.y, coords.z);
                            if (block == Ships.m_blockAirWall || block == Ships.m_blockAirRoof) {
                                airWallBlocks.add(coords);
                            }
                            return BlockUtils.SearchAction.ContinueSearching;
                        }
                    }, new BlockUtils.BlockExplorer(){

                        @Override
                        public boolean shouldExploreBlock(Coords coords) {
                            return true;
                        }
                    }, BlockUtils.Neighbors.Faces);
                }
                for (Coords coords : airWallBlocks) {
                    Block block = sender.func_130014_f_().func_147439_a(coords.x, coords.y, coords.z);
                    if (block == Ships.m_blockAirWall) {
                        sender.func_130014_f_().func_147449_b(coords.x, coords.y, coords.z, Blocks.field_150355_j);
                        continue;
                    }
                    if (block != Ships.m_blockAirRoof) continue;
                    sender.func_130014_f_().func_147449_b(coords.x, coords.y, coords.z, Blocks.field_150350_a);
                }
                CommandShips.replyAllAdmins(sender, String.format("Removed %d air wall blocks.", airWallBlocks.size()));
            }
        }
        ,
        BlockProps("List physical block properties", "<block id name or empty to list overridden blocks>"){

            @Override
            public void process(ICommandSender sender, String[] args) {
                StringBuilder buf = new StringBuilder();
                if (args.length <= 0) {
                    for (Map.Entry<Block, BlockEntry> mapEntry : BlockProperties.overrides()) {
                        if (buf.length() > 0) {
                            buf.append(", ");
                        }
                        buf.append(Block.field_149771_c.func_148750_c((Object)mapEntry.getKey()));
                    }
                } else {
                    String blockId = args[0];
                    Block block = (Block)Block.field_149771_c.func_82594_a(blockId);
                    if (block == Blocks.field_150350_a && !blockId.equals(Block.field_149771_c.func_148750_c((Object)Blocks.field_150350_a))) {
                        buf.append("Unrecognized block: " + blockId);
                    } else {
                        BlockEntry entry = BlockProperties.getEntry(block);
                        buf.append(String.format("%-20s Ovr:%s Mass:%.1f Vol:%.1f WT:%s Ignrd:%s Water:%s", Block.field_149771_c.func_148750_c((Object)block), BlockProperties.isOverridden(block) ? "Y" : "N", entry.mass, entry.displacement, entry.isWatertight ? "Y" : "N", entry.isSeparator ? "Y" : "N", entry.isWater ? "Y" : "N"));
                    }
                }
                CommandShips.reply(sender, buf.toString());
            }
        };

        private String m_description;
        private String m_usage;

        private SubCommand(String description, String usage) {
            this.m_description = description;
            this.m_usage = usage;
        }

        protected static SubCommand get(String commandName) {
            for (SubCommand subCommand : SubCommand.values()) {
                if (!subCommand.name().equalsIgnoreCase(commandName)) continue;
                return subCommand;
            }
            return null;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getUsage() {
            return "/ships " + this.name().toLowerCase() + " " + this.m_usage;
        }

        protected void showCommandDetail(ICommandSender sender, SubCommand subCommand) {
            StringBuilder buf = new StringBuilder();
            buf.append(subCommand.name().toLowerCase());
            buf.append(": ");
            buf.append(subCommand.getDescription());
            buf.append("\n");
            buf.append("Usage: ");
            buf.append(subCommand.getUsage());
            CommandShips.reply(sender, buf.toString());
        }

        public abstract void process(ICommandSender var1, String[] var2);
    }
}

