/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.ships;

import cuchaz.modsShared.blocks.BlockMap;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import cuchaz.ships.BlockStorage;
import cuchaz.ships.ShipConfigurationException;
import cuchaz.ships.ShipDisplacement;
import cuchaz.ships.ShipGeometry;
import cuchaz.ships.ShipType;
import cuchaz.ships.Ships;
import cuchaz.ships.config.BlockProperties;
import java.util.Collection;
import java.util.Map;
import net.minecraft.world.World;

public class BlocksStorage {
    private static final Coords Origin = new Coords(0, 0, 0);
    private BlockMap<BlockStorage> m_blocks = new BlockMap();
    private final BlockStorage m_airBlockStorage = new BlockStorage();
    private ShipGeometry m_geometry = null;
    private ShipDisplacement m_displacement = null;

    public void clear() {
        this.m_blocks.clear();
        this.m_geometry = null;
        this.m_displacement = null;
    }

    public void readFromWorld(World world, Coords originCoords, BlockSet blocks) {
        this.clear();
        for (Coords worldCoords : blocks) {
            BlockStorage storage = new BlockStorage();
            storage.readFromWorld(world, worldCoords);
            Coords relativeCoords = new Coords(worldCoords.x - originCoords.x, worldCoords.y - originCoords.y, worldCoords.z - originCoords.z);
            this.m_blocks.put(relativeCoords, storage);
        }
    }

    public void writeToWorld(World world, Map<Coords, Coords> correspondence) {
        for (Map.Entry entry : this.m_blocks.entrySet()) {
            Coords coordsShip = (Coords)entry.getKey();
            Coords coordsWorld = correspondence.get(coordsShip);
            BlockStorage storage = (BlockStorage)entry.getValue();
            storage.writeToWorld(world, coordsWorld);
        }
    }

    public String dumpBlocks() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : this.m_blocks.entrySet()) {
            Coords coords = (Coords)entry.getKey();
            BlockStorage storage = (BlockStorage)entry.getValue();
            buf.append(String.format("%3d,%3d,%3d %s %4d\n", coords.x, coords.y, coords.z, storage.block.func_149739_a(), storage.meta));
        }
        return buf.toString();
    }

    public ShipGeometry getGeometry() {
        if (this.m_geometry == null) {
            this.m_geometry = new ShipGeometry(new BlockSet((Collection<Coords>)this.m_blocks.keySet()));
        }
        return this.m_geometry;
    }

    public ShipDisplacement getDisplacement() {
        if (this.m_displacement == null) {
            BlockSet watertightBlocks = new BlockSet();
            for (Coords coords : this.m_blocks.keySet()) {
                if (!BlockProperties.isWatertight(this.getBlock((Coords)coords).block)) continue;
                watertightBlocks.add(coords);
            }
            this.m_displacement = new ShipDisplacement(watertightBlocks);
        }
        return this.m_displacement;
    }

    public int getNumBlocks() {
        return this.m_blocks.size();
    }

    public BlockSet coords() {
        return this.m_blocks.blockSet();
    }

    public BlockStorage getBlock(Coords coords) {
        BlockStorage storage = (BlockStorage)this.m_blocks.get(coords);
        if (storage == null) {
            storage = this.m_airBlockStorage;
        }
        return storage;
    }

    public void setBlock(Coords coords, BlockStorage val) {
        this.m_blocks.put(coords, val);
    }

    public BoundingBoxInt getBoundingBox() {
        return this.getGeometry().getEnvelopes().getBoundingBox();
    }

    public ShipType getShipType() {
        return ShipType.getByMeta(this.getShipBlock().meta);
    }

    public BlockStorage getShipBlock() {
        BlockStorage block = (BlockStorage)this.m_blocks.get(Origin);
        if (block == null) {
            throw new ShipConfigurationException("Ship does not have a ship block!");
        }
        if (block.block != Ships.m_blockShip) {
            throw new ShipConfigurationException("Ship origin block is not a ship block!");
        }
        return block;
    }
}

