/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.perf;

public class Timer {
    private String m_name;
    private long m_startTime;
    private long m_stopTime;
    private boolean m_isRunning;

    public Timer() {
        this("Timer");
    }

    public Timer(String name) {
        this.m_name = name;
        this.m_startTime = 0L;
        this.m_stopTime = 0L;
        this.m_isRunning = false;
    }

    public String getName() {
        return this.m_name;
    }

    public long getStartTime() {
        return this.m_startTime;
    }

    public long getStopTime() {
        return this.m_stopTime;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public String toString() {
        return this.m_name + " : " + this.getElapsedTime();
    }

    public void start() {
        this.m_isRunning = true;
        this.m_startTime = this.getTime();
        this.m_stopTime = -1L;
    }

    public void stop() {
        this.m_isRunning = false;
        this.m_stopTime = this.getTime();
    }

    public long getElapsedMilliseconds() {
        if (this.m_isRunning) {
            return this.getTime() - this.m_startTime;
        }
        return this.m_stopTime - this.m_startTime;
    }

    public float getElapsedSeconds() {
        return (float)this.getElapsedMilliseconds() / 1000.0f;
    }

    public float getElapsedMinutes() {
        return (float)this.getElapsedMilliseconds() / 1000.0f / 60.0f;
    }

    public float getElapsedHours() {
        return (float)this.getElapsedMilliseconds() / 1000.0f / 60.0f / 60.0f;
    }

    public String getElapsedTime() {
        float seconds = this.getElapsedSeconds();
        if ((double)seconds < 60.0) {
            return String.format("%.2fs", Float.valueOf(seconds));
        }
        float minutes = this.getElapsedMinutes();
        if (minutes < 60.0f) {
            return String.format("%.2fm", Float.valueOf(minutes));
        }
        float hours = this.getElapsedHours();
        return String.format("%.2fh", Float.valueOf(hours));
    }

    private long getTime() {
        return System.currentTimeMillis();
    }
}

