/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.perf;

import cuchaz.modsShared.perf.ProfilerCounter;
import java.util.HashMap;
import java.util.PriorityQueue;

public class Profiler {
    private static HashMap<String, ProfilerCounter> m_counters;

    public static void start(String name) {
        ProfilerCounter counter = m_counters.get(name);
        if (counter == null) {
            counter = new ProfilerCounter(name);
            m_counters.put(name, counter);
        }
        counter.start();
    }

    public static void stop(String name) {
        ProfilerCounter counter = m_counters.get(name);
        counter.stop();
    }

    public static void stopStart(String stopName, String startName) {
        Profiler.stop(stopName);
        Profiler.start(startName);
    }

    public static void reset() {
        m_counters = new HashMap();
    }

    public static String getReport() {
        ProfilerCounter counter3;
        long totalTime = 0L;
        for (ProfilerCounter counter2 : m_counters.values()) {
            totalTime += counter2.getElapsedMilliseconds();
        }
        for (ProfilerCounter counter2 : m_counters.values()) {
            counter2.setPercentTime(100.0 * (double)counter2.getElapsedMilliseconds() / (double)totalTime);
        }
        PriorityQueue<ProfilerCounter> order = new PriorityQueue<ProfilerCounter>();
        for (ProfilerCounter counter3 : m_counters.values()) {
            order.add(counter3);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Profiling Report:\n");
        counter3 = null;
        while ((counter3 = (ProfilerCounter)order.poll()) != null) {
            buf.append(String.format("%8.2f", (double)counter3.getElapsedMilliseconds() / 1000.0));
            buf.append("s (");
            buf.append(String.format("%6.2f", counter3.getPercentTime()));
            buf.append("%): ");
            buf.append(counter3.getName());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static String getMemoryUsed() {
        long usedBytes = Runtime.getRuntime().totalMemory();
        double usedKibibytes = (double)usedBytes / 1024.0;
        if (usedKibibytes < 1000.0) {
            return String.format("%.2f", usedKibibytes) + "KiB";
        }
        double usedMebibytes = usedKibibytes / 1024.0;
        if (usedMebibytes < 1000.0) {
            return String.format("%.2f", usedMebibytes) + "MiB";
        }
        double usedGibibytes = usedMebibytes / 1024.0;
        return String.format("%.2f", usedGibibytes) + "GiB";
    }

    static {
        Profiler.reset();
    }
}

