/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.math;

import cuchaz.modsShared.math.CompareReal;
import cuchaz.modsShared.math.HashCalculator;
import cuchaz.modsShared.math.Quaternion;
import cuchaz.modsShared.math.Vector3;
import java.io.Serializable;

public class Matrix3
implements Serializable {
    private static final long serialVersionUID = 1400224150777882871L;
    public static final int Dimension = 3;
    public double[][] data = new double[][]{{0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}, {0.0, 0.0, 0.0}};

    public Matrix3() {
    }

    public Matrix3(Matrix3 other) {
        this();
        this.set(other);
    }

    public Matrix3(double a, double b, double c, double d, double e, double f, double g, double h, double i) {
        this();
        this.set(a, b, c, d, e, f, g, h, i);
    }

    public static void getRotation(Matrix3 matrix, Vector3 axis, double angle) {
        Matrix3.getRotation(matrix, axis, Math.cos(angle), Math.sin(angle));
    }

    public static void getRotation(Matrix3 matrix, Vector3 axis, double cos, double sin) {
        assert (CompareReal.eq(axis.getSquaredLength(), 1.0));
        double axx = axis.x * axis.x;
        double ayy = axis.y * axis.y;
        double azz = axis.z * axis.z;
        double axy = axis.x * axis.y;
        double axz = axis.x * axis.z;
        double ayz = axis.y * axis.z;
        double mcos = 1.0 - cos;
        matrix.set((1.0 - axx) * cos + axx, -axis.z * sin + axy * mcos, axis.y * sin + axz * mcos, axis.z * sin + axy * mcos, (1.0 - ayy) * cos + ayy, -axis.x * sin + ayz * mcos, -axis.y * sin + axz * mcos, axis.x * sin + ayz * mcos, (1.0 - azz) * cos + azz);
    }

    public static void getRotation(Matrix3 matrix, Quaternion q) {
        Vector3 axis = new Vector3();
        double angle = q.toAxisAngle(axis);
        Matrix3.getRotation(matrix, axis, angle);
    }

    public static void getRotationByPi(Matrix3 matrix, Vector3 axis) {
        assert (CompareReal.eq(axis.getSquaredLength(), 1.0));
        double axx = axis.x * axis.x;
        double ayy = axis.y * axis.y;
        double azz = axis.z * axis.z;
        double axy = axis.x * axis.y;
        double axz = axis.x * axis.z;
        double ayz = axis.y * axis.z;
        matrix.set(2.0 * axx - 1.0, 2.0 * axy, 2.0 * axz, 2.0 * axy, 2.0 * ayy - 1.0, 2.0 * ayz, 2.0 * axz, 2.0 * ayz, 2.0 * azz - 1.0);
    }

    public static void getOrthogonalProjection(Matrix3 matrix, Vector3 a) {
        assert (CompareReal.eq(a.getSquaredLength(), 1.0));
        double xx = a.x * a.x;
        double xy = a.x * a.y;
        double xz = a.x * a.z;
        double yy = a.y * a.y;
        double yz = a.y * a.z;
        double zz = a.z * a.z;
        matrix.set(1.0 - xx, 0.0 - xy, 0.0 - xz, 0.0 - xy, 1.0 - yy, 0.0 - yz, 0.0 - xz, 0.0 - yz, 1.0 - zz);
    }

    public static void getArbitraryBasisFromZ(Matrix3 out, Vector3 z) {
        Vector3 x = new Vector3();
        Vector3 y = new Vector3();
        z = new Vector3(z);
        z.normalize();
        z.getArbitraryOrthogonal(y);
        y.normalize();
        y.getCross(x, z);
        x.normalize();
        out.setColumns(x, y, z);
    }

    public static void getRightBasisFromXZ(Matrix3 out, Vector3 x, Vector3 z) {
        x = new Vector3(x);
        x.normalize();
        z = new Vector3(z);
        z.normalize();
        Vector3 y = new Vector3();
        z.getCross(y, x);
        z.normalize();
        out.setColumns(x, y, z);
    }

    public static void getRightBasisFromXY(Matrix3 out, Vector3 x, Vector3 y) {
        x = new Vector3(x);
        x.normalize();
        y = new Vector3(y);
        y.normalize();
        Vector3 z = new Vector3();
        x.getCross(z, y);
        z.normalize();
        out.setColumns(x, y, z);
    }

    public static void getRightBasisFromYZ(Matrix3 out, Vector3 y, Vector3 z) {
        y = new Vector3(y);
        y.normalize();
        z = new Vector3(z);
        z.normalize();
        Vector3 x = new Vector3();
        y.getCross(x, z);
        x.normalize();
        out.setColumns(x, y, z);
    }

    public void setRows(Vector3 x, Vector3 y, Vector3 z) {
        this.set(x.x, x.y, x.z, y.x, y.y, y.z, z.x, z.y, z.z);
    }

    public void setColumns(Vector3 x, Vector3 y, Vector3 z) {
        this.set(x.x, y.x, z.x, x.y, y.y, z.y, x.z, y.z, z.z);
    }

    public void set(double a, double b, double c, double d, double e, double f, double g, double h, double i) {
        this.data[0][0] = a;
        this.data[0][1] = b;
        this.data[0][2] = c;
        this.data[1][0] = d;
        this.data[1][1] = e;
        this.data[1][2] = f;
        this.data[2][0] = g;
        this.data[2][1] = h;
        this.data[2][2] = i;
    }

    public void set(Matrix3 other) {
        this.data[0][0] = other.data[0][0];
        this.data[0][1] = other.data[0][1];
        this.data[0][2] = other.data[0][2];
        this.data[1][0] = other.data[1][0];
        this.data[1][1] = other.data[1][1];
        this.data[1][2] = other.data[1][2];
        this.data[2][0] = other.data[2][0];
        this.data[2][1] = other.data[2][1];
        this.data[2][2] = other.data[2][2];
    }

    public void setIdentity() {
        this.set(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public void getXAxis(Vector3 out) {
        this.getAxis(out, 0);
    }

    public void getYAxis(Vector3 out) {
        this.getAxis(out, 1);
    }

    public void getZAxis(Vector3 out) {
        this.getAxis(out, 2);
    }

    public void getAxis(Vector3 out, int i) {
        out.set(this.data[0][i], this.data[1][i], this.data[2][i]);
    }

    public void setAxis(Vector3 in, int i) {
        this.data[0][i] = in.x;
        this.data[1][i] = in.y;
        this.data[2][i] = in.z;
    }

    public void negate() {
        this.data[0][0] = -this.data[0][0];
        this.data[0][1] = -this.data[0][1];
        this.data[0][2] = -this.data[0][2];
        this.data[1][0] = -this.data[1][0];
        this.data[1][1] = -this.data[1][1];
        this.data[1][2] = -this.data[1][2];
        this.data[2][0] = -this.data[2][0];
        this.data[2][1] = -this.data[2][1];
        this.data[2][2] = -this.data[2][2];
    }

    public String toString() {
        return this.data[0][0] + "\t" + this.data[0][1] + "\t" + this.data[0][2] + "\n" + this.data[1][0] + "\t" + this.data[1][1] + "\t" + this.data[1][2] + "\n" + this.data[2][0] + "\t" + this.data[2][1] + "\t" + this.data[2][2];
    }

    public double getDeterminant() {
        return this.data[0][0] * (this.data[1][1] * this.data[2][2] - this.data[1][2] * this.data[2][1]) + this.data[0][1] * (this.data[1][2] * this.data[2][0] - this.data[1][0] * this.data[2][2]) + this.data[0][2] * (this.data[1][0] * this.data[2][1] - this.data[1][1] * this.data[2][0]);
    }

    public void multiply(Vector3 v) {
        v.set(this.data[0][0] * v.x + this.data[0][1] * v.y + this.data[0][2] * v.z, this.data[1][0] * v.x + this.data[1][1] * v.y + this.data[1][2] * v.z, this.data[2][0] * v.x + this.data[2][1] * v.y + this.data[2][2] * v.z);
    }

    public void multiplyRight(Matrix3 out, Matrix3 m) {
        out.set(this.data[0][0] * m.data[0][0] + this.data[0][1] * m.data[1][0] + this.data[0][2] * m.data[2][0], this.data[0][0] * m.data[0][1] + this.data[0][1] * m.data[1][1] + this.data[0][2] * m.data[2][1], this.data[0][0] * m.data[0][2] + this.data[0][1] * m.data[1][2] + this.data[0][2] * m.data[2][2], this.data[1][0] * m.data[0][0] + this.data[1][1] * m.data[1][0] + this.data[1][2] * m.data[2][0], this.data[1][0] * m.data[0][1] + this.data[1][1] * m.data[1][1] + this.data[1][2] * m.data[2][1], this.data[1][0] * m.data[0][2] + this.data[1][1] * m.data[1][2] + this.data[1][2] * m.data[2][2], this.data[2][0] * m.data[0][0] + this.data[2][1] * m.data[1][0] + this.data[2][2] * m.data[2][0], this.data[2][0] * m.data[0][1] + this.data[2][1] * m.data[1][1] + this.data[2][2] * m.data[2][1], this.data[2][0] * m.data[0][2] + this.data[2][1] * m.data[1][2] + this.data[2][2] * m.data[2][2]);
    }

    public void multiplyLeft(Matrix3 out, Matrix3 m) {
        out.set(m.data[0][0] * this.data[0][0] + m.data[0][1] * this.data[1][0] + m.data[0][2] * this.data[2][0], m.data[0][0] * this.data[0][1] + m.data[0][1] * this.data[1][1] + m.data[0][2] * this.data[2][1], m.data[0][0] * this.data[0][2] + m.data[0][1] * this.data[1][2] + m.data[0][2] * this.data[2][2], m.data[1][0] * this.data[0][0] + m.data[1][1] * this.data[1][0] + m.data[1][2] * this.data[2][0], m.data[1][0] * this.data[0][1] + m.data[1][1] * this.data[1][1] + m.data[1][2] * this.data[2][1], m.data[1][0] * this.data[0][2] + m.data[1][1] * this.data[1][2] + m.data[1][2] * this.data[2][2], m.data[2][0] * this.data[0][0] + m.data[2][1] * this.data[1][0] + m.data[2][2] * this.data[2][0], m.data[2][0] * this.data[0][1] + m.data[2][1] * this.data[1][1] + m.data[2][2] * this.data[2][1], m.data[2][0] * this.data[0][2] + m.data[2][1] * this.data[1][2] + m.data[2][2] * this.data[2][2]);
    }

    public void multiply(Matrix3 basis) {
        for (int i = 0; i < 3; ++i) {
            Vector3 axis = new Vector3();
            basis.getAxis(axis, i);
            this.multiply(axis);
            basis.setAxis(axis, i);
        }
    }

    public void transpose() {
        double swap = 0.0;
        swap = this.data[0][1];
        this.data[0][1] = this.data[1][0];
        this.data[1][0] = swap;
        swap = this.data[0][2];
        this.data[0][2] = this.data[2][0];
        this.data[2][0] = swap;
        swap = this.data[1][2];
        this.data[1][2] = this.data[2][1];
        this.data[2][1] = swap;
    }

    public int hashCode() {
        return HashCalculator.combineHashes(Double.valueOf(this.data[0][0]).hashCode(), Double.valueOf(this.data[0][1]).hashCode(), Double.valueOf(this.data[0][2]).hashCode(), Double.valueOf(this.data[1][0]).hashCode(), Double.valueOf(this.data[1][1]).hashCode(), Double.valueOf(this.data[1][2]).hashCode(), Double.valueOf(this.data[2][0]).hashCode(), Double.valueOf(this.data[2][1]).hashCode(), Double.valueOf(this.data[2][2]).hashCode());
    }

    public boolean equals(Object other) {
        if (other instanceof Matrix3) {
            return this.equals((Matrix3)other);
        }
        return false;
    }

    public boolean equals(Matrix3 other) {
        return this.data[0][0] == other.data[0][0] && this.data[0][1] == other.data[0][1] && this.data[0][2] == other.data[0][2] && this.data[1][0] == other.data[1][0] && this.data[1][1] == other.data[1][1] && this.data[1][2] == other.data[1][2] && this.data[2][0] == other.data[2][0] && this.data[2][1] == other.data[2][1] && this.data[2][2] == other.data[2][2];
    }
}

