/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.math;

import cuchaz.modsShared.math.CompareReal;
import cuchaz.modsShared.math.HashCalculator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CircleRange
implements Comparable<CircleRange>,
Serializable {
    private static final long serialVersionUID = 3905814480659132660L;
    private static final double TwoPi = Math.PI * 2;
    private double m_offset;
    private double m_length;
    private boolean m_isCircle;

    private CircleRange() {
    }

    public CircleRange(CircleRange other) {
        this.m_offset = other.m_offset;
        this.m_length = other.m_length;
        this.m_isCircle = other.m_isCircle;
    }

    public double getSource() {
        return this.m_offset;
    }

    public double getTarget() {
        return CircleRange.mapMinusPiToPi(this.m_offset + this.m_length);
    }

    public double getMidpoint() {
        return CircleRange.mapMinusPiToPi(this.m_offset + this.m_length / 2.0);
    }

    public boolean isCircle() {
        return this.m_isCircle;
    }

    public double getLength() {
        return this.m_length;
    }

    public boolean includesPi() {
        return CompareReal.gte(this.m_offset + this.m_length, Math.PI);
    }

    public static CircleRange newByPoint(double point) {
        CircleRange range = new CircleRange();
        range.m_offset = CircleRange.mapMinusPiToPi(point);
        range.m_length = 0.0;
        range.m_isCircle = false;
        return range;
    }

    public static CircleRange newByOffset(double offset, double length) {
        CircleRange range = new CircleRange();
        range.m_offset = CircleRange.mapMinusPiToPi(offset);
        range.m_length = Math.min(length, Math.PI * 2);
        range.m_isCircle = length >= Math.PI * 2;
        return range;
    }

    public static CircleRange newByShortSegment(double start, double stop) {
        start = CircleRange.mapMinusPiToPi(start);
        stop = CircleRange.mapMinusPiToPi(stop);
        double max = 0.0;
        double min = 0.0;
        if (start > stop) {
            max = start;
            min = stop;
        } else if (stop > start) {
            max = stop;
            min = start;
        } else {
            return CircleRange.newByPoint(start);
        }
        CircleRange range = new CircleRange();
        range.m_isCircle = false;
        if (max - min < Math.PI) {
            range.m_offset = min;
            range.m_length = max - min;
        } else {
            range.m_offset = max;
            range.m_length = Math.PI * 2 - (max - min);
        }
        return range;
    }

    public static CircleRange newByCounterclockwiseSegment(double source, double target) {
        source = CircleRange.mapMinusPiToPi(source);
        target = CircleRange.mapMinusPiToPi(target);
        CircleRange range = new CircleRange();
        range.m_offset = source;
        range.m_length = target >= source ? target - source : Math.PI * 2 + (target - source);
        range.m_isCircle = false;
        return range;
    }

    public static CircleRange newByThreePoints(double source, double target, double interior) {
        source = CircleRange.mapMinusPiToPi(source);
        target = CircleRange.mapMinusPiToPi(target);
        interior = CircleRange.mapMinusPiToPi(interior);
        CircleRange range = null;
        if (source == target) {
            range = new CircleRange();
            if (source == interior) {
                range.m_isCircle = false;
                range.m_offset = source;
                range.m_length = 0.0;
            } else {
                range.m_isCircle = true;
                range.m_offset = source;
                range.m_length = Math.PI * 2;
            }
        } else {
            range = CircleRange.newByCounterclockwiseSegment(source, target);
            if (!range.containsPoint(interior)) {
                range = CircleRange.newByCounterclockwiseSegment(target, source);
            }
            assert (range.containsPoint(interior));
        }
        return range;
    }

    public static CircleRange newCircle() {
        CircleRange range = new CircleRange();
        range.setCircle();
        return range;
    }

    public static double mapMinusPiToPi(double angle) {
        while (angle > Math.PI) {
            angle -= Math.PI * 2;
        }
        while (angle <= -Math.PI) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static double mapZeroToTwoPi(double angle) {
        while (angle >= Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        while (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle;
    }

    public static float mapZeroTo360(float angle) {
        while (angle >= 360.0f) {
            angle -= 360.0f;
        }
        while (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static boolean isEq(double a, double b) {
        return CircleRange.isEq(a, b, CompareReal.getEpsilon());
    }

    public static boolean isEq(double a, double b, double epsilon) {
        return CompareReal.eq(a = CircleRange.mapZeroToTwoPi(a), b = CircleRange.mapZeroToTwoPi(b), epsilon) || CompareReal.eq(a, 0.0, epsilon) && CompareReal.eq(b, Math.PI * 2, epsilon) || CompareReal.eq(b, 0.0, epsilon) && CompareReal.eq(a, Math.PI * 2, epsilon);
    }

    public void merge(CircleRange other) {
        if (this.m_isCircle) {
            return;
        }
        if (other.m_isCircle) {
            this.setCircle();
        }
        if (!this.isIntersecting(other)) {
            throw new IllegalArgumentException("The two ranges do not intersect!");
        }
        double otherOffset = CircleRange.mapZeroToTwoPi(other.m_offset - this.m_offset);
        if (CompareReal.lte(otherOffset, this.m_length)) {
            this.m_length = Math.max(this.m_length, other.m_length + otherOffset);
            if (this.m_length > Math.PI * 2) {
                this.setCircle();
            }
        } else {
            double upstreamDiff = Math.PI * 2 - otherOffset;
            double downstreamDiff = other.m_length - upstreamDiff - this.m_length;
            this.m_length += upstreamDiff + Math.max(downstreamDiff, 0.0);
            this.m_offset = CircleRange.mapMinusPiToPi(this.m_offset - upstreamDiff);
        }
    }

    public boolean isIntersecting(CircleRange other) {
        if (this.m_isCircle || other.m_isCircle) {
            return true;
        }
        return this.containsPoint(other.getSource()) || this.containsPoint(other.getTarget()) || other.containsPoint(this.getSource()) || other.containsPoint(this.getTarget());
    }

    public boolean isIntersectingOnlyOnBoundary(CircleRange other) {
        if (this.m_isCircle || other.m_isCircle) {
            return false;
        }
        if (CompareReal.eq(this.getTarget(), other.getSource())) {
            return this.m_length == 0.0 || other.m_length == 0.0 || !this.containsPoint(other.getTarget()) || !other.containsPoint(this.getSource());
        }
        if (CompareReal.eq(this.getSource(), other.getTarget())) {
            return this.m_length == 0.0 || other.m_length == 0.0 || !this.containsPoint(other.getSource()) || !other.containsPoint(this.getTarget());
        }
        return false;
    }

    public boolean containsPoint(double point) {
        return this.containsPoint(point, CompareReal.getEpsilon());
    }

    public boolean containsPoint(double point, double epsilon) {
        if (this.m_isCircle) {
            return true;
        }
        return CompareReal.lte(point = CircleRange.mapZeroToTwoPi(CircleRange.mapZeroToTwoPi(point) - CircleRange.mapZeroToTwoPi(this.m_offset)), this.m_length, epsilon) && CompareReal.gte(point, 0.0, epsilon) || CompareReal.eq(point, Math.PI * 2, epsilon);
    }

    public boolean containsPointOnBoundary(double point) {
        return this.containsPointOnBoundary(point, CompareReal.getEpsilon());
    }

    public boolean containsPointOnBoundary(double point, double epsilon) {
        if (this.m_isCircle) {
            return false;
        }
        return CompareReal.eq(point = CircleRange.mapZeroToTwoPi(CircleRange.mapZeroToTwoPi(point) - CircleRange.mapZeroToTwoPi(this.m_offset)), this.m_length, epsilon) || CompareReal.eq(point, 0.0, epsilon) || CompareReal.eq(point, Math.PI * 2, epsilon);
    }

    public boolean containsPointOnInterior(double point) {
        return this.containsPointOnInterior(point, CompareReal.getEpsilon());
    }

    public boolean containsPointOnInterior(double point, double epsilon) {
        if (this.m_isCircle) {
            return true;
        }
        return this.containsPoint(point, epsilon) && !this.containsPointOnBoundary(point, epsilon);
    }

    @Override
    public int compareTo(CircleRange other) {
        return Double.compare(this.m_offset, other.m_offset);
    }

    public boolean equals(Object other) {
        if (!(other instanceof CircleRange)) {
            return false;
        }
        return this.equals((CircleRange)other);
    }

    public boolean equals(CircleRange other) {
        if (this.m_isCircle && other.m_isCircle) {
            return true;
        }
        if (this.m_isCircle != other.m_isCircle) {
            return false;
        }
        return this.m_offset == other.m_offset && this.m_length == other.m_length;
    }

    public boolean approximatelyEquals(CircleRange other) {
        return this.approximatelyEquals(other, CompareReal.getEpsilon());
    }

    public boolean approximatelyEquals(CircleRange other, double epsilon) {
        if (this.m_isCircle && other.m_isCircle) {
            return true;
        }
        if (this.m_isCircle != other.m_isCircle) {
            return false;
        }
        double point = CircleRange.mapZeroToTwoPi(other.m_offset - this.m_offset);
        return CompareReal.eq(this.m_length, other.m_length, epsilon) && (CompareReal.eq(point, 0.0, epsilon) || CompareReal.eq(point, Math.PI * 2, epsilon));
    }

    public String toString() {
        if (this.m_isCircle) {
            return "[Circle]";
        }
        return String.format("[%.1f,%.1f]", Math.toDegrees(this.getSource()), Math.toDegrees(this.getTarget()));
    }

    public List<Double> samplePoints(double stepSize) {
        int numSamples = Math.max(2, (int)(this.m_length / stepSize));
        return this.samplePoints(numSamples);
    }

    public List<Double> samplePoints(int numSamples) {
        ArrayList<Double> points = new ArrayList<Double>();
        for (int i = 0; i < numSamples; ++i) {
            double t = this.m_offset + this.m_length * (double)i / (double)(numSamples - 1);
            points.add(CircleRange.mapMinusPiToPi(t));
        }
        assert (CircleRange.isEq((Double)points.get(0), this.getSource()));
        assert (CircleRange.isEq((Double)points.get(points.size() - 1), this.getTarget()));
        return points;
    }

    public List<CircleRange> split(double theta) {
        if (!this.containsPointOnInterior(theta, 1.0E-6)) {
            throw new IllegalArgumentException("theta must be on the interior of the range!");
        }
        theta = CircleRange.mapMinusPiToPi(theta);
        ArrayList<CircleRange> ranges = new ArrayList<CircleRange>();
        ranges.add(CircleRange.newByCounterclockwiseSegment(this.getSource(), theta));
        ranges.add(CircleRange.newByCounterclockwiseSegment(theta, this.getTarget()));
        double sum = 0.0;
        for (CircleRange range : ranges) {
            sum += range.m_length;
        }
        assert (CompareReal.eq(this.m_length, sum));
        return ranges;
    }

    public void rotate(double rotationAngle) {
        this.m_offset += rotationAngle;
        this.m_offset = CircleRange.mapMinusPiToPi(this.m_offset);
    }

    public double getDistance(double theta) {
        if (this.m_isCircle) {
            return 0.0;
        }
        theta = CircleRange.mapZeroToTwoPi(CircleRange.mapZeroToTwoPi(theta) - CircleRange.mapZeroToTwoPi(this.m_offset));
        return Math.max(0.0, Math.min(theta - this.m_length, Math.PI * 2 - theta));
    }

    public int hashCode() {
        return HashCalculator.combineHashes(Double.valueOf(this.m_offset).hashCode(), Double.valueOf(this.m_length).hashCode());
    }

    private void setCircle() {
        this.m_isCircle = true;
        this.m_offset = 0.0;
        this.m_length = Math.PI * 2;
    }
}

