/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.gui;

import cuchaz.modsShared.ColorUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBase
extends GuiScreen {
    public static final int LeftMargin = 8;
    public static final int TopMargin = 6;
    public static final int LineSpacing = 2;
    public final int TextColor = ColorUtils.getGrey(64);
    public final int HeaderColor = ColorUtils.getColor(50, 99, 145);
    public final int HeaderBevelColor = ColorUtils.getColor(213, 223, 239);
    public final int YesColor = ColorUtils.getColor(0, 160, 0);
    public final int NoColor = ColorUtils.getColor(160, 0, 0);
    private int m_left;
    private int m_top;
    protected int m_width;
    protected int m_height;
    protected ResourceLocation m_background;
    private boolean m_darkenScreen;

    protected GuiBase(int width, int height, ResourceLocation background, boolean darkenScreen) {
        this.m_width = width;
        this.m_height = height;
        this.m_background = background;
        this.m_darkenScreen = darkenScreen;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.setPos((this.field_146294_l - this.m_width) / 2, (this.field_146295_m - this.m_height) / 2);
    }

    protected void setPos(int left, int top) {
        this.m_left = left;
        this.m_top = top;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTickTime) {
        if (this.m_darkenScreen) {
            this.func_146276_q_();
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.m_left, (float)this.m_top, (float)0.0f);
        this.drawBackground(mouseX, mouseY, partialTickTime);
        GL11.glPopMatrix();
        super.func_73863_a(mouseX, mouseY, partialTickTime);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.m_left, (float)this.m_top, (float)0.0f);
        this.drawForeground(mouseX, mouseY, partialTickTime);
        GL11.glPopMatrix();
    }

    protected void bindBackgroundTexture() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.m_background);
    }

    protected void drawBackground(int mouseX, int mouseY, float partialTickTime) {
        this.bindBackgroundTexture();
        this.func_73729_b(0, 0, 0, 0, this.m_width, this.m_height);
    }

    protected void drawForeground(int mouseX, int mouseY, float partialTickTime) {
    }

    protected void drawHeaderText(String text, int lineNum) {
        int x1 = 8;
        int x2 = this.m_width - 8;
        int y1 = this.getLineY(lineNum);
        int y2 = y1 + this.field_146297_k.field_71466_p.field_78288_b;
        this.func_73730_a(x1 - 1, x2 - 1, y2 - 2, this.HeaderBevelColor);
        this.field_146297_k.field_71466_p.func_78276_b(text, x1 - 1, y1 - 1, this.HeaderBevelColor);
        this.func_73730_a(x1, x2, y2 - 1, this.HeaderColor);
        this.field_146297_k.field_71466_p.func_78276_b(text, x1, y1, this.HeaderColor);
    }

    protected void drawText(String text, int lineNum) {
        this.drawText(text, lineNum, this.TextColor);
    }

    protected void drawText(String text, int lineNum, int color) {
        this.field_146297_k.field_71466_p.func_78276_b(text, 8, this.getLineY(lineNum), color);
    }

    protected void drawWrappedText(String text, int lineNum, int width) {
        this.field_146297_k.field_71466_p.func_78279_b(text, 8, this.getLineY(lineNum), this.m_width, this.TextColor);
    }

    protected void drawLabelValueText(String labelText, String valueText, int lineNum) {
        this.field_146297_k.field_71466_p.func_78276_b(labelText + ":", 8, this.getLineY(lineNum), this.TextColor);
        int valueWidth = this.field_146297_k.field_71466_p.func_78256_a(valueText);
        this.field_146297_k.field_71466_p.func_78276_b(valueText, this.m_width - 8 - valueWidth, this.getLineY(lineNum), this.TextColor);
    }

    protected void drawYesNoText(String labelText, String valueText, boolean isYes, int lineNum) {
        this.field_146297_k.field_71466_p.func_78276_b(labelText + ":", 8, this.getLineY(lineNum), this.TextColor);
        int valueColor = isYes ? this.YesColor : this.NoColor;
        int valueWidth = this.field_146297_k.field_71466_p.func_78256_a(valueText);
        this.field_146297_k.field_71466_p.func_78276_b(valueText, this.m_width - 8 - valueWidth, this.getLineY(lineNum), valueColor);
    }

    protected int getLineY(int lineNum) {
        return 6 + (this.field_146297_k.field_71466_p.field_78288_b + 2) * lineNum;
    }

    public void close() {
        this.field_146297_k.field_71439_g.func_71053_j();
        this.field_146297_k.func_71381_h();
    }

    protected GuiButton newGuiButton(int id, int left, int top, int width, int height, String text) {
        return new GuiButton(id, this.m_left + left, this.m_top + top, width, height, text);
    }
}

