/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.blocks;

import cuchaz.modsShared.blocks.BlockArray;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class Envelopes {
    private Map<BlockSide, BlockArray> m_envelopes;
    private BoundingBoxInt m_boundingBox;

    public Envelopes(Set<Coords> blocks) {
        this.m_boundingBox = new BoundingBoxInt(blocks);
        this.m_envelopes = new TreeMap<BlockSide, BlockArray>();
        for (BlockSide side : BlockSide.values()) {
            BlockArray surface = new BlockArray(side.getU(this.m_boundingBox.minX, this.m_boundingBox.minY, this.m_boundingBox.minZ), side.getV(this.m_boundingBox.minX, this.m_boundingBox.minY, this.m_boundingBox.minZ), side.getWidth(this.m_boundingBox.getDx(), this.m_boundingBox.getDy(), this.m_boundingBox.getDz()), side.getHeight(this.m_boundingBox.getDx(), this.m_boundingBox.getDy(), this.m_boundingBox.getDz()));
            for (int u = surface.getUMin(); u <= surface.getUMax(); ++u) {
                for (int v = surface.getVMin(); v <= surface.getVMax(); ++v) {
                    surface.setBlock(u, v, null);
                }
            }
            this.m_envelopes.put(side, surface);
        }
        for (Coords coords : blocks) {
            for (BlockSide side : BlockSide.values()) {
                int v;
                int u;
                BlockArray surface = this.m_envelopes.get((Object)side);
                Coords extremalCoords = surface.getBlock(u = side.getU(coords.x, coords.y, coords.z), v = side.getV(coords.x, coords.y, coords.z));
                if (extremalCoords != null && !side.isMoreExtremal(coords, extremalCoords)) continue;
                surface.setBlock(u, v, coords);
            }
        }
    }

    public BoundingBoxInt getBoundingBox() {
        return this.m_boundingBox;
    }

    public BlockArray getEnvelope(BlockSide side) {
        return this.m_envelopes.get((Object)side);
    }
}

