/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.blocks;

import cuchaz.modsShared.blocks.Coords;
import java.util.Set;
import net.minecraft.util.AxisAlignedBB;

public class BoundingBoxInt {
    public int minX;
    public int maxX;
    public int minY;
    public int maxY;
    public int minZ;
    public int maxZ;

    public BoundingBoxInt() {
        this.minX = Integer.MAX_VALUE;
        this.maxX = Integer.MIN_VALUE;
        this.minY = Integer.MAX_VALUE;
        this.maxY = Integer.MIN_VALUE;
        this.minZ = Integer.MAX_VALUE;
        this.maxZ = Integer.MIN_VALUE;
    }

    public BoundingBoxInt(Set<Coords> blocks) {
        this();
        for (Coords coords : blocks) {
            this.expandBoxToInclude(coords.x, coords.y, coords.z);
        }
    }

    public BoundingBoxInt(BoundingBoxInt other) {
        this.minX = other.minX;
        this.minY = other.minY;
        this.minZ = other.minZ;
        this.maxX = other.maxX;
        this.maxY = other.maxY;
        this.maxZ = other.maxZ;
    }

    public void expandBoxToInclude(int x, int y, int z) {
        this.minX = Math.min(this.minX, x);
        this.maxX = Math.max(this.maxX, x);
        this.minY = Math.min(this.minY, y);
        this.maxY = Math.max(this.maxY, y);
        this.minZ = Math.min(this.minZ, z);
        this.maxZ = Math.max(this.maxZ, z);
    }

    public int getDx() {
        return this.maxX - this.minX + 1;
    }

    public int getDy() {
        return this.maxY - this.minY + 1;
    }

    public int getDz() {
        return this.maxZ - this.minZ + 1;
    }

    public boolean containsPoint(Coords coords) {
        return this.containsPoint(coords.x, coords.y, coords.z);
    }

    public boolean containsPoint(int x, int y, int z) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public int getVolume() {
        return this.getDx() * this.getDy() * this.getDz();
    }

    public void toAxisAlignedBB(AxisAlignedBB out) {
        out.field_72340_a = this.minX;
        out.field_72338_b = this.minY;
        out.field_72339_c = this.minZ;
        out.field_72336_d = this.maxX + 1;
        out.field_72337_e = this.maxY + 1;
        out.field_72334_f = this.maxZ + 1;
    }

    public String toString() {
        return String.format("[%d,%d]x[%d,%d]x[%d,%d]", this.minX, this.maxX, this.minY, this.maxY, this.minZ, this.maxZ);
    }
}

