/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.modsShared.blocks;

import cuchaz.modsShared.Environment;
import cuchaz.modsShared.Log;
import cuchaz.modsShared.blocks.BlockSet;
import cuchaz.modsShared.blocks.BlockSide;
import cuchaz.modsShared.blocks.BoundingBoxInt;
import cuchaz.modsShared.blocks.Coords;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BlockUtils {
    private static Field m_chunkPrecipitationHeightMapField;
    private static Field m_chunkHeightMapField;
    private static Field m_chunkStorageArraysField;
    private static Field m_chunkIsModifiedField;
    private static Method m_chunkRelightBlockMethod;
    private static Method m_chunkPropagateSkylightOcclusionMethod;

    public static int getManhattanDistance(Coords a, Coords b) {
        return BlockUtils.getManhattanDistance(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    public static int getManhattanDistance(int ax, int ay, int az, Coords b) {
        return BlockUtils.getManhattanDistance(ax, ay, az, b.x, b.y, b.z);
    }

    public static int getManhattanDistance(Coords a, int bx, int by, int bz) {
        return BlockUtils.getManhattanDistance(a.x, a.y, a.z, bx, by, bz);
    }

    public static int getManhattanDistance(int ax, int ay, int az, int bx, int by, int bz) {
        return Math.abs(ax - bx) + Math.abs(ay - by) + Math.abs(az - bz);
    }

    public static int getXZManhattanDistance(Coords a, Coords b) {
        return BlockUtils.getXZManhattanDistance(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    public static int getXZManhattanDistance(int ax, int ay, int az, Coords b) {
        return BlockUtils.getXZManhattanDistance(ax, ay, az, b.x, b.y, b.z);
    }

    public static int getXZManhattanDistance(Coords a, int bx, int by, int bz) {
        return BlockUtils.getXZManhattanDistance(a.x, a.y, a.z, bx, by, bz);
    }

    public static int getXZManhattanDistance(int ax, int ay, int az, int bx, int by, int bz) {
        return Math.abs(ax - bx) + Math.abs(az - bz);
    }

    public static BlockSet searchForBlocks(int x, int y, int z, int maxNumBlocks, BlockExplorer explorer, Neighbors neighbors) {
        return BlockUtils.searchForBlocks(new Coords(x, y, z), maxNumBlocks, explorer, neighbors);
    }

    public static BlockSet searchForBlocks(final Coords source, int maxNumBlocks, BlockExplorer explorer, Neighbors neighbors) {
        final BlockSet foundBlocks = new BlockSet();
        BlockUtils.exploreBlocks(source, maxNumBlocks, new BlockCallback(){

            @Override
            public SearchAction foundBlock(Coords coords) {
                if (!coords.equals(source)) {
                    foundBlocks.add(coords);
                }
                return SearchAction.ContinueSearching;
            }
        }, explorer, neighbors);
        return foundBlocks;
    }

    public static Boolean searchForCondition(int x, int y, int z, int maxNumBlocks, BlockConditionChecker checker, BlockExplorer explorer, Neighbors neighbors) {
        return BlockUtils.searchForCondition(new Coords(x, y, z), maxNumBlocks, checker, explorer, neighbors);
    }

    public static Boolean searchForCondition(Coords source, int maxNumBlocks, BlockConditionChecker checker, BlockExplorer explorer, Neighbors neighbors) {
        return BlockUtils.searchForBlock(source, maxNumBlocks, checker, explorer, neighbors) != null;
    }

    public static Coords searchForBlock(int x, int y, int z, int maxNumBlocks, BlockConditionChecker checker, BlockExplorer explorer, Neighbors neighbors) {
        return BlockUtils.searchForBlock(new Coords(x, y, z), maxNumBlocks, checker, explorer, neighbors);
    }

    public static Coords searchForBlock(final Coords source, int maxNumBlocks, final BlockConditionChecker checker, BlockExplorer explorer, Neighbors neighbors) {
        final Coords[] outCoords = new Coords[]{null};
        BlockUtils.exploreBlocks(source, maxNumBlocks, new BlockCallback(){

            @Override
            public SearchAction foundBlock(Coords coords) {
                if (!coords.equals(source) && checker.isConditionMet(coords)) {
                    outCoords[0] = coords;
                    return SearchAction.AbortSearch;
                }
                return SearchAction.ContinueSearching;
            }
        }, explorer, neighbors);
        return outCoords[0];
    }

    public static void exploreBlocks(Coords source, int maxNumBlocks, BlockCallback callback, BlockExplorer explorer, Neighbors neighbors) {
        Coords coords;
        ArrayDeque<Coords> queue = new ArrayDeque<Coords>();
        BlockSet visitedBlocks = new BlockSet();
        queue.add(source);
        visitedBlocks.add(source);
        Coords neighborCoords = new Coords(0, 0, 0);
        while (!queue.isEmpty() && visitedBlocks.size() <= maxNumBlocks && callback.foundBlock(coords = (Coords)queue.poll()) != SearchAction.AbortSearch) {
            for (int i = 0; i < neighbors.getNumNeighbors(); ++i) {
                neighbors.getNeighbor(neighborCoords, coords, i);
                if (visitedBlocks.contains(neighborCoords) || !explorer.shouldExploreBlock(neighborCoords)) continue;
                Coords coordsToAdd = new Coords(neighborCoords);
                visitedBlocks.add(coordsToAdd);
                queue.add(coordsToAdd);
            }
        }
    }

    public static List<BlockSet> getConnectedComponents(BlockSet blocks, Neighbors neighbors) {
        ArrayList<BlockSet> components = new ArrayList<BlockSet>();
        final BlockSet remainingBlocks = new BlockSet(blocks);
        while (!remainingBlocks.isEmpty()) {
            Coords coords = (Coords)remainingBlocks.iterator().next();
            BlockSet component = new BlockSet(BlockUtils.searchForBlocks(coords, remainingBlocks.size(), new BlockExplorer(){

                @Override
                public boolean shouldExploreBlock(Coords coords) {
                    return remainingBlocks.contains(coords);
                }
            }, neighbors));
            component.add(coords);
            remainingBlocks.removeAll(component);
            components.add(component);
        }
        return components;
    }

    public static BlockSet getBlocksAtYAndBelow(BlockSet inBlocks, int y) {
        BlockSet outBlocks = new BlockSet();
        for (Coords coords : inBlocks) {
            if (coords.y > y) continue;
            outBlocks.add(coords);
        }
        return outBlocks;
    }

    public static BlockSet getBoundary(BlockSet blocks, Neighbors neighbors) {
        BlockSet boundary = new BlockSet();
        Coords neighborCoords = new Coords(0, 0, 0);
        for (Coords coords : blocks) {
            for (int i = 0; i < neighbors.getNumNeighbors(); ++i) {
                neighbors.getNeighbor(neighborCoords, coords, i);
                if (blocks.contains(neighborCoords)) continue;
                boundary.add(new Coords(neighborCoords));
            }
        }
        return boundary;
    }

    public static BlockSet getHoleFromInnerBoundary(BlockSet innerBoundary, BlockSet blocks, Neighbors neighbors) {
        return BlockUtils.getHoleFromInnerBoundary(innerBoundary, blocks, neighbors, null, null);
    }

    public static BlockSet getHoleFromInnerBoundary(BlockSet innerBoundary, BlockSet blocks, Neighbors neighbors, Integer yMax) {
        return BlockUtils.getHoleFromInnerBoundary(innerBoundary, blocks, neighbors, null, yMax);
    }

    public static BlockSet getHoleFromInnerBoundary(BlockSet innerBoundary, final BlockSet blocks, Neighbors neighbors, final Integer yMin, final Integer yMax) {
        BoundingBoxInt box = new BoundingBoxInt(blocks);
        int volume = box.getVolume();
        Coords sourceBlock = (Coords)innerBoundary.iterator().next();
        BlockSet holeBlocks = BlockUtils.searchForBlocks(sourceBlock, volume, new BlockExplorer(){

            @Override
            public boolean shouldExploreBlock(Coords coords) {
                return !(blocks.contains(coords) || yMin != null && coords.y < yMin || yMax != null && coords.y > yMax);
            }
        }, neighbors);
        if (holeBlocks == null) {
            throw new Error("Found too many enclosed blocks!");
        }
        holeBlocks.add(sourceBlock);
        return new BlockSet(holeBlocks);
    }

    public static boolean removeBlockWithoutNotifyingIt(World world, int x, int y, int z) {
        return BlockUtils.removeBlockWithoutNotifyingIt(world, x, y, z, UpdateRules.UpdateNeighborsAndClients);
    }

    public static boolean removeBlockWithoutNotifyingIt(World world, int x, int y, int z, UpdateRules updateRules) {
        return BlockUtils.changeBlockWithoutNotifyingIt(world, x, y, z, Blocks.field_150350_a, 0, updateRules);
    }

    public static boolean changeBlockWithoutNotifyingIt(World world, int x, int y, int z, Block targetBlock, int targetBlockMeta) {
        return BlockUtils.changeBlockWithoutNotifyingIt(world, x, y, z, targetBlock, targetBlockMeta, UpdateRules.UpdateNeighborsAndClients);
    }

    public static boolean changeBlockWithoutNotifyingIt(World world, int x, int y, int z, Block targetBlock, int targetBlockMeta, UpdateRules updateRules) {
        if (y < 0 || y >= world.func_72940_L()) {
            return false;
        }
        try {
            ExtendedBlockStorage extendedblockstorage;
            TileEntity tileEntity;
            int mx = x & 0xF;
            int my = y & 0xF;
            int mz = z & 0xF;
            Chunk chunk = world.func_72938_d(x, z);
            Block oldBlock = chunk.func_150810_a(mx, y, mz);
            int oldBlockMeta = chunk.func_76628_c(mx, y, mz);
            if (oldBlock == targetBlock) {
                if (oldBlockMeta != targetBlockMeta) {
                    Log.logger.warning(String.format("Ignoring block metadata change for block %s at (%d,%d,%d)", oldBlock.func_149739_a(), x, y, z));
                }
                return false;
            }
            ExtendedBlockStorage[] storageArrays = (ExtendedBlockStorage[])m_chunkStorageArraysField.get(chunk);
            int[] precipitationHeightMap = (int[])m_chunkPrecipitationHeightMapField.get(chunk);
            int[] heightMap = (int[])m_chunkHeightMapField.get(chunk);
            int heightMapIndex = mz << 4 | mx;
            if (y >= precipitationHeightMap[heightMapIndex] - 1) {
                precipitationHeightMap[heightMapIndex] = -999;
            }
            int height = heightMap[heightMapIndex];
            if (oldBlock != Blocks.field_150350_a && oldBlock.hasTileEntity(oldBlockMeta) && (tileEntity = chunk.getTileEntityUnsafe(mx, y, mz)) != null) {
                tileEntity.func_145843_s();
                chunk.func_150805_f(mx, y, mz);
            }
            if ((extendedblockstorage = storageArrays[y >> 4]) == null) {
                storageArrays[y >> 4] = extendedblockstorage = new ExtendedBlockStorage(y >> 4 << 4, !world.field_73011_w.field_76576_e);
            }
            extendedblockstorage.func_150818_a(mx, my, mz, targetBlock);
            extendedblockstorage.func_76654_b(mx, my, mz, targetBlockMeta);
            if (chunk.func_150808_b(mx, y, mz) > 0) {
                if (y >= height) {
                    m_chunkRelightBlockMethod.invoke((Object)chunk, mx, y + 1, mz);
                }
            } else if (y == height - 1) {
                m_chunkRelightBlockMethod.invoke((Object)chunk, mx, y, mz);
            }
            m_chunkPropagateSkylightOcclusionMethod.invoke((Object)chunk, mx, mz);
            world.func_147451_t(x, y, z);
            m_chunkIsModifiedField.setBoolean(chunk, true);
            if (updateRules.shouldUpdateNeighbors() && Environment.isServer()) {
                world.func_147444_c(x, y, z, oldBlock);
            }
            if (updateRules.shouldUpdateClients()) {
                world.func_147471_g(x, y, z);
            }
            return true;
        }
        catch (IllegalAccessException ex) {
            throw new Error("Unable to remove block! Chunk method call failed!", ex);
        }
        catch (SecurityException ex) {
            throw new Error("Unable to remove block! Chunk method call failed!", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new Error("Unable to remove block! Chunk method call failed!", ex);
        }
        catch (InvocationTargetException ex) {
            throw new Error("Unable to remove block! Chunk method call failed!", ex);
        }
    }

    public static void getWorldCollisionBoxes(List<AxisAlignedBB> out, World world, AxisAlignedBB queryBox) {
        int minX = MathHelper.func_76128_c((double)queryBox.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)queryBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)queryBox.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)queryBox.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)queryBox.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)queryBox.field_72334_f);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null) continue;
                    block.func_149743_a(world, x, y, z, queryBox, out, null);
                }
            }
        }
    }

    public static void worldRangeQuery(Collection<Coords> out, World world, AxisAlignedBB queryBox) {
        BlockUtils.worldRangeQuery(out, world, queryBox, false);
    }

    public static void worldRangeQuery(Collection<Coords> out, World world, AxisAlignedBB queryBox, boolean includeAir) {
        int minX = MathHelper.func_76128_c((double)queryBox.field_72340_a);
        int maxX = MathHelper.func_76128_c((double)queryBox.field_72336_d);
        int minY = MathHelper.func_76128_c((double)queryBox.field_72338_b);
        int maxY = MathHelper.func_76128_c((double)queryBox.field_72337_e);
        int minZ = MathHelper.func_76128_c((double)queryBox.field_72339_c);
        int maxZ = MathHelper.func_76128_c((double)queryBox.field_72334_f);
        minY = Math.max(minY, 0);
        maxY = Math.min(maxY, world.func_72940_L());
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    if (!includeAir && world.func_147439_a(x, y, z) == Blocks.field_150350_a) continue;
                    out.add(new Coords(x, y, z));
                }
            }
        }
    }

    public static boolean isConnectedToShell(Coords coords, BlockSet blocks, Neighbors neighbors) {
        return BlockUtils.isConnectedToShell(coords, blocks, neighbors, null);
    }

    public static boolean isConnectedToShell(Coords coords, final BlockSet blocks, Neighbors neighbors, final Integer maxY) {
        final BoundingBoxInt box = blocks.getBoundingBox();
        int shellVolume = (box.getDx() + 2) * (box.getDy() + 2) * (box.getDz() + 2);
        Boolean result = BlockUtils.searchForCondition(coords, shellVolume, new BlockConditionChecker(){

            @Override
            public boolean isConditionMet(Coords coords) {
                return !box.containsPoint(coords);
            }
        }, new BlockExplorer(){

            @Override
            public boolean shouldExploreBlock(Coords coords) {
                return (maxY == null || coords.y <= maxY) && !blocks.contains(coords);
            }
        }, neighbors);
        if (result == null) {
            throw new Error("We evaluated too many blocks checking for the shell. This shouldn't have happened.");
        }
        return result;
    }

    static {
        try {
            m_chunkPrecipitationHeightMapField = Chunk.class.getDeclaredField(Environment.getRuntimeName("precipitationHeightMap", "field_76638_b"));
            m_chunkPrecipitationHeightMapField.setAccessible(true);
            m_chunkHeightMapField = Chunk.class.getDeclaredField(Environment.getRuntimeName("heightMap", "field_76634_f"));
            m_chunkHeightMapField.setAccessible(true);
            m_chunkStorageArraysField = Chunk.class.getDeclaredField(Environment.getRuntimeName("storageArrays", "field_76652_q"));
            m_chunkStorageArraysField.setAccessible(true);
            m_chunkIsModifiedField = Chunk.class.getDeclaredField(Environment.getRuntimeName("isModified", "field_76643_l"));
            m_chunkIsModifiedField.setAccessible(true);
            m_chunkRelightBlockMethod = Chunk.class.getDeclaredMethod(Environment.getRuntimeName("relightBlock", "func_76615_h"), Integer.TYPE, Integer.TYPE, Integer.TYPE);
            m_chunkRelightBlockMethod.setAccessible(true);
            m_chunkPropagateSkylightOcclusionMethod = Chunk.class.getDeclaredMethod(Environment.getRuntimeName("propagateSkylightOcclusion", "func_76595_e"), Integer.TYPE, Integer.TYPE);
            m_chunkPropagateSkylightOcclusionMethod.setAccessible(true);
        }
        catch (NoSuchFieldException ex) {
            throw new Error(ex);
        }
        catch (SecurityException ex) {
            throw new Error(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new Error(ex);
        }
    }

    public static interface BlockConditionChecker {
        public boolean isConditionMet(Coords var1);
    }

    public static interface BlockCallback {
        public SearchAction foundBlock(Coords var1);
    }

    public static interface BlockExplorer {
        public boolean shouldExploreBlock(Coords var1);
    }

    public static enum SearchAction {
        AbortSearch,
        ContinueSearching;

    }

    public static enum UpdateRules {
        UpdateNeighbors(true, false),
        UpdateClients(false, true),
        UpdateNeighborsAndClients(true, true),
        UpdateNoOne(false, false);

        private boolean m_updateNeighbors;
        private boolean m_updateClients;

        private UpdateRules(boolean updateNeighbors, boolean updateClients) {
            this.m_updateNeighbors = updateNeighbors;
            this.m_updateClients = updateClients;
        }

        public boolean shouldUpdateNeighbors() {
            return this.m_updateNeighbors;
        }

        public boolean shouldUpdateClients() {
            return this.m_updateClients;
        }
    }

    public static enum Neighbors {
        Faces{

            @Override
            public int getNumNeighbors() {
                return BlockSide.values().length;
            }

            @Override
            public void getNeighbor(Coords out, Coords in, int i) {
                BlockSide side = BlockSide.values()[i];
                out.x = in.x + side.getDx();
                out.y = in.y + side.getDy();
                out.z = in.z + side.getDz();
            }
        }
        ,
        Edges{
            private int[] dx = new int[]{0, -1, 1, 0, -1, 1, -1, 1, 0, -1, 1, 0};
            private int[] dy = new int[]{-1, 0, 0, 1, -1, -1, 1, 1, -1, 0, 0, 1};
            private int[] dz = new int[]{-1, -1, -1, -1, 0, 0, 0, 0, 1, 1, 1, 1};

            @Override
            public int getNumNeighbors() {
                return Faces.getNumNeighbors() + this.dx.length;
            }

            @Override
            public void getNeighbor(Coords out, Coords in, int i) {
                if (i < Faces.getNumNeighbors()) {
                    Faces.getNeighbor(out, in, i);
                } else {
                    out.x = in.x + this.dx[i -= Faces.getNumNeighbors()];
                    out.y = in.y + this.dy[i];
                    out.z = in.z + this.dz[i];
                }
            }
        }
        ,
        Vertices{
            private int[] dx = new int[]{-1, 1, -1, 1, -1, 1, -1, 1};
            private int[] dy = new int[]{-1, -1, 1, 1, -1, -1, 1, 1};
            private int[] dz = new int[]{-1, -1, -1, -1, 1, 1, 1, 1};

            @Override
            public int getNumNeighbors() {
                return Edges.getNumNeighbors() + this.dx.length;
            }

            @Override
            public void getNeighbor(Coords out, Coords in, int i) {
                if (i < Edges.getNumNeighbors()) {
                    Edges.getNeighbor(out, in, i);
                } else {
                    out.x = in.x + this.dx[i -= Edges.getNumNeighbors()];
                    out.y = in.y + this.dy[i];
                    out.z = in.z + this.dz[i];
                }
            }
        };


        public abstract int getNumNeighbors();

        public abstract void getNeighbor(Coords var1, Coords var2, int var3);
    }
}

